function xxp = lotkavolterra(~,xx)
% LOTKAVOLTERRA Predator-prey Lotka-Volterra system
%
%   Examples
%       sol1 = ode23(@lotkavolterra,[0 20],[ 20 20 ]);
%       sol2 = ode23(@lotkavolterra,[0 20],[ 100 100 ]);
%       xint = linspace(0,20,500); 
%       yint1 = deval(sol1,xint); yint2 = deval(sol2,xint);
%       subplot(121)
%       plot(xint,yint1,'LineW',1,'Color','k'); hold on
%       plot(xint,yint2,'LineW',2,'Color',[0.6 0.6 0.6])
%       axis square
%       xlabel('time'); ylabel('population'); 
%       subplot(122)
%       plot(yint1(1,:),yint1(2,:),'LineW',1,'Color','k'); hold on
%       plot(yint2(1,:),yint2(2,:),'LineW',2,'Color',[0.6 0.6 0.6])
%       axis square
%       xlabel('number of preys'); ylabel('number of predators'); 
%
%   See also
%
%   Ecole de Printemps SFBT 2012

x = xx(1); y = xx(2);
a = 1; b = 0.01;
c = 1; d = 0.02;

xxp = [ x * (a - b * y)
     -y * (c - d * x)];