function [t,y]=sdeEuler(f,tspan,ic,sdnoise,varargin)
% SDEEULER Stochastic Differential Equation solver with the Euler method
%
%   Examples
%       Solve the equation y'(t) = -0.1*y(t) + 0.1*xi(t)
%       with IC y(0)=1, with 10 realizations
%       [t, y] = sdeEuler(@(t,y) -0.1*y, [0 10],ones(1,10),0.1*ones(1,10));
%       plot(t,y,'k','LineW',0.5); axis tight
%       xlabel('time t'); ylabel('y(t)')
%
%       [t1, y1] = sdeEuler(@lotkavolterra, [0 60],[20 20]',3*ones(2,1));
%       [t2, y2] = sdeEuler(@lotkavolterra, [0 60],[100 100]',3*ones(2,1));
%       clf;
%       subplot(121)
%       plot(t1,y1,'LineW',1,'Color','k'); hold on
%       plot(t2,y2,'LineW',1,'Color',[0.6 0.6 0.6])
%       axis square
%       xlabel('time'); ylabel('population'); 
%       subplot(122)
%       plot(y1(1,:),y1(2,:),'LineW',1,'Color','k'); hold on
%       plot(y2(1,:),y2(2,:),'LineW',1,'Color',[0.6 0.6 0.6])
%       axis square
%       xlabel('number of preys'); ylabel('number of predators'); 
%
%   Ecole de Printemps SFBT 2012

h=.01;
sh=sqrt(h);
t=tspan(1):h:tspan(2);
y=zeros(length(ic),length(t));
y(:,1)=ic;
stopcond=false;
for i=1:length(t)-1,
    y(:,i+1)=y(:,i)+h*feval(f,t,y(:,i),varargin{:})+sh*sdnoise.*randn(size(sdnoise));
    if stopcond && any(y(:,i+1)<0)
        yz =find(y(:,i+1)<0);
        y(yz,i+1)=0;
        sdnoise(yz)=0;
    end
end