function [c,f,s] = turing(x,t,u,DuDx)
% TURING PDE components for the Turing equations
%
%   Examples
%       x = -20:0.1:20;
%       t = 0:20;
%       sol = pdepe(0,@turing,@turingic,@turingbc,x,t);
%       u = sol(:,:,1);
%       v = sol(:,:,2);
%       imagesc(x,t,u); axis xy;
%       colormap gray
%       xlabel('position x'); ylabel('time t')
%
%       plot(x,u(1,:),'Color',[0.6 0.6 0.6],'LineW',1.5) % initial condition
%       hold on 
%       %plot(x,v(1,:),'--','LineW',1.5) % initial condition 
%       plot(x,u(3:2:20,:),'k')
%       %plot(x,u(3:2:20,:),'--k')
%       axis tight
%       xlabel('position x'); ylabel('density u')
%
%   See also: TURINGIC, TURINGBC, PDEPE
%
%   Ecole de Printemps SFBT 2012   

fu = 0.4; fv = -0.5;
gu = 1; gv = -0.5;
f1 = fu * u(1) + fv * u(2);
f2 = gu * u(1) + gv * u(2);
Du = 0.2; Dv = 10;

c = [1 1]';
f = [Du 0; 0 Dv] * DuDx;
s = [f1 f2]';