function [c,f,s] = fkpp(x,t,u,DuDx)
% FKPP PDE components for the FKPP equation
%
%   Examples
%       x = -10:0.1:50;
%       t = 0:0.1:20;
%       sol = pdepe(0,@fkpp,@(x) (x<=0),@fkppbc,x,t);
%       u1 = sol(:,:,1);
%       imagesc(x,t,u1); axis xy;
%       colormap gray
%       xlabel('position x'); ylabel('time t')
%
%       plot(x,u1(1,:),'LineW',2,'Color',[0.6 0.6 0.6]) % initial condition
%       hold on 
%       plot(x,u1(21:20:201,:),'k')
%       axis tight
%       xlabel('position x'); ylabel('density \rho')
%
%   See also: FKPPBC, PDEPE
%
%   Ecole de Printemps SFBT 2012   

r = 1; D = 1;

c = 1;
f = D * DuDx;
s = r * u .* (1 - u);