function [c,f,s] = fokkerplanck(x,t,u,DuDx)
% FOKKERPLANCK PDE components for the Fokker-Planck equation
%
%   Examples
%       x = -1:0.1:1.2;
%       t = 0:0.1:30;
%       sol = pdepe(0,@fokkerplanck,@(x) 10*(x>=1).*(x<=1.1),@fokkerplanckbc,x,t);
%       u1 = sol(:,:,1);
%       surf(x,t,u1);
%
%   See also: FOKKERPLANCKBC, PDEPE
%
%   Ecole de Printemps SFBT 2012   

r = 0.1; D = 0.5 * (0.1)^2;

c = 1;
f = D * DuDx + r * x * u;
s = 0;