function [c,f,s] = kellersegel(~,~,u,DuDx)
% KELLERSEGEL PDE components for Keller-Segel equations
%
%   Examples
%       x = -1.5:0.01:1.5;
%       t = 0:0.01:2.5;
%       sol = pdepe(0,@kellersegel,@kellersegelic,@kellersegelbc,x,t);
%       u = sol(:,:,1);
%       v = sol(:,:,2);
%       imagesc(x,t,u); axis xy;
%       colormap hsv
%       xlabel('position x'); ylabel('time t')
%
%       plot(x,u(1,:),'Color',[0.6 0.6 0.6],'LineW',1.5) % initial condition
%       hold on 
%       plot(x,u([26 51 101 151 201 226 251],:),'k')
%       axis([-1.5 1.5 0 20])
%       xlabel('position x'); ylabel('density u')
%
%
%   See also: KELLERSEGELIC, KELLERSEGELBC, PDEPE
%
%   Ecole de Printemps SFBT 2012

a = 0.1;
f1 = 0;
f2 = u(1) - a * u(2);
d = 0.5; epsilon = 0.05; %0.01

c = [1 1]';
f = [d, -u(1); 0 epsilon] * DuDx;
s = [f1 f2]';