function [dwt,indmaxband,Jmax] = DWTexact(x,h)
% Syntax:	[dwt,indmaxband,Jmax] = DWTexact(x,h)
% Objective:	Compute the discrete wavelet transform of the data for
%		the pyramidal algorithm, with no border effect.
% Input:	x : raw data
%		h : qmf filter (a.k.a scaling filter, as returned by the
%		scalingfilter function)
% Output:	dwt : computable detail Wavelet coefficients with no
%		      border effect
%		indmaxband : vector containing the largest index of each
%			band, ie the wavelet coefficients of scale j are dwt(k)
%			for k = indmaxband(j-1)+1 to indmaxband(j) for j > 1 and
%			k = 1 to indmaxband(1) for j=1.
%		Jmax : largest available scale index (=length of
%		       indmaxband)
%
% Authors: Gilles Fay, Eric Moulines, Franois Roueff. 

h = h(:);
n = length(x);
N = length(h);
g= flipud(h.*(-1).^(0:N-1)');


[nscale,Jmax]=  computenj(n,N);

indmaxband = cumsum(nscale);

dwt = zeros(indmaxband(end),1);

aold= x;

%
%... Pyramidal algorithm
%

indmin = 1;
for iscale= 1:Jmax,
  acur = zeros(nscale(iscale),1);
  d = zeros(nscale(iscale),1);
  offset=1;
  for p=1:nscale(iscale),
    acur(p)= h'*aold(offset:offset+N-1);
    dwt(indmin+p-1) = g'*aold(offset:offset+N-1);
    offset= offset+2;
  end
  aold= acur;
  indmin = indmaxband(iscale)+1;
end
