function [K] = K_eval(psi_hat,u,d)

% K_eval.m computes the matrix whith elements
% K(dl,dm)=int( u^(dl+dm) |psi_hat|^2 du )
% 
% 	INPUT	d 	kx1 parameter value
%               psi_hat	the Fourier transform of the wavelet mother at
%               	values u
%               u 	the grid for the approximation of the integral
%
%                                           Achard & Gannaz (2014)
%______________________________________________________________________


m = length(psi_hat);
k = length(d);

K_fct = zeros(k,m);
for j=1:k
    K_fct(j,:) = (abs(u+(u==0)).^(-d(j))-(u==0)).*psi_hat;
end
K = K_fct*transpose(conj(K_fct))*(max(u)-min(u))/m;

K = real(K);

end
