function [dx] = fracdiff(x,d)

% Vectorial fractional differencing procedure
%
% INPUT  x	Initial process
%        d	Vector of long-range dependence parameters
%
% OUTPUT 	diag((1-L)^d) x
%
%                                      Achard & Gannaz (2014)
%___________________________________________________________

[N, k] = size(x);
dx = x;

if(length(d)~=k)
	error('The number of components in x and the number of dependence parameters d must be the same')
end;

a = [1:(N-1)]';
for i=1:k
	b = (a+d(i)-1)./a;
	b = [1; cumprod(b)];
	dx(:,i) = filter(b,1,x(:,i));
end;

