function [phi,psi]= makescalingfunction(qmf,J,graphic)
% Objective: Compute the scaling function and the wavelet function (for compactly supported wavelet) using the
% cascade algorithm on the grid of dyadic integer $2^{-\text{J}}$ 
% Input: qmf = filter coefficients
%        J   : largest scaling function
%        graphic : switch (if graphic == 1, then display the results)
%
% Output: phi = scaling function
%         psi = wavelet function
%
%
%									   Faÿ, Moulines, Roueff, 2009
%____________________________________________________________________________________________________________

%
%... compute first the scaling functions on the integers
%
qmf= qmf(:);
N= size(qmf,1);
Htmp= toeplitz([qmf;zeros(N-1,1)],[qmf(1), zeros(1,N-1)]);
for irow=1:N,
    H(irow,:)= Htmp(2*(irow-1)+1,:);
end 
H= sqrt(2)*H;
[V,D]= eig(H);
j=1;
while (abs(D(j,j)-1) >= 1.0e-5)
    j=j+1;
end
phi= V(:,j);
phi= phi/sum(phi);
if (graphic == 1)
    stem(0:(N-1),phi)
    pause
end
a= sqrt(2)*qmf;
%
%... cascade algorithm
%
for j=1:J-1,
    phi= conv(phi,a);
    a= upsample(a,2);
    if (graphic == 1)
        stem(linspace(0,N-1,2^j*(N-1)+1),phi(1:2^j*(N-1)+1));
        pause
    end
end    
%
%... compute the final scaling / wavelet function (using the wavelet
%... scaling equation)
%
b= sqrt(2)*flipud(qmf.*(-1).^(0:N-1)');
b= upsample(b,2^(J-1));
psi= conv(phi,b);
phi= conv(phi,a);
if (graphic==1)
    figure(1)
    title('Scaling Function')
    stem(linspace(0,N-1,2^J*(N-1)+1),phi(1:2^J*(N-1)+1));
    figure(2)
    title('Wavelet Function')
    stem(linspace(0,N-1,2^J*(N-1)+1),psi(1:2^J*(N-1)+1));
end
phi= phi(1:2^J*(N-1)+1);
psi= psi(1:2^J*(N-1)+1);
