function [g] = mww_cov(d,x,qmf,psih,grid_psih,LU)
% mww_eval.m computes the multivariate Wavelet Whittle criterion 
% for the estimation of the long-memory parameter at value d, with exact 
% DWT of Faÿ et al (2009).
%
% 
% 	INPUT	d 	kx1 parameter value
%           x	data (nxk vector)
%		filter  the wavelet filter
%               LU	the first and maximal resolution level used for 
%               	estimation in wavelet decomposition (optional)
%				
%                                           Achard & Gannaz (2014)
%______________________________________________________________________

[N,k] = size(x);

[psih, grid_psi]= psi_hat_exact(qmf,round(log2(N)));

% Wavelet decomposition
xwav = zeros(N,k);
for j=1:k
    xx = x(:,j);
    [xwav_temp,index,Jmax] = DWTexact(xx,qmf);
    xwav(1:index(Jmax),j) = xwav_temp;
end
% we free some memory
if (index(Jmax)<N)
    xwav((index(Jmax)+1):N,:) = [];
end;
index = [0 index];


g = mww_wav_cov(d,xwav,index,psih,grid_psih,LU);


end
