function [g] = mww_wav_cov(d,xwav,index,psih,grid_psih,LU)
% mww_wav_cov.m computes the multivariate wavelet Whittle estimator 
% of the long-run correlation matrix with exact DWT of Faÿ et al (2009). 
% 
% 	INPUT	d 	    kx1 parameter value
%               x 	    data (nxk vector)
%		filter      the wavelet filter
%               psih        the Fourier transform of the wavelet mother at
%               	    values grid_psih
%               grid_psih    the grid for the approximation of the integral 
%               	    in K
%               LU 	    the lowest and maximal resolution in wavelet 
%			    decomposition (optional)
%
%                                                   Achard & Gannaz (2014)
%_________________________________________________________________________


[~, k] = size(xwav);
Jmax = length(index)-1;

% Wavelet scales
if (nargin<=5)
    LU = [1 Jmax];
end
L = max(LU(1),1);
U = min(LU(2),Jmax);
nscale = U-L+1;

n = index(U+1)-index(L);

% Estimation of G
sum_xwav = zeros(nscale,k,k);
for f=1:nscale
	j = L+f-1;
        fj = 1-j; 
        temp = xwav((index(j)+1):index(j+1),:)*diag(2.^(fj*d));
        sum_xwav(f,:,:) = transpose(temp)*temp;
end;
g_temp = sum(sum_xwav,1)/n;
g = zeros(k,k);
g(:,:) = g_temp(1,:,:);

% Correction of the phase shift
K = K_eval(psih,grid_psih,d);
K = (diag(exp(-1i*pi.*d/2))*K*diag(exp(1i*pi.*d/2)));
K = (real(K));

g = g.*(K.^-1);


end
