function[covar]=covmatrix(r,s,t,n,type)
%%% The function returns the covariance matrix of the vector
%%% Vn=(X(d1),...,X(dn)) if type=1
%%% Wn=(X(d1),...,X(dn-1),X'(dn),X(dn)) if type=2
%%% when X is a centered Gaussian process of covariance function r and
%%% where d1,...,dn is an equidistant discretization of [s,t].

dis=s+(t-s)*(0:n-1)/(n-1);
discret=repmat(dis',[1,n]); %discretization of [s,t] into n points and copies
syms x y
covarfun=inline(vectorize(r));
covar=feval(covarfun,discret,discret'); %covariance matrix of Vn

if type==3
p=find(dis==min(abs(dis)));
covarlim0p=inline(vectorize(limit(covarfun(x,y),x,0,'right')));
covar(p,:)=feval(covarlim0p,dis);
covar(:,p)=covar(p,:)';
covar(p,p)=eval(limit(covarlim0p(y),y,0,'right'));
end

if (isnan(feval(covarfun,s,t))==1)&(isnan(feval(covarfun,s+0.1,t))==1)
    % t is singular
    covarlimt=inline(vectorize(limit(covarfun(x,y),x,t,'left')));
    covar(:,n)=feval(covarlimt,discret(:,1));
    covar(n,:)=covar(:,n)';
    covar(n,n)=eval(limit(covarlimt(y),y,t,'left'));
    if type==2
        covardfun=inline(vectorize(diff(r,x)));
        covardlimt=inline(vectorize(limit(covardfun(x,y),x,t,'left')));
        covard=[feval(covardlimt,discret(1:n-1,1)') eval(limit(covardlimt(y),y,t,'left'))]; %covariance of X'(dn) with Vn
        covardd=eval(limit(limit(diff(diff(r,x),y),x,t,'left'),y,t,'left')); %variance of X'(dn)
        %covariance matrix of Wn
        covar=[[covar(1:n-1,1:n-1) covard(1:n-1)' covar(1:n-1,n)];[covard(1:n-1) covardd covard(n)];[covar(n,1:n-1) covard(n) covar(n,n)]];
    end
    
elseif (isnan(feval(covarfun,s,t))==1)&(isnan(feval(covarfun,s,t+0.1))==1)
    % s is singular
    covarlims=inline(vectorize(limit(covarfun(x,y),x,s,'right')));
    covar(:,1)=feval(covarlims,discret(:,1));
    covar(1,:)=covar(:,1)';
    covar(1,1)=eval(limit(covarlims(y),y,s,'right'));
    if type==2
        covardfun=inline(vectorize(diff(r,x)));
        covard=[eval(limit(covardfun(t,y),y,s,'right')) feval(covardfun,t,discret(2:n,1)')]; %covariance of X'(dn) with Vn
        covardd=feval(inline(vectorize(diff(diff(r,x),y))),t,t); %variance of X'(dn)
        %covariance matrix of Wn
        covar=[[covar(1:n-1,1:n-1) covard(1:n-1)' covar(1:n-1,n)];[covard(1:n-1) covardd covard(n)];[covar(n,1:n-1) covard(n) covar(n,n)]];
    end
elseif sum(sum(isnan(covar)))>0
    % discretized point is singular
    indice=min(find(isnan(covar)==1));
    if indice>n
        indice=round(indice/100);
    end
    singular=s+(t-s)*(indice-1)/(n-1);
    gammr=inline(vectorize(limit(covarfun(x,y),y,singular,'right')));
    gamml=inline(vectorize(limit(covarfun(x,y),y,singular,'left')));
    covar(indice,:)=[feval(gamml,discret(1:indice,1)') feval(gammr,discret(indice+1:n,1)')];
    covar(:,indice)=covar(indice,:)';
    covar(indice,indice)=eval(limit(limit(covarfun(x,y),y,singular,'right'),x,singular,'right'));
    if type==2
        covardfun=inline(vectorize(diff(r,x)));
        covard=feval(covardfun,t,discret(:,1)');  %covariance of X'(discret(n)) with Vn
        covard(indice)=eval(limit(covardfun(t,y),y,singular,'right')); 
        covardd=feval(inline(vectorize(diff(diff(r,x),y))),t,t); %variance of X'(dn)
        %covariance matrix of Wn
        covar=[[covar(1:n-1,1:n-1) covard(1:n-1)' covar(1:n-1,n)];[covard(1:n-1) covardd covard(n)];[covar(n,1:n-1) covard(n) covar(n,n)]];
    end
else
    % no singular point
    if type==2
        covard=feval(inline(vectorize(diff(r,x))),t,discret(:,1)');  %covariance of X'(discret(n)) with Vn
        covardd=feval(inline(vectorize(diff(diff(r,x),y))),t,t); %variance of X'(dn)
        %covariance matrix of Wn
        covar=[[covar(1:n-1,1:n-1) covard(1:n-1)' covar(1:n-1,n)];[covard(1:n-1) covardd covard(n)];[covar(n,1:n-1) covard(n) covar(n,n)]];
    end
end    