## ROOT SYSTEM
type='D';rk=6;n=2*rk


Root=RootSystem([type,rk])
Weyl=WeylGroup([type,rk])
sr = Weyl.simple_reflections()

## DATUM
wtest=sr[2]*sr[3]*sr[1]*sr[2]*sr[4]*sr[2]
vtest=wtest*sr[2]

covers = [[w,v]  for w in Weyl for v in w.bruhat_lower_covers()]

def bar0(i,n):
    return(n-1-i)

def mytransp(A): # Q.inverse()*Xi.transpose()*Q
    m=A.nrows()
    M=matrix(R,m)
    for i in range(m):
    	for j in range(m):
	     M[i,j]=A[bar0(j,m),bar0(i,m)]
    return(M)     

def mytranspZ(A): # Q.inverse()*Xi.transpose()*Q
    m=A.nrows()
    M=matrix(ZZ,m)
    for i in range(m):
    	for j in range(m):
	     M[i,j]=A[bar0(j,m),bar0(i,m)]
    return(M)


def tri_insertion_roots(L):
    N = len(L)
    for n in range(1,N):
        cle = L[n]
        j = n-1
        while j>=0 and L[j].height() > cle.height():
            L[j+1] = L[j] # decalage
            j = j-1
        L[j+1] = cle
    return(L)    



def Position(theta) : # return the coordinates of an entry of the matrix containing the coordinate in  Lie(G) of weight theta
    va=theta.to_ambient()
    if sum(va[i] for i in range(n/2))==0 :
        for k in range(n/2) :
            if va[k]==1 :
                j=k+1
            else :
                if va[k]==-1 : i=k+1
        return([i-1,j-1])                         
    else :
        prems=True
        for k in range(n/2) :
            if va[k]==1 :
                if prems :
                    i1=k+1
                    prems=False
                else :
                    i2=k+1
        return([n-i1,i2-1])
    
def PointTangent(theta) : #generate a point in Lie(G) of weight theta 
    #nvar=0
    A=matrix(ZZ,n/2)
    B=matrix(ZZ,n/2)
    #for a in  Invers:
    va=theta.to_ambient()
    if sum(va[i] for i in range(n/2))==0 :
        for k in range(n/2) :
            if va[k]==1 :
                j=k+1
            else :
                if va[k]==-1 : i=k+1
        A[i-1,j-1]=1                         
    else :
        prems=True
        for k in range(n/2) :
            if va[k]==1 :
                if prems :
                    i1=k+1
                    prems=False
                else :
                    i2=k+1
        B[n/2-i1,i2-1]=1
        B=B-mytranspZ(B)
    return(block_matrix([[A,matrix(ZZ,n/2)],[B,-mytranspZ(A)]]))




N=0
hmax=0
for a in Root.root_lattice().positive_roots() :
    N=N+1
    if a.height()>hmax : hmax=a.height()
    
Q=matrix(ZZ,n)
for i in range(n) : Q[i,n-1-i]=1
    
R = PolynomialRing(QQ, 'x', N)
R.inject_variables()

# On génère Xi, une matrice aléatoire de 
A1=matrix(ZZ,n/2)
for i in range(n/2-1):
    for j in range(i+1,n/2):
        A1[i,j]=ZZ.random_element(-100,100)

A1=matrix(R,n/2)
c=0
for i in range(n/2-1):
    for j in range(i+1,n/2):
        A1[i,j]=R('x'+str(c))
        c=c+1
        
C1=matrix(R,n/2)
for i in range(n/2-1):
    for j in range(n/2-i-1):
        C1[i,j]=R('x'+str(c))
        C1[n/2-1-j,n/2-1-i]=-R('x'+str(c))
        c=c+1


Xi=block_matrix([[A1,C1],[matrix(R,n/2),-mytransp(A1)]])
print 'Point de Lie(U^-)'
print(Xi);print '\n'


Um=exp(Xi)
Umi=exp(-Xi)

print 'Point de U^-. Exp de Xi'
#print(Um);print '\n'




#v=Weyl.long_element()

def ComputeM(Iw,Iv) :
    M=matrix(R,len(Iw),len(Iv))
    l=-1
    for theta in Iv:
        l=l+1
        T=PointTangent(theta)
        Tt=Um*T*Umi
        k=-1
        for rho in Iw :
            k=k+1
            [i,j]=Position(rho)
            M[k,l]=Tt[i,j]
    return(M)

print 'The matrices D:' 

coversStrong=[]
cpt=0
cpT=0
for [w,v] in covers[29300:] :
    cpT=cpT+1
    if (v*w.inverse()).length()>1 :
        #if w==wtest and v==vtest : print 'OK'
        Invv=[];Invw=[]
        for a in v.inversions(inversion_type='roots') : Invv.append(a)
        tri_insertion_roots(Invv)
        for a in w.inversions(inversion_type='roots') : Invw.append(a)
        tri_insertion_roots(Invw)
        hvector_v=vector(ZZ,hmax);hvector_w=vector(ZZ,hmax)
        for a in Invv:
            h=a.height()
            hvector_v[h-1]=hvector_v[h-1]+1
        for a in Invw:
            h=a.height()
            hvector_w[h-1]=hvector_w[h-1]+1
        Hvector_v=[sum(hvector_v[j] for j in range(i+1)) for i in range(hmax)]
        Hvector_w=[sum(hvector_w[j] for j in range(i+1)) for i in range(hmax)] 
        if w==wtest and v==vtest : print hvector_w,hvector_v,Hvector_w,Hvector_v
        TestH1=True
        for h in range(hmax) :
            if Hvector_v[h]>Hvector_w[h] : TestH1=False
        #if w==wtest and v==vtest : print TestH1        
        if TestH1 :
            TestH2=True
            for h in range(hmax) :
                if Hvector_v[h]==Hvector_w[h] :
                    Inclusion=True
                    for a in Invv :
                        if ((a.height()==h+2) and (a not in Invw)) :
                            Inclusion=False
                    if  Inclusion==False :
                        TestH2=False
            #if w==wtest and v==vtest : print TestH2            
            if TestH2 :
                cpt=cpt+1
                if cpt==5000 : break
                coversStrong.append([w,v,Invw,Invv,hvector_v,hvector_w])

def Betai(Invw,Invv): # Compute the beta_i's as in Proposition 24
    L=[]
    for a in Invw :
        if a not in Invv :
            L.append(a)
    return L        
            
def Gammai(Invw,Invv): # Compute the gamma_i's as in Proposition 24
    L=[]
    for a in Invv :
        if a not in Invw :
            L.append(a)
    return L

print len(covers),len(coversStrong)

for [w,v,Invw,Invv,hvector_v,hvector_w] in coversStrong :
  if w.length()==6:  
    #print w.reduced_word(),v.reduced_word()
    Gi=Gammai(Invw,Invv)
    Bi=Betai(Invw,Invv)
    #print len(Betai(Invw,Invv)),len(Gammai(Invw,Invv))
    for i in range(len(Bi)-1):
        Ic=[]
        for a in Invv :
            if (a in Invw) and (a.height()<Gi[i].height()) and (Bi[0].height()<a.height()):
                Ic.append(a)
        #print latex(ComputeM(Ic+[Bi[i]],Ic+Gi[i]))   
        if len(Ic)>2 :
            print w.reduced_word(),v.reduced_word()
            print ComputeM([Bi[i]]+Ic,Ic+[Gi[i]])  

