clear all,close all,clf;
f=@(x) 2*cos(2*x)./(1+cos(2*x));
g=@(x) tan(x).^2;
fplot(f,'k','linewidth',2);
hold on;
fplot(g,'r','linewidth',2);
axis([-pi pi -10 10])
legend('f:x->2cos(2x)/(1+cos(2x))','g:x->tan^2(x)')

figure

h=@(x) f(x)+g(x);
fplot(h,'b','linewidth',2);
axis([-pi/2+0.1 pi/2+0.1 -10 10])
legend('f+g')

figure

F=@(t) 2./(1+tanh(t));
G=@(t) exp(2*t);
fplot(F,'k','linewidth',2);
hold on;
grid on ;
fplot(G,'r','linewidth',2);
axis([-3 3 0 10])
legend('F:t->2/(1+th(t))','G:t->e^{2t}')
figure

H=@(t) F(t)-G(-t);
fplot(H,'b','linewidth',2);
axis([-2 2 0 10])
legend('t->F(t)-G(-t)')