/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans;

import com.adesoft.beans.AdeList;
import com.adesoft.beans.EventsRectangles;
import com.adesoft.beans.PlanningManager;
import com.adesoft.beans.RemoteSelecters;
import com.adesoft.beans.SessionBean;
import com.adesoft.beans.TimetableUrl;
import com.adesoft.beans.XmlMessage;
import com.adesoft.beans.filters.FiltersActivities;
import com.adesoft.beans.filters.FiltersEvents;
import com.adesoft.beans.filters.FiltersFilters;
import com.adesoft.beans.filters.FiltersLinks;
import com.adesoft.beans.filters.FiltersParticipants;
import com.adesoft.beans.filters.FiltersTrash;
import com.adesoft.beans.settings.ActivitySettings;
import com.adesoft.beans.settings.CalendarSettings;
import com.adesoft.beans.settings.CaracteristicSettings;
import com.adesoft.beans.settings.CostSettings;
import com.adesoft.beans.settings.DisplaySettings;
import com.adesoft.beans.settings.EngineSettings;
import com.adesoft.beans.settings.EventSettings;
import com.adesoft.beans.settings.FilterSettings;
import com.adesoft.beans.settings.FolderSettings;
import com.adesoft.beans.settings.GroupSettings;
import com.adesoft.beans.settings.LinkSettings;
import com.adesoft.beans.settings.ParticipantSettings;
import com.adesoft.beans.settings.ProjectSettings;
import com.adesoft.beans.settings.UserSettings;
import com.adesoft.config.ConfigManager;
import com.adesoft.config.ServerLocation;
import com.adesoft.errors.AdeException;
import com.adesoft.errors.EntityGroupError;
import com.adesoft.errors.InvalidFile;
import com.adesoft.errors.NotFoundException;
import com.adesoft.errors.PermissionException;
import com.adesoft.errors.ProjectNotFoundException;
import com.adesoft.fastxml.XmlWriter;
import com.adesoft.login.WebSessions;
import com.adesoft.misc.Util;
import com.adesoft.oracle.ResultSetProxy;
import com.adesoft.properties.ServerProperty;
import com.adesoft.server.RemoteSelecter;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Element;
import org.jdom.JDOMException;

public final class AdeBean
extends SessionBean {
    public static final String SERVERADE = "serverAde";
    public static final String SERVERWEB = "serverWeb";
    public static final String LOGIN = "login";
    public static final String PASSWORD = "password";
    public static final String IDENTIFIER = "identifier";
    public static final String PROJECTID = "projectId";
    public static final String SERVERADEPORT = "serverAdePort";
    public static final String JDBCDRIVER = "jdbcDriver";
    public static final String JDBCLOGIN = "jdbcLogin";
    public static final String JDBCPASSWORD = "jdbcPassword";
    public static final String JDBCSOURCE = "jdbcSource";
    public static final String GLOBAL_ADD_GROUP = "GLOBAL_ADD_GROUP";
    public static final String GLOBAL_ADD_USER = "GLOBAL_ADD_USER";
    public static final String GLOBAL_CREATE_PROJECT = "GLOBAL_CREATE_PROJECT";
    public static final String GLOBAL_MODIFY_GROUP = "GLOBAL_MODIFY_GROUP";
    public static final String GLOBAL_MODIFY_RIGHTS = "GLOBAL_MODIFY_RIGHTS";
    public static final String GLOBAL_MODIFY_USER = "GLOBAL_MODIFY_USER";
    public static final String GLOBAL_REMOVE_GROUP = "GLOBAL_REMOVE_GROUP";
    public static final String GLOBAL_REMOVE_USER = "GLOBAL_REMOVE_USER";
    public static final String PROJECTS_CREATE_ACTIVITY = "PROJECTS_CREATE_ACTIVITY";
    public static final String PROJECTS_CREATE_LINK = "PROJECTS_CREATE_LINK";
    public static final String PROJECTS_CREATE_PARTICIPANT = "PROJECTS_CREATE_PARTICIPANT";
    public static final String PROJECTS_CREATE_STUDENT = "PROJECTS_CREATE_STUDENT";
    public static final String PROJECTS_CREATE_TEACHER = "PROJECTS_CREATE_TEACHER";
    public static final String PROJECTS_CREATE_ROOM = "PROJECTS_CREATE_ROOM";
    public static final String PROJECTS_CREATE_EQUIPMENT = "PROJECTS_CREATE_EQUIPMENT";
    public static final String PROJECTS_CREATE_CATEGORY5 = "PROJECTS_CREATE_CATEGORY5";
    public static final String PROJECTS_CREATE_CATEGORY6 = "PROJECTS_CREATE_CATEGORY6";
    public static final String PROJECTS_CREATE_CATEGORY7 = "PROJECTS_CREATE_CATEGORY7";
    public static final String PROJECTS_CREATE_CATEGORY8 = "PROJECTS_CREATE_CATEGORY8";
    public static final String PROJECTS_EDIT_CALENDAR = "PROJECTS_EDIT_CALENDAR";
    public static final String PROJECTS_EDIT_COSTS = "PROJECTS_EDIT_COSTS";
    public static final String PROJECTS_EDIT_DEFAULT_GRID = "PROJECTS_EDIT_DEFAULT_GRID";
    public static final String PROJECTS_EDIT_SPECIFIC_GRID = "PROJECTS_EDIT_SPECIFIC_GRID";
    public static final String PROJECTS_MODIFY_RIGHTS = "PROJECTS_MODIFY_RIGHTS";
    public static final String PROJECTS_START_OPTIMIZATION = "PROJECTS_START_OPTIMIZATION";
    public static final String PROJECTS_FORCE_SCHEDULING = "PROJECTS_FORCE_SCHEDULING";
    public static final String PROJECTS_MODIFY_OPTIMIZATION_PARAMETERS = "PROJECTS_MODIFY_OPTIMIZATION_PARAMETERS";
    private String jdbcDriver = "";
    private String jdbcLogin = "";
    private String jdbcPassword = "";
    private String jdbcSource = "";
    private Connection con = null;
    private Statement stmt = null;
    public static final String NOT_AVAILABLE = "not_available";
    public static final String VACATION_SLOT = "vacation_slot";
    public static final String MAXIMAL_PRIORITY = "maximal_priority";
    public static final String MEDIUM_PRIORITY = "medium_priority";
    public static final String MINIMAL_PRIORITY = "minimal_priority";
    public static final String NONE = "none";
    public static final String READ = "read";
    public static final String USE = "use";
    public static final String RW = "rw";
    public static final String ALL = "all";
    public static final String OWNER = "owner";
    public static final String OWNER_GROUPS = "ownerGroups";
    private final Map allParameters = new TreeMap();

    public AdeBean() {
        this.initServer();
    }

    private void initServer() {
        this.setParameter(SERVERADE, ServerLocation.getInstance().getServerHost(), null);
        this.setParameter(SERVERADEPORT, "" + ServerLocation.getInstance().getServerPort(), null);
        this.setParameter(SERVERWEB, ConfigManager.getInstance().getProperty(ServerProperty.WEB_SERVER), null);
    }

    public Element addActivityParticipant(int n, int n2, int n3) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRoot(this.getRemote().addCourseParticipant(this.getIdentifier(), this.getProjectId(), n, n2, n3, 1, false));
    }

    public void setParticipantCaracteristic(int n, int n2, double d) throws ProjectNotFoundException, AdeException, RemoteException, EntityGroupError {
        this.getRemote().addParticipantCaracteristic(this.getIdentifier(), this.getProjectId(), n, n2, d);
    }

    public void addLinkActivity(int n, int n2) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().addLinkCourse(this.getIdentifier(), this.getProjectId(), n, n2);
    }

    public void addUserGroup(int n, int n2) throws RemoteException, AdeException {
        this.getRemote().addUserGroup(this.getIdentifier(), n, n2);
    }

    public void removeUserGroup(int n, int n2) throws RemoteException, AdeException {
        this.getRemote().removeUserGroup(this.getIdentifier(), n, n2);
    }

    public void addParticipantSetupTime(int n, int n2, int n3, boolean bl) throws AdeException, ProjectNotFoundException, NotFoundException, RemoteException, EntityGroupError {
        this.getRemote().addParticipantSetupTime(this.getIdentifier(), this.getProjectId(), n, n2, n3, bl);
    }

    public void updateParticipantSetupTime(int n, int n2, int n3, boolean bl) throws AdeException, ProjectNotFoundException, NotFoundException, RemoteException, EntityGroupError {
        this.getRemote().updateParticipantSetupTime(this.getIdentifier(), this.getProjectId(), n, n2, n3, bl);
    }

    public void removeParticipantSetupTime(int n, int n2) throws AdeException, ProjectNotFoundException, NotFoundException, RemoteException, EntityGroupError {
        this.getRemote().removeParticipantSetupTime(this.getIdentifier(), this.getProjectId(), n, n2);
    }

    public boolean checkConnection(HttpServletResponse httpServletResponse) {
        return true;
    }

    public int createActivity(ActivitySettings activitySettings) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().createCourse(this.getIdentifier(), this.getProjectId(), activitySettings);
    }

    public int createFolder(FolderSettings folderSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().createFolder(this.getIdentifier(), this.getProjectId(), folderSettings);
    }

    public int createGroup(String string) throws RemoteException, AdeException {
        return this.getRemote().createGroup(this.getIdentifier(), new GroupSettings(string));
    }

    public int createLink(LinkSettings linkSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().createLink(this.getIdentifier(), this.getProjectId(), linkSettings);
    }

    public int createParticipant(ParticipantSettings participantSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().createEntity(this.getIdentifier(), this.getProjectId(), participantSettings);
    }

    public int createProject(String string) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().createProject(this.getIdentifier(), new ProjectSettings(string));
    }

    public int createUser(UserSettings userSettings) throws RemoteException, AdeException {
        return this.getRemote().createUser(this.getIdentifier(), userSettings);
    }

    public int duplicateFolderActivity(int n, boolean bl) throws ProjectNotFoundException, AdeException, RemoteException {
        return this.getRemote().duplicateFolderActivity(this.getIdentifier(), this.getProjectId(), n, bl, false);
    }

    public int duplicateActivity(int n) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().duplicateCourse(this.getIdentifier(), this.getProjectId(), n);
    }

    public ResultSet executeSQLQuery(String string) throws SQLException {
        if (null == this.jdbcDriver || 0 == this.jdbcDriver.length()) {
            throw new IllegalArgumentException("You must set the JDBC Driver.");
        }
        if (null == this.jdbcSource || 0 == this.jdbcSource.length()) {
            throw new IllegalArgumentException("You must set the JDBC Source.");
        }
        try {
            Class.forName(this.jdbcDriver);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("JDBC Driver not found : " + this.jdbcDriver);
        }
        this.con = DriverManager.getConnection(this.jdbcSource, this.jdbcLogin, this.jdbcPassword);
        this.stmt = this.con.createStatement();
        ResultSet resultSet = this.stmt.executeQuery(string);
        return ResultSetProxy.newInstance(resultSet);
    }

    public void executeSQLUpdate(String string) throws SQLException {
        if (null == this.jdbcDriver || 0 == this.jdbcDriver.length()) {
            throw new IllegalArgumentException("You must set the JDBC Driver.");
        }
        if (null == this.jdbcSource || 0 == this.jdbcSource.length()) {
            throw new IllegalArgumentException("You must set the JDBC Source.");
        }
        try {
            Class.forName(this.jdbcDriver);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("JDBC Driver not found : " + this.jdbcDriver);
        }
        this.con = DriverManager.getConnection(this.jdbcSource, this.jdbcLogin, this.jdbcPassword);
        this.stmt = this.con.createStatement();
        this.stmt.executeUpdate(string);
    }

    public void closeSqlConnection() throws SQLException {
        this.stmt.close();
        this.con.close();
    }

    public Element getEventFirstAvailability(EventSettings eventSettings, int n, int n2) throws NotFoundException, ProjectNotFoundException, RemoteException {
        return this.getRoot(this.getRemote().getEventFirstAvailability(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getActivityId(), eventSettings.getSession(), eventSettings.getRepetition(), n, n2));
    }

    public Element getActivityAvailabilities(int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getCourseDispos(this.getIdentifier(), this.getProjectId(), n));
    }

    public Element getDefaultAvailabilities() throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getDefaultDispos(this.getIdentifier(), this.getProjectId()));
    }

    public Element getActivityById(int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getCourseById(this.getIdentifier(), this.getProjectId(), n, 0, false));
    }

    public Element getActivityById(int n, int n2) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getCourseById(this.getIdentifier(), this.getProjectId(), n, n2, false));
    }

    public Element getActivityParticipants(int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getCourseParticipants(this.getIdentifier(), this.getProjectId(), n, false));
    }

    public Element getDayNames() throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getDayNames(this.getIdentifier(), this.getProjectId()));
    }

    public int getDisplay(HttpServletRequest httpServletRequest) {
        int n = 0;
        if (null != httpServletRequest.getParameter("display_room")) {
            ++n;
        }
        if (null != httpServletRequest.getParameter("display_instructor")) {
            n += 2;
        }
        if (null != httpServletRequest.getParameter("display_students")) {
            n += 4;
        }
        if (null != httpServletRequest.getParameter("display_resource")) {
            n += 8;
        }
        if (null != httpServletRequest.getParameter("display_activity")) {
            n += 16;
        }
        if (null != httpServletRequest.getParameter("display_hour")) {
            n += 32;
        }
        if (null != httpServletRequest.getParameter("display_activity_type")) {
            n += 64;
        }
        if (null != httpServletRequest.getParameter("display_occupation")) {
            n += 128;
        }
        if (null != httpServletRequest.getParameter("display_nocolor")) {
            n += 256;
        }
        if (null != httpServletRequest.getParameter("display_cumulative")) {
            n += 512;
        }
        if (null != httpServletRequest.getParameter("display_notavailable")) {
            n += 1024;
        }
        if (null != httpServletRequest.getParameter("display_available")) {
            n += 2048;
        }
        if (null != httpServletRequest.getParameter("display_links")) {
            n += 4096;
        }
        if (null != httpServletRequest.getParameter("display_dates")) {
            n += 8192;
        }
        if (null != httpServletRequest.getParameter("display_slotgrid")) {
            n += 16384;
        }
        if (null != httpServletRequest.getParameter("display_wraplines")) {
            n += 32768;
        }
        if (null != httpServletRequest.getParameter("display_day")) {
            n += 65536;
        }
        if (null != httpServletRequest.getParameter("display_week")) {
            n += 131072;
        }
        if (null != httpServletRequest.getParameter("display_hidehours")) {
            n += 262144;
        }
        if (null != httpServletRequest.getParameter("display_activityId")) {
            n += 524288;
        }
        if (null != httpServletRequest.getParameter("display_legendHours")) {
            n += 0x100000;
        }
        return n;
    }

    public Element getGroups() throws RemoteException {
        return this.getRoot(this.getRemote().getGroups(this.getIdentifier()));
    }

    public Element getHourNames() throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getDayHours(this.getIdentifier(), this.getProjectId()));
    }

    public Element getLunchTimes(int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getLunchTimes(this.getIdentifier(), this.getProjectId(), n));
    }

    public Element getParticipantAvailabilities(int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getEntityDispos(this.getIdentifier(), this.getProjectId(), n, true));
    }

    public Element getParticipantsAvailabilities(List list, List list2, List list3) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getParticipantsAvailabilities(list, list2, list3, false);
    }

    public Element getParticipantsAvailabilities(List list, List list2, List list3, boolean bl) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getParticipantsAvailabilities(this.getIdentifier(), this.getProjectId(), list, list2, list3, bl));
    }

    public Element getDefaultAvailabilities(List list, List list2) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getDefaultAvailabilities(this.getIdentifier(), this.getProjectId(), list, list2));
    }

    public Element getProjects() throws RemoteException, AdeException, SQLException {
        return this.getProjects(6);
    }

    public Element getProjects(int n) throws RemoteException, AdeException, SQLException {
        return this.getRoot(this.getRemote().getProjects(this.getIdentifier(), n));
    }

    public Element getTrashEventsOfActivity(int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getTrashEventsOfCourse(this.getIdentifier(), this.getProjectId(), n, 8, false));
    }

    public Element getTrashEventsOfParticipant(int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getTrashEventsOfEntity(this.getIdentifier(), this.getProjectId(), n, 8, false));
    }

    public Element getTrashEvents(FiltersTrash filtersTrash) throws RemoteException, NotFoundException, ProjectNotFoundException {
        return this.getTrashEvents(filtersTrash, 8);
    }

    public Element getTrashEvents(FiltersTrash filtersTrash, int n) throws RemoteException, NotFoundException, ProjectNotFoundException {
        if (null != filtersTrash) {
            return this.getRoot(this.getRemote().getTrashEvents(this.getIdentifier(), this.getProjectId(), filtersTrash.getFilters(), n, false));
        }
        return this.getRoot(this.getRemote().getTrashEvents(this.getIdentifier(), this.getProjectId(), null, n, false));
    }

    public Element getTypes() throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getTypes(this.getIdentifier(), this.getProjectId()));
    }

    public Element getActivitiesTypes() throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getActivitiesTypes(this.getIdentifier(), this.getProjectId()));
    }

    public Element getParticipants(FiltersParticipants filtersParticipants, int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getParticipants(this.getIdentifier(), this.getProjectId(), filtersParticipants, n, false));
    }

    public Element getParticipantsTypes() throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getParticipantsTypes(this.getIdentifier(), this.getProjectId()));
    }

    public double getActivityParticipantCost(int n, int n2, int n3) throws ProjectNotFoundException, RemoteException, NotFoundException {
        return this.getRemote().getActivityParticipantCost(this.getIdentifier(), this.getProjectId(), n, n2, n3);
    }

    public String getTimetableUrl(TimetableUrl timetableUrl, HttpServletRequest httpServletRequest) {
        String string = this.getParameter(SERVERADE);
        String string2 = this.getParameter(SERVERADEPORT);
        StringBuffer stringBuffer = new StringBuffer();
        if (null != httpServletRequest) {
            stringBuffer.append(httpServletRequest.getContextPath());
            stringBuffer.append("/");
        } else {
            stringBuffer.append(this.getParameter(SERVERWEB));
        }
        stringBuffer.append("imageEt?");
        stringBuffer.append("serverAde=" + URLEncoder.encode(string));
        stringBuffer.append("&serverAdePort=" + URLEncoder.encode(string2));
        stringBuffer.append("&identifier=" + URLEncoder.encode(this.getIdentifier()));
        stringBuffer.append("&projectId=" + this.getProjectId());
        stringBuffer.append("&idPianoWeek=" + URLEncoder.encode(timetableUrl.weeks));
        stringBuffer.append("&idPianoDay=" + URLEncoder.encode(timetableUrl.days));
        stringBuffer.append("&idTree=" + URLEncoder.encode(timetableUrl.intervenants));
        stringBuffer.append("&width=" + timetableUrl.width);
        stringBuffer.append("&height=" + timetableUrl.height);
        stringBuffer.append("&lunchName=" + URLEncoder.encode(timetableUrl.lunchName));
        stringBuffer.append("&displayMode=" + timetableUrl.displayMode);
        stringBuffer.append("&showLoad=" + timetableUrl.showLoad);
        stringBuffer.append("&compt=" + System.currentTimeMillis());
        stringBuffer.append("&reload=reload");
        stringBuffer.append("&displayConfId=" + timetableUrl.displayConfId);
        return stringBuffer.toString();
    }

    public String getTimetableUrl(TimetableUrl timetableUrl) {
        return this.getTimetableUrl(timetableUrl, null);
    }

    public Element getUser(int n, int n2) throws RemoteException, ProjectNotFoundException, SQLException, AdeException {
        return this.getRoot(this.getRemote().getUser(this.getIdentifier(), n, n2));
    }

    public Element getConnectedUser(int n) throws RemoteException, ProjectNotFoundException, SQLException, AdeException {
        return this.getRemote().getConnectedUser(this.getIdentifier(), n).getRoot();
    }

    public Element getUsers(int n) throws RemoteException, ProjectNotFoundException, SQLException, AdeException {
        return this.getUsers(n, 6);
    }

    public Element getUsers(int n, int n2) throws RemoteException, ProjectNotFoundException, SQLException, AdeException {
        return this.getRoot(this.getRemote().getUsers(this.getIdentifier(), n, n2));
    }

    public Element getWeekNames() throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getWeekNames(this.getIdentifier(), this.getProjectId()));
    }

    public void removeActivity(int n) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeCourse(this.getIdentifier(), this.getProjectId(), n);
    }

    public void removeFolder(int n) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeFolder(this.getIdentifier(), this.getProjectId(), n);
    }

    public void removeActivityParticipant(int n, int n2) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeCourseParticipant(this.getIdentifier(), this.getProjectId(), n, n2);
    }

    public void removeActivityParticipantNode(int n, int n2) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeCourseParticipantNode(this.getIdentifier(), this.getProjectId(), n, n2);
    }

    public void removeGroup(int n) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeGroup(this.getIdentifier(), n);
    }

    public void removeUser(int n) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeUser(this.getIdentifier(), n);
    }

    public void removeLink(int n) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeLink(this.getIdentifier(), this.getProjectId(), n);
    }

    public void removeLinkActivity(int n, int n2) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeLinkCourse(this.getIdentifier(), this.getProjectId(), n, n2);
    }

    public void removeParticipant(int n) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeEntity(this.getIdentifier(), this.getProjectId(), n);
    }

    public void removeProject(int n) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeProject(this.getIdentifier(), n);
    }

    public void setActivityAvailabilities(int n, int n2, int n3, int n4, int n5, int n6) throws RemoteException, ProjectNotFoundException, AdeException {
        String string = "";
        if (n6 == 0) {
            string = NOT_AVAILABLE;
        } else if (n6 == 1) {
            string = MINIMAL_PRIORITY;
        } else if (n6 == 2) {
            string = MEDIUM_PRIORITY;
        } else if (n6 == 3) {
            string = MAXIMAL_PRIORITY;
        }
        this.getRemote().setCourseDispos(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, n5, string);
    }

    public Element setActivityParticipants(int n, Element element) throws AdeException, ProjectNotFoundException, JDOMException, RemoteException {
        return this.getRoot(this.getRemote().setCourseParticipants(this.getIdentifier(), this.getProjectId(), n, AdeBean.getString(element), false));
    }

    public void setCalendar(CalendarSettings calendarSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().setCalendar(this.getIdentifier(), this.getProjectId(), calendarSettings);
    }

    public void setParticipantAvailabilities(int n, int n2, int n3, int n4, int n5, int n6) throws RemoteException, ProjectNotFoundException, AdeException {
        String string = "";
        if (n6 == 0) {
            string = NOT_AVAILABLE;
        } else if (n6 == 1) {
            string = MINIMAL_PRIORITY;
        } else if (n6 == 2) {
            string = MEDIUM_PRIORITY;
        } else if (n6 == 3) {
            string = MAXIMAL_PRIORITY;
        }
        this.getRemote().setEntityDispos(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, n5, string, true);
    }

    public boolean setParticipantAvailabilities(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) throws RemoteException, ProjectNotFoundException, AdeException {
        String string = "";
        if (n6 == 0) {
            string = NOT_AVAILABLE;
        } else if (n6 == 1) {
            string = MINIMAL_PRIORITY;
        } else if (n6 == 2) {
            string = MEDIUM_PRIORITY;
        } else if (n6 == 3) {
            string = MAXIMAL_PRIORITY;
        }
        return this.getRemote().setEntityDispos(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, n5, string, bl);
    }

    public boolean updateActivity(int n, ActivitySettings activitySettings) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().updateCourse(this.getIdentifier(), this.getProjectId(), n, activitySettings);
    }

    public boolean updateFolder(int n, FolderSettings folderSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().updateFolder(this.getIdentifier(), this.getProjectId(), n, folderSettings);
    }

    public void updateGroup(int n, GroupSettings groupSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().updateGroup(this.getIdentifier(), n, groupSettings);
    }

    public void updateGroup(int n, String string) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().updateGroup(this.getIdentifier(), n, new GroupSettings(string));
    }

    public void updateLink(int n, LinkSettings linkSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().updateLink(this.getIdentifier(), this.getProjectId(), n, linkSettings);
    }

    public void updateParticipant(int n, ParticipantSettings participantSettings) throws RemoteException, ProjectNotFoundException, AdeException, EntityGroupError {
        this.getRemote().updateEntity(this.getIdentifier(), this.getProjectId(), n, participantSettings);
    }

    public Element addActivityParticipants(int n, List list) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRoot(this.getRemote().addCourseParticipants(this.getIdentifier(), this.getProjectId(), n, list, false));
    }

    public Element getCurrentDate() throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getCurrentDate(this.getIdentifier(), this.getProjectId()));
    }

    public Date getDate(int n, int n2, int n3) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().getDate(this.getIdentifier(), this.getProjectId(), n, n2, n3);
    }

    public Element getDate(Date date) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRoot(this.getRemote().getDate(this.getIdentifier(), this.getProjectId(), date));
    }

    public Element getEventAvailabilities(int n, int n2, int n3, int n4, int n5, int n6) throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getEventAvailabilities(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, n5, n6));
    }

    public Element getParticipantById(int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getEntityById(this.getIdentifier(), this.getProjectId(), n, 0, false));
    }

    public Element getParticipantById(int n, int n2) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getEntityById(this.getIdentifier(), this.getProjectId(), n, n2, false));
    }

    public Element placeEvent(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws RemoteException, SQLException, AdeException {
        return this.getRoot(this.getRemote().placeEvent(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, n5, n6, n7, -1, false, null, false, false));
    }

    public Element placeEvent(EventSettings eventSettings, int n, int n2, int n3) throws RemoteException, SQLException, AdeException {
        return this.placeEvent(eventSettings, n, n2, n3, -1, false, null);
    }

    public Element placeLunch(EventSettings eventSettings, int n, int n2, int n3, int n4) throws RemoteException, ProjectNotFoundException, NotFoundException, AdeException {
        return this.getRoot(this.getRemote().placeLunch(this.getIdentifier(), this.getProjectId(), eventSettings.getSession(), eventSettings.getRepetition(), n, n2, n3, n4, false));
    }

    public Element placeEvent(EventSettings eventSettings, int n, int n2, int n3, AdeList adeList) throws RemoteException, SQLException, AdeException {
        return this.placeEvent(eventSettings, n, n2, n3, adeList, false, null);
    }

    public Element placeEvent(EventSettings eventSettings, int n, int n2, int n3, boolean bl, EngineSettings engineSettings) throws RemoteException, SQLException, AdeException {
        return this.getRoot(this.getRemote().placeEvent(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getActivityId(), eventSettings.getSession(), eventSettings.getRepetition(), n, n2, n3, -1, bl, engineSettings, false, false));
    }

    public Element placeEvent(EventSettings eventSettings, int n, int n2, int n3, int n4) throws RemoteException, SQLException, AdeException {
        return this.placeEvent(eventSettings, n, n2, n3, n4, false, null);
    }

    public Element placeEvent(EventSettings eventSettings, int n, int n2, int n3, int n4, boolean bl, EngineSettings engineSettings) throws RemoteException, SQLException, AdeException {
        return this.getRoot(this.getRemote().placeEvent(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getActivityId(), eventSettings.getSession(), eventSettings.getRepetition(), n, n2, n3, n4, bl, engineSettings, false, false));
    }

    public Element placeEvent(EventSettings eventSettings, int n, int n2, int n3, AdeList adeList, boolean bl, EngineSettings engineSettings) throws RemoteException, SQLException, AdeException {
        return this.getRoot(this.getRemote().placeEvent(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getActivityId(), eventSettings.getSession(), eventSettings.getRepetition(), n, n2, n3, adeList, bl, engineSettings, false, false));
    }

    public Element moveGroupEvents(EventSettings eventSettings, List list, int n, int n2, int n3) throws RemoteException, SQLException, AdeException {
        return this.getRoot(this.getRemote().moveGroupEvents(this.getIdentifier(), this.getProjectId(), eventSettings, list, n, n2, n3, false));
    }

    public Element moveGroupEvents(EventSettings eventSettings, List list, int n, int n2, int n3, int n4) throws RemoteException, SQLException, AdeException {
        return this.getRoot(this.getRemote().moveGroupEvents(this.getIdentifier(), this.getProjectId(), eventSettings, list, n, n2, n3, n4, false));
    }

    public Element resizeEvent(EventSettings eventSettings, int n) throws RemoteException, AdeException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().resizeEvent(this.getIdentifier(), this.getProjectId(), eventSettings, n, false));
    }

    public Element getEventById(EventSettings eventSettings) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getEventById(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getActivityId(), eventSettings.getSession(), eventSettings.getRepetition(), 8, false));
    }

    public Element getEventById(EventSettings eventSettings, int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getEventById(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getActivityId(), eventSettings.getSession(), eventSettings.getRepetition(), n, false));
    }

    public void removeEvent(int n, int n2, int n3) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeEvent(this.getIdentifier(), this.getProjectId(), n, -1, n2, n3);
    }

    public boolean testPlaceEvent(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws ProjectNotFoundException, RemoteException, SQLException, AdeException, EntityGroupError {
        return this.getRemote().testPlaceEvent(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, n5, n6, n7, -1);
    }

    public int createCost(String string, double d) throws ProjectNotFoundException, RemoteException, AdeException {
        return this.getRemote().createCost(this.getIdentifier(), this.getProjectId(), new CostSettings(string, d));
    }

    public int duplicateParticipant(int n) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().duplicateEntity(this.getIdentifier(), this.getProjectId(), n);
    }

    public int duplicateProject(int n) throws ProjectNotFoundException, RemoteException, AdeException {
        return this.getRemote().duplicateProject(this.getIdentifier(), n);
    }

    public void exportXMLFile(int n, String string) throws ProjectNotFoundException, RemoteException, AdeException, IOException {
        this.getRemote().exportXMLFile(this.getIdentifier(), n, string);
    }

    public Element getLinkById(int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getLinkById(this.getIdentifier(), this.getProjectId(), n, 0));
    }

    public String getParameter(String string, HttpServletRequest httpServletRequest) {
        return this.getParameter(string);
    }

    public Element getParticipantEventAvailabilities(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws RemoteException, ProjectNotFoundException, NotFoundException, AdeException, EntityGroupError {
        return this.getRoot(this.getRemote().getEntityEventAvailabilities(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, n5, n6, n7));
    }

    public int importXMLFile(String string) throws RemoteException, AdeException {
        return this.getRemote().importXMLFile(this.getIdentifier(), string);
    }

    public int importXMLFileDistant(String string) throws RemoteException, AdeException, InvalidFile {
        return this.getRemote().importXMLFileDistant(this.getIdentifier(), string);
    }

    public String loadCookie(String string, HttpServletRequest httpServletRequest) {
        try {
            Cookie[] cookieArray = httpServletRequest.getCookies();
            string = this.getCookieName(string, httpServletRequest);
            if (null == cookieArray) break block4;
            for (int i = 0; i < cookieArray.length; ++i) {
                Cookie cookie = cookieArray[i];
                if (!cookie.getName().equals(string)) continue;
                return cookie.getValue();
            }
        }
        finally {
            return null;
        }
        {
            block4: {
            }
        }
    }

    private String getCookieName(String string, HttpServletRequest httpServletRequest) {
        try {
            string = WebSessions.getInstance().getLogin(httpServletRequest.getSession().getId()) + "-" + string;
            string = Util.getCleanedString((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public void removeCost(int n) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().removeCost(this.getIdentifier(), this.getProjectId(), n);
    }

    public void removeCaracteristic(int n) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().removeCaracteristic(this.getIdentifier(), this.getProjectId(), n);
    }

    public void saveCookie(String string, String string2, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        if (httpServletResponse != null) {
            string = this.getCookieName(string, httpServletRequest);
            Cookie cookie = new Cookie(string, string2);
            cookie.setMaxAge(432000000);
            httpServletResponse.addCookie(cookie);
        }
    }

    public void setDefaultAvailabilities(int n, int n2, int n3, int n4, int n5) throws ProjectNotFoundException, RemoteException, AdeException {
        String string = "";
        if (n5 == 0) {
            string = NOT_AVAILABLE;
        } else if (n5 == 1) {
            string = MINIMAL_PRIORITY;
        } else if (n5 == 2) {
            string = MEDIUM_PRIORITY;
        } else if (n5 == 3) {
            string = MAXIMAL_PRIORITY;
        }
        this.getRemote().setDefaultAvailabilities(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, string);
    }

    public void setDefaultLunchTime(int n, int n2, int n3, int n4, int n5) throws ProjectNotFoundException, RemoteException, AdeException {
        String string = "";
        if (n5 == 0) {
            string = NOT_AVAILABLE;
        } else if (n5 == 1) {
            string = MINIMAL_PRIORITY;
        } else if (n5 == 2) {
            string = MEDIUM_PRIORITY;
        } else if (n5 == 3) {
            string = MAXIMAL_PRIORITY;
        }
        this.getRemote().setDefaultLunchTime(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, string);
    }

    public void setDefaultRights(int n, int n2, int n3, int n4, int n5) throws RemoteException, ProjectNotFoundException, AdeException {
        String string = NONE;
        String string2 = NONE;
        String string3 = NONE;
        if (n == 0) {
            string = NONE;
        } else if (n == 1) {
            string = READ;
        } else if (n == 2) {
            string = USE;
        } else if (n == 3) {
            string = RW;
        }
        if (n2 == 0) {
            string = NONE;
        } else if (n2 == 1) {
            string2 = READ;
        } else if (n2 == 2) {
            string2 = USE;
        } else if (n2 == 3) {
            string2 = RW;
        }
        if (n3 == 0) {
            string = NONE;
        } else if (n3 == 1) {
            string3 = READ;
        } else if (n3 == 2) {
            string3 = USE;
        } else if (n3 == 3) {
            string3 = RW;
        }
        this.setDefaultRights(string, string2, string3, n4, n5);
    }

    public void setParameter(String string, String string2, HttpServletResponse httpServletResponse) {
        this.setParameter(string, string2);
    }

    public Element getAllPermissions(boolean bl, boolean bl2) throws RemoteException {
        return this.getRoot(this.getRemote().getAllPermissions(bl, bl2));
    }

    public void setGlobalPermission(int n, String string) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().setGeneralPermission(this.getIdentifier(), n, string);
    }

    public void setGlobalPermission(int n, int n2) throws RemoteException, AdeException {
        this.getRemote().setGlobalPermission(this.getIdentifier(), n, n2);
    }

    public void setProjectPermission(int n, int n2, String string) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().setProjectPermission(this.getIdentifier(), n, n2, string);
    }

    public void setProjectPermission(int n, int n2, int n3) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().setProjectPermission(this.getIdentifier(), n, n2, n3);
    }

    public void removeGlobalPermission(int n, String string) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeGeneralPermission(this.getIdentifier(), n, string);
    }

    public void removeGlobalPermission(int n, int n2) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeGeneralPermission(this.getIdentifier(), n, n2);
    }

    public void removeProjectPermission(int n, int n2, String string) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeProjectPermission(this.getIdentifier(), n, n2, string);
    }

    public void removeProjectPermission(int n, int n2, int n3) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeProjectPermission(this.getIdentifier(), n, n2, n3);
    }

    public void setRightsActivity(int n, int n2, int n3, int n4, int n5, int n6) throws RemoteException, ProjectNotFoundException, AdeException {
        String string = NONE;
        String string2 = NONE;
        String string3 = NONE;
        if (n2 == 0) {
            string = NONE;
        } else if (n2 == 1) {
            string = READ;
        } else if (n2 == 2) {
            string = USE;
        } else if (n2 == 3) {
            string = RW;
        }
        if (n3 == 0) {
            string = NONE;
        } else if (n3 == 1) {
            string2 = READ;
        } else if (n3 == 2) {
            string2 = USE;
        } else if (n3 == 3) {
            string2 = RW;
        }
        if (n4 == 0) {
            string = NONE;
        } else if (n4 == 1) {
            string3 = READ;
        } else if (n4 == 2) {
            string3 = USE;
        } else if (n4 == 3) {
            string3 = RW;
        }
        this.setRightsActivity(n, string, string2, string3, n5, n6);
    }

    public void setRightsParticipant(int n, int n2, int n3, int n4, int n5, int n6) throws RemoteException, ProjectNotFoundException, AdeException {
        String string = NONE;
        String string2 = NONE;
        String string3 = NONE;
        if (n2 == 0) {
            string = NONE;
        } else if (n2 == 1) {
            string = READ;
        } else if (n2 == 2) {
            string = USE;
        } else if (n2 == 3) {
            string = RW;
        }
        if (n3 == 0) {
            string = NONE;
        } else if (n3 == 1) {
            string2 = READ;
        } else if (n3 == 2) {
            string2 = USE;
        } else if (n3 == 3) {
            string2 = RW;
        }
        if (n4 == 0) {
            string = NONE;
        } else if (n4 == 1) {
            string3 = READ;
        } else if (n4 == 2) {
            string3 = USE;
        } else if (n4 == 3) {
            string3 = RW;
        }
        this.setRightsParticipant(n, string, string2, string3, n5, n6);
    }

    public void setRightsProject(int n, int n2, int n3, int n4, int n5, int n6) throws RemoteException, ProjectNotFoundException, AdeException {
        String string = NONE;
        String string2 = NONE;
        String string3 = NONE;
        if (n2 == 0) {
            string = NONE;
        } else if (n2 == 1) {
            string = READ;
        } else if (n2 == 2) {
            string = USE;
        } else if (n2 == 3) {
            string = RW;
        }
        if (n3 == 0) {
            string = NONE;
        } else if (n3 == 1) {
            string2 = READ;
        } else if (n3 == 2) {
            string2 = USE;
        } else if (n3 == 3) {
            string2 = RW;
        }
        if (n4 == 0) {
            string = NONE;
        } else if (n4 == 1) {
            string3 = READ;
        } else if (n4 == 2) {
            string3 = USE;
        } else if (n4 == 3) {
            string3 = RW;
        }
        this.setRightsParticipant(n, string, string2, string3, n5, n6);
    }

    public void updateActivityParticipantCost(int n, int n2, int n3, double d) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().updateActivityParticipantCost(this.getIdentifier(), this.getProjectId(), n, n2, n3, new CostSettings("", d));
    }

    public void updateActivityParticipantLoad(int n, int n2, double d) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().updateActivityParticipantLoad(this.getIdentifier(), this.getProjectId(), n, n2, d);
    }

    public void updateCost(int n, String string, double d) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().updateCost(this.getIdentifier(), this.getProjectId(), n, new CostSettings(string, d));
    }

    public void updateParticipantCost(int n, int n2, double d) throws ProjectNotFoundException, RemoteException, AdeException, EntityGroupError {
        this.getRemote().updateEntityCost(this.getIdentifier(), this.getProjectId(), n, n2, new CostSettings("", d));
    }

    public void updateProject(int n, String string) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().updateProject(this.getIdentifier(), n, new ProjectSettings(string));
    }

    public void updateUser(int n, UserSettings userSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().updateUser(this.getIdentifier(), n, userSettings);
    }

    private Element getRoot(XmlMessage xmlMessage) {
        return null == xmlMessage ? null : xmlMessage.getRoot();
    }

    public int createCost(CostSettings costSettings) throws ProjectNotFoundException, RemoteException, AdeException {
        return this.getRemote().createCost(this.getIdentifier(), this.getProjectId(), costSettings);
    }

    public int createCaracteristic(CaracteristicSettings caracteristicSettings) throws ProjectNotFoundException, RemoteException, AdeException {
        return this.getRemote().createCaracteristic(this.getIdentifier(), this.getProjectId(), caracteristicSettings);
    }

    public int createGroup(GroupSettings groupSettings) throws RemoteException, AdeException {
        return this.getRemote().createGroup(this.getIdentifier(), groupSettings);
    }

    public int createProject(ProjectSettings projectSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().createProject(this.getIdentifier(), projectSettings);
    }

    public int duplicateParticipant(int n, boolean bl) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().duplicateEntity(this.getIdentifier(), this.getProjectId(), n, bl, true, false);
    }

    public Element getActivities(FiltersActivities filtersActivities, int n) throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getCourses(this.getIdentifier(), this.getProjectId(), filtersActivities, n, false));
    }

    public Element getTreeActivities(FiltersActivities filtersActivities, int n) throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getCourseTree(this.getIdentifier(), this.getProjectId(), filtersActivities, n, false, false));
    }

    public Element getCalendar() throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getCalendar(this.getIdentifier(), this.getProjectId(), null));
    }

    public Element getCosts() throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getCosts(this.getIdentifier(), this.getProjectId(), false));
    }

    public Element getCostById(int n) throws ProjectNotFoundException, NotFoundException, RemoteException {
        return this.getRoot(this.getRemote().getCostById(this.getIdentifier(), this.getProjectId(), n, false));
    }

    public Element getCaracteristicById(int n) throws ProjectNotFoundException, NotFoundException, RemoteException {
        return this.getRoot(this.getRemote().getCaracteristicById(this.getIdentifier(), this.getProjectId(), n, false));
    }

    public Element getCaracteristics() throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getCaracteristic(this.getIdentifier(), this.getProjectId(), false));
    }

    public Element getEventAvailabilities(EventSettings eventSettings, int n, int n2) throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getEventAvailabilities(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getActivityId(), eventSettings.getSession(), eventSettings.getRepetition(), n, n2));
    }

    public Element getEvents(FiltersEvents filtersEvents) throws RemoteException, ProjectNotFoundException {
        if (filtersEvents != null) {
            return this.getRoot(this.getRemote().getEvents(this.getIdentifier(), this.getProjectId(), filtersEvents.getFilters(), 8, false));
        }
        return this.getRoot(this.getRemote().getEvents(this.getIdentifier(), this.getProjectId(), null, 8, false));
    }

    public Element getEvents(FiltersEvents filtersEvents, int n) throws RemoteException, ProjectNotFoundException {
        if (filtersEvents != null) {
            return this.getRoot(this.getRemote().getEvents(this.getIdentifier(), this.getProjectId(), filtersEvents.getFilters(), n, false));
        }
        return this.getRoot(this.getRemote().getEvents(this.getIdentifier(), this.getProjectId(), null, n, false));
    }

    public Element getInstructors(FiltersParticipants filtersParticipants, int n) throws RemoteException, ProjectNotFoundException {
        return this.getCategory(filtersParticipants, "instructor", n);
    }

    public Element getLinks(FiltersLinks filtersLinks) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getLinks(this.getIdentifier(), this.getProjectId(), filtersLinks, 0));
    }

    public Element getParticipantEventAvailabilities(EventSettings eventSettings, int n, int n2, int n3) throws RemoteException, ProjectNotFoundException, NotFoundException, AdeException, EntityGroupError {
        return this.getRoot(this.getRemote().getEntityEventAvailabilities(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getActivityId(), eventSettings.getSession(), eventSettings.getRepetition(), n, n2, n3));
    }

    public Element getProjectInfo(int n) throws RemoteException, AdeException, SQLException {
        return this.getRoot(this.getRemote().getProjectInfo(this.getIdentifier(), n));
    }

    public Element getCategory(FiltersParticipants filtersParticipants, String string, int n) throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getCategory(this.getIdentifier(), this.getProjectId(), filtersParticipants, string, n, false));
    }

    public Element getResources(FiltersParticipants filtersParticipants, int n) throws RemoteException, ProjectNotFoundException {
        return this.getCategory(filtersParticipants, "resource", n);
    }

    public Element getRooms(FiltersParticipants filtersParticipants, int n) throws RemoteException, ProjectNotFoundException {
        return this.getCategory(filtersParticipants, "room", n);
    }

    public static String getString(Element element) {
        String string = "";
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XmlWriter xmlWriter = new XmlWriter((OutputStream)byteArrayOutputStream, false);
            xmlWriter.outputXML(element);
            xmlWriter.close();
            string = byteArrayOutputStream.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public Element getTrainees(FiltersParticipants filtersParticipants, int n) throws RemoteException, ProjectNotFoundException {
        return this.getCategory(filtersParticipants, "trainee", n);
    }

    public Element getTree(FiltersParticipants filtersParticipants, int n) throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getIntervenant(this.getIdentifier(), this.getProjectId(), filtersParticipants, n, false));
    }

    public Element getTreeCategory(FiltersParticipants filtersParticipants, String string, int n) throws RemoteException, ProjectNotFoundException {
        return this.getRoot(this.getRemote().getTreeCategory(this.getIdentifier(), this.getProjectId(), filtersParticipants, string, n, false));
    }

    public Element getTreeInstructors(FiltersParticipants filtersParticipants, int n) throws RemoteException, ProjectNotFoundException {
        return this.getTreeCategory(filtersParticipants, "instructor", n);
    }

    public Element getTreeResources(FiltersParticipants filtersParticipants, int n) throws RemoteException, ProjectNotFoundException {
        return this.getTreeCategory(filtersParticipants, "resource", n);
    }

    public Element getTreeRooms(FiltersParticipants filtersParticipants, int n) throws RemoteException, ProjectNotFoundException {
        return this.getTreeCategory(filtersParticipants, "room", n);
    }

    public Element getTreeTrainees(FiltersParticipants filtersParticipants, int n) throws RemoteException, ProjectNotFoundException {
        return this.getTreeCategory(filtersParticipants, "trainee", n);
    }

    public void lockEventDate(int n, int n2, int n3) throws ProjectNotFoundException, RemoteException, NotFoundException {
        this.getRemote().lockEventDate(this.getIdentifier(), this.getProjectId(), n, n2, n3);
    }

    public void lockEventDate(EventSettings eventSettings) throws ProjectNotFoundException, RemoteException, NotFoundException {
        this.getRemote().lockEventDate(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getSession(), eventSettings.getRepetition());
    }

    public void lockEventParticipants(int n, int n2, int n3) throws ProjectNotFoundException, RemoteException, NotFoundException {
        this.getRemote().lockEventParticipants(this.getIdentifier(), this.getProjectId(), n, n2, n3);
    }

    public void lockEventParticipants(EventSettings eventSettings) throws ProjectNotFoundException, RemoteException, NotFoundException {
        this.getRemote().lockEventParticipants(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getSession(), eventSettings.getRepetition());
    }

    public void removeEvent(EventSettings eventSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeEvent(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getActivityId(), eventSettings.getSession(), eventSettings.getRepetition());
    }

    public void removeLunch(int n, int n2, int n3) throws ProjectNotFoundException, NotFoundException, AdeException, RemoteException {
        this.getRemote().removeLunch(this.getIdentifier(), this.getProjectId(), n2, n3, n);
    }

    public void setActivityAvailabilities(int n, int n2, int n3, int n4, int n5, String string) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().setCourseDispos(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, n5, string);
    }

    public void setDefaultAvailabilities(int n, int n2, int n3, int n4, String string) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().setDefaultAvailabilities(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, string);
    }

    public void setDefaultLunchTimes(int n, int n2, int n3, int n4, String string) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().setDefaultLunchTime(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, string);
    }

    public void setLunchTimes(int n, int n2, int n3, int n4, int n5, String string) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().setLunchTimes(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, n5, string);
    }

    public void setDefaultRights(String string, String string2, String string3, int n, int n2) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().setDefaultRights(this.getIdentifier(), string, string2, string3, n, n2);
    }

    public boolean setEventParticipants(EventSettings eventSettings) throws ProjectNotFoundException, RemoteException, NotFoundException, AdeException, EntityGroupError {
        return this.getRemote().setEventParticipants(this.getIdentifier(), this.getProjectId(), eventSettings);
    }

    public void setLunchDuration(int n, int n2) throws RemoteException, ProjectNotFoundException, AdeException, EntityGroupError {
        this.getRemote().setLunchDuration(this.getIdentifier(), this.getProjectId(), n, n2);
    }

    public void setParticipantAvailabilities(int n, int n2, int n3, int n4, int n5, String string) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().setEntityDispos(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, n5, string, true);
    }

    public boolean setParticipantAvailabilities(int n, int n2, int n3, int n4, int n5, String string, boolean bl) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().setEntityDispos(this.getIdentifier(), this.getProjectId(), n, n2, n3, n4, n5, string, bl);
    }

    public void setRightsActivity(int n, String string, String string2, String string3, int n2, int n3) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().setRightsCourse(this.getIdentifier(), this.getProjectId(), n, string, string2, string3, n2, n3);
    }

    public void setRightsParticipant(int n, String string, String string2, String string3, int n2, int n3) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().setRightsEntity(this.getIdentifier(), this.getProjectId(), n, string, string2, string3, n2, n3);
    }

    public void setActivityOrContinuous(int n, int n2, boolean bl) throws AdeException, ProjectNotFoundException, RemoteException {
        this.getRemote().setActivityOrContinuous(this.getIdentifier(), this.getProjectId(), n, n2, bl);
    }

    public void setActivityParticipantQuantity(int n, int n2, int n3) throws AdeException, ProjectNotFoundException, RemoteException {
        this.getRemote().setActivityParticipantQuantity(this.getIdentifier(), this.getProjectId(), n, n2, n3);
    }

    public void setRightsProject(int n, String string, String string2, String string3, int n2, int n3) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().setRightsProject(this.getIdentifier(), n, string, string2, string3, n2, n3);
    }

    public boolean testPlaceEvent(EventSettings eventSettings, int n, int n2, int n3) throws ProjectNotFoundException, RemoteException, SQLException, AdeException, EntityGroupError {
        return this.getRemote().testPlaceEvent(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getActivityId(), eventSettings.getSession(), eventSettings.getRepetition(), n, n2, n3, -1);
    }

    public void unloadProject(int n) throws ProjectNotFoundException, RemoteException {
        this.getRemote().unloadProject(this.getIdentifier(), n);
    }

    public void unlockEventDate(int n, int n2, int n3) throws ProjectNotFoundException, RemoteException, NotFoundException, AdeException {
        this.getRemote().unlockEventDate(this.getIdentifier(), this.getProjectId(), n, n2, n3);
    }

    public void unlockEventDate(EventSettings eventSettings) throws ProjectNotFoundException, RemoteException, NotFoundException, AdeException {
        this.getRemote().unlockEventDate(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getSession(), eventSettings.getRepetition());
    }

    public void unlockEventParticipants(int n, int n2, int n3) throws ProjectNotFoundException, RemoteException, NotFoundException {
        this.getRemote().unlockEventParticipants(this.getIdentifier(), this.getProjectId(), n, n2, n3);
    }

    public void unlockEventParticipants(EventSettings eventSettings) throws ProjectNotFoundException, RemoteException, NotFoundException {
        this.getRemote().unlockEventParticipants(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getSession(), eventSettings.getRepetition());
    }

    public void updateActivityParticipantCost(int n, int n2, int n3, CostSettings costSettings) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().updateActivityParticipantCost(this.getIdentifier(), this.getProjectId(), n, n2, n3, costSettings);
    }

    public void updateCost(int n, CostSettings costSettings) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().updateCost(this.getIdentifier(), this.getProjectId(), n, costSettings);
    }

    public void updateCaracteristic(int n, CaracteristicSettings caracteristicSettings) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().updateCaracteristic(this.getIdentifier(), this.getProjectId(), n, caracteristicSettings);
    }

    public void updateParticipantCost(int n, int n2, CostSettings costSettings) throws ProjectNotFoundException, RemoteException, AdeException, EntityGroupError {
        this.getRemote().updateEntityCost(this.getIdentifier(), this.getProjectId(), n, n2, costSettings);
    }

    public void removeParticipantCaracteristic(int n, int n2) throws ProjectNotFoundException, RemoteException, AdeException, EntityGroupError {
        this.getRemote().removeParticipantCaracteristic(this.getIdentifier(), this.getProjectId(), n, n2);
    }

    public void updateProject(int n, ProjectSettings projectSettings) throws ProjectNotFoundException, RemoteException, AdeException {
        this.getRemote().updateProject(this.getIdentifier(), n, projectSettings);
    }

    public String getProperty(String string) throws RemoteException {
        return this.getRemote().getProperty(string);
    }

    public int launchEngine(EngineSettings engineSettings) throws ProjectNotFoundException, AdeException, RemoteException {
        return this.getRemote().launchEngine(this.getIdentifier(), this.getProjectId(), engineSettings);
    }

    public void unloadEngine(int n) throws RemoteException {
        this.getRemote().unloadEngine(n);
    }

    public void stopEngine(int n) throws RemoteException {
        this.getRemote().stopEngine(n);
    }

    public void waitEngine(int n, int n2) throws RemoteException {
        this.getRemote().waitEngine(n, n2);
    }

    public void waitEngine(int n) throws RemoteException {
        this.getRemote().waitEngine(n, Integer.MAX_VALUE);
    }

    public void pauseEngine(int n) throws RemoteException {
        this.getRemote().pauseEngine(n);
    }

    public void resumeEngine(int n) throws RemoteException {
        this.getRemote().resumeEngine(n);
    }

    public Element getEngineInfo(int n) throws RemoteException {
        return this.getRoot(this.getRemote().getEngineInfo(n));
    }

    public Element getAllEngineInfo(int n) throws RemoteException, AdeException {
        return this.getRoot(this.getRemote().getEngineAllInfo(n));
    }

    public Element getLastEngineInfos(int n) throws RemoteException, AdeException {
        return this.getRoot(this.getRemote().getEngineLastInfos(n));
    }

    public void exportVCalendar(List list, TimeZone timeZone) throws RemoteException, ProjectNotFoundException, NotFoundException {
        this.getRemote().exportVCalendar(this.getIdentifier(), this.getProjectId(), list, timeZone);
    }

    public void clientSelectActivities(int[] nArray) throws RemoteException, ProjectNotFoundException {
        RemoteSelecters.getInstance().getRemote().selectActivity(this.getIdentifier(), this.getProjectId(), -1, nArray);
    }

    public void clientSelectParticipants(int[] nArray) throws RemoteException, ProjectNotFoundException {
        RemoteSelecters.getInstance().getRemote().selectResources(this.getIdentifier(), this.getProjectId(), -1, nArray);
    }

    public void clientSelectLinks(int[] nArray) throws RemoteException, ProjectNotFoundException {
        RemoteSelecters.getInstance().getRemote().selectLink(this.getIdentifier(), this.getProjectId(), -1, nArray);
    }

    public void clientShowMessage(String string) throws RemoteException {
        RemoteSelecters.getInstance().getRemote().showMessage(this.getIdentifier(), -1, string);
    }

    public int getVersion() {
        return 2;
    }

    public int[] getIds(long l) throws RemoteException {
        return this.getRemote().getIds(l);
    }

    public boolean notifyByMail(EventSettings eventSettings, String string) throws ProjectNotFoundException, NotFoundException, RemoteException {
        return this.getRemote().notifyByMail(this.getIdentifier(), this.getProjectId(), eventSettings.getEventId(), eventSettings.getActivityId(), eventSettings.getSession(), eventSettings.getRepetition(), string);
    }

    public int verifyAllEvents(boolean bl) throws ProjectNotFoundException, RemoteException {
        return this.getRemote().verifyAllEvents(this.getIdentifier(), this.getProjectId(), bl);
    }

    public void lockParticipantResources(int n) throws ProjectNotFoundException, NotFoundException, RemoteException {
        this.getRemote().lockParticipantResources(this.getIdentifier(), this.getProjectId(), n);
    }

    public void lockParticipantDates(int n) throws ProjectNotFoundException, NotFoundException, RemoteException {
        this.getRemote().lockParticipantDates(this.getIdentifier(), this.getProjectId(), n);
    }

    public void unlockParticipantResources(int n) throws ProjectNotFoundException, NotFoundException, RemoteException {
        this.getRemote().unlockParticipantResources(this.getIdentifier(), this.getProjectId(), n);
    }

    public void unlockParticipantDates(int n) throws ProjectNotFoundException, NotFoundException, RemoteException {
        this.getRemote().unlockParticipantDates(this.getIdentifier(), this.getProjectId(), n);
    }

    public Element getMonthNames() throws ProjectNotFoundException, RemoteException {
        return this.getRemote().getMonthNames(this.getIdentifier(), this.getProjectId()).getRoot();
    }

    public Element getEngineConfigurationsNames() throws ProjectNotFoundException, RemoteException {
        return this.getRoot(this.getRemote().getEngineSavedConfigurations(this.getIdentifier(), this.getProjectId()));
    }

    public Element getEngineCostWeights() throws ProjectNotFoundException, RemoteException {
        return this.getRoot(this.getRemote().getEngineCosts(this.getIdentifier(), this.getProjectId()));
    }

    public boolean refreshActivities() {
        try {
            String string = this.getParameter(IDENTIFIER);
            String string2 = this.getParameter(SERVERADE);
            String string3 = this.getParameter(SERVERADEPORT);
            RemoteSelecter remoteSelecter = (RemoteSelecter)Naming.lookup("rmi://" + string2 + ':' + string3 + "/remoteSelecter");
            remoteSelecter.refreshActivities(string, -1);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean refreshResources() {
        try {
            String string = this.getParameter(IDENTIFIER);
            String string2 = this.getParameter(SERVERADE);
            String string3 = this.getParameter(SERVERADEPORT);
            RemoteSelecter remoteSelecter = (RemoteSelecter)Naming.lookup("rmi://" + string2 + ':' + string3 + "/remoteSelecter");
            remoteSelecter.refreshResources(string, -1);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean refreshTimetable() {
        try {
            String string = this.getParameter(IDENTIFIER);
            String string2 = this.getParameter(SERVERADE);
            String string3 = this.getParameter(SERVERADEPORT);
            RemoteSelecter remoteSelecter = (RemoteSelecter)Naming.lookup("rmi://" + string2 + ':' + string3 + "/remoteSelecter");
            remoteSelecter.refreshPlanning(string, -1);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean selectActivities(int[] nArray) {
        try {
            String string = this.getParameter(IDENTIFIER);
            String string2 = this.getParameter(SERVERADE);
            String string3 = this.getParameter(SERVERADEPORT);
            int n = Integer.parseInt(this.getParameter(PROJECTID));
            RemoteSelecter remoteSelecter = (RemoteSelecter)Naming.lookup("rmi://" + string2 + ':' + string3 + "/remoteSelecter");
            remoteSelecter.selectActivity(string, n, -1, nArray);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean selectResources(int[] nArray) {
        try {
            String string = this.getParameter(IDENTIFIER);
            String string2 = this.getParameter(SERVERADE);
            String string3 = this.getParameter(SERVERADEPORT);
            int n = Integer.parseInt(this.getParameter(PROJECTID));
            RemoteSelecter remoteSelecter = (RemoteSelecter)Naming.lookup("rmi://" + string2 + ':' + string3 + "/remoteSelecter");
            remoteSelecter.selectResources(string, n, -1, nArray);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean selectPlanning(int[] nArray) {
        try {
            String string = this.getParameter(IDENTIFIER);
            String string2 = this.getParameter(SERVERADE);
            String string3 = this.getParameter(SERVERADEPORT);
            int n = Integer.parseInt(this.getParameter(PROJECTID));
            RemoteSelecter remoteSelecter = (RemoteSelecter)Naming.lookup("rmi://" + string2 + ':' + string3 + "/remoteSelecter");
            remoteSelecter.selectPlanning(string, n, -1, nArray);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void restartWeb() {
    }

    public void addAdditionalParticipant(EventSettings eventSettings, int n, boolean bl, int n2) throws RemoteException, ProjectNotFoundException, AdeException, EntityGroupError {
        this.getRemote().addAdditionalParticipant(this.getIdentifier(), this.getProjectId(), eventSettings, n, bl, n2);
    }

    public void removeAdditionalParticipant(EventSettings eventSettings, int n, int n2) throws RemoteException, ProjectNotFoundException, AdeException, EntityGroupError {
        this.getRemote().removeAdditionalParticipant(this.getIdentifier(), this.getProjectId(), eventSettings, n, n2);
    }

    public boolean[] isParticipantsAvailable(EventSettings eventSettings, int[] nArray) throws RemoteException, ProjectNotFoundException, AdeException, EntityGroupError {
        return this.getRemote().isParticipantsAvailable(this.getIdentifier(), this.getProjectId(), eventSettings, nArray);
    }

    public String getTimetableMap(TimetableUrl timetableUrl) throws RemoteException, ProjectNotFoundException {
        String string = this.getTimetableUrl(timetableUrl);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<img border=0 src=\"" + string + "\" width=" + timetableUrl.width + " height=" + timetableUrl.height + " usemap=\"#image_map\">");
        PlanningManager planningManager = new PlanningManager();
        EventsRectangles eventsRectangles = planningManager.getBounds(this.getIdentifier(), this.getProjectId(), timetableUrl);
        if (null != eventsRectangles) {
            int[] nArray = eventsRectangles.getEventIds();
            Rectangle[] rectangleArray = eventsRectangles.getBounds();
            stringBuffer.append("<map name=\"image_map\">");
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                Rectangle rectangle = rectangleArray[i];
                int n2 = rectangle.x;
                int n3 = rectangle.y;
                int n4 = rectangle.width;
                int n5 = rectangle.height;
                stringBuffer.append("<area href='javascript:Ouvre(" + n + ")' shape=\"rect\" coords=\"" + n2 + "," + n3 + "," + (n2 + n4) + "," + (n3 + n5) + "\">");
            }
            stringBuffer.append("</map>");
        }
        return stringBuffer.toString();
    }

    public int createFilter(FilterSettings filterSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().createFilter(this.getIdentifier(), this.getProjectId(), filterSettings);
    }

    public Element getFilterById(int n, int n2) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRoot(this.getRemote().getFilterById(this.getIdentifier(), this.getProjectId(), n, false, n2));
    }

    public void removeFilter(int n) throws RemoteException, ProjectNotFoundException, AdeException {
        this.getRemote().removeFilter(this.getIdentifier(), this.getProjectId(), n);
    }

    public boolean updateFilter(int n, FilterSettings filterSettings) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().updateFilter(this.getIdentifier(), this.getProjectId(), n, filterSettings);
    }

    public Element getFilters(FiltersFilters filtersFilters, int n) throws RemoteException, ProjectNotFoundException, NotFoundException {
        return this.getRemote().getFilters(this.getIdentifier(), this.getProjectId(), filtersFilters, false, n).getRoot();
    }

    public int createDisplayConfiguration(DisplaySettings displaySettings) throws PermissionException, RemoteException, SQLException {
        return this.getRemote().createDisplayConfiguration(this.getIdentifier(), this.getProjectId(), displaySettings);
    }

    public void updateDisplayConfiguration(int n, DisplaySettings displaySettings) throws RemoteException, ProjectNotFoundException {
        this.getRemote().updateDisplayConfiguration(this.getIdentifier(), this.getProjectId(), n, displaySettings);
    }

    public String getParameter(String string) {
        if (SERVERADE.equals(string)) {
            return this.getServerAde();
        }
        if (SERVERWEB.equals(string)) {
            return this.getServerWeb();
        }
        if (SERVERADEPORT.equals(string)) {
            return "" + this.getServerAdePort();
        }
        if (LOGIN.equals(string)) {
            return this.getLogin();
        }
        if (PASSWORD.equals(string)) {
            return this.getPassword();
        }
        if (PROJECTID.equals(string)) {
            return "" + this.getProjectId();
        }
        if (IDENTIFIER.equals(string)) {
            return this.getIdentifier();
        }
        String string2 = (String)this.allParameters.get(string);
        return string2;
    }

    public boolean checkConnection() {
        return true;
    }

    private void setParameter(String string, String string2) {
        this.allParameters.put(string, string2);
        if (string.equals(SERVERADE)) {
            this.setServer(string2);
        } else if (string.equals(SERVERADEPORT)) {
            this.setServerPort(Integer.parseInt(string2));
        } else if (string.equals(SERVERWEB)) {
            this.setServerWeb(string2);
        } else if (string.equals(LOGIN)) {
            this.setLogin(string2);
        } else if (string.equals(PASSWORD)) {
            this.setPassword(string2);
        } else if (string.equals(PROJECTID)) {
            this.setProjectId(Integer.parseInt(string2));
        } else if (string.equals(JDBCDRIVER)) {
            this.jdbcDriver = string2;
        } else if (string.equals(JDBCSOURCE)) {
            this.jdbcSource = string2;
        } else if (string.equals(JDBCLOGIN)) {
            this.jdbcLogin = string2;
        } else if (string.equals(JDBCPASSWORD)) {
            this.jdbcPassword = string2;
        } else if (string.equals(PROJECTID)) {
            WebSessions.getInstance().setProjectId(this.getSessionId(), Integer.parseInt(string2));
        }
    }

    public void resetParameters() {
        this.allParameters.clear();
        this.jdbcDriver = "";
        this.jdbcLogin = "";
        this.jdbcPassword = "";
        this.jdbcSource = "";
        WebSessions.getInstance().removeSession(this.getSessionId());
        this.initServer();
    }
}

