/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans;

import com.adesoft.beans.AdeBean;
import com.adesoft.beans.data.CalendarData;
import com.adesoft.beans.data.Collectable;
import com.adesoft.errors.ProjectNotFoundException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.jdom.Element;

public final class AdeBeanEx
extends Collectable {
    private volatile CalendarData calendarData = new CalendarData();
    private Locale locale;
    private AdeBean bean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CalendarData getCalendarData() {
        if (null == this.calendarData) {
            AdeBeanEx adeBeanEx = this;
            synchronized (adeBeanEx) {
                if (null == this.calendarData) {
                    this.calendarData = new CalendarData();
                    if (null != this.locale) {
                        this.calendarData.setLocale(this.locale);
                    }
                    if (null != this.bean) {
                        try {
                            this.calendarData.loadCalendar(this.bean);
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException("Impossible to load the calendar settings : " + throwable);
                        }
                    }
                }
            }
        }
        return this.calendarData;
    }

    @Override
    protected synchronized void clear() {
        this.calendarData = null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.getCalendarData().setLocale(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compareFiles(String string, String string2) {
        if (null == string) {
            throw new IllegalArgumentException("Wrong parameter in ApiUtil.compareFiles() : first file is null");
        }
        if (null == string2) {
            throw new IllegalArgumentException("Wrong parameter in ApiUtil.compareFiles() : second file is null");
        }
        try {
            File file = new File(string);
            File file2 = new File(string2);
            if (!file.exists()) return false;
            if (!file2.exists()) {
                return false;
            }
            if (file.length() != file2.length()) {
                return false;
            }
            BufferedReader bufferedReader = null;
            BufferedReader bufferedReader2 = null;
            try {
                String string3;
                String string4;
                bufferedReader = new BufferedReader(new FileReader(file));
                bufferedReader2 = new BufferedReader(new FileReader(file2));
                do {
                    if (null == (string4 = bufferedReader.readLine())) return true;
                } while (string4.equals(string3 = bufferedReader2.readLine()));
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (null != bufferedReader) {
                        bufferedReader.close();
                    }
                }
                finally {
                    if (null != bufferedReader2) {
                        bufferedReader2.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String convertToSql(String string) {
        if (-1 == string.indexOf(39)) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if ('\'' != c) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String getPaddedString(int n, int n2) {
        int n3 = Integer.toString(n2).length();
        int n4 = Integer.toString(n).length();
        StringBuffer stringBuffer = new StringBuffer(n3 + 1);
        for (int i = 0; i <= n3 - n4; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public void loadCalendar(AdeBean adeBean) throws RemoteException, ProjectNotFoundException, ParseException {
        this.updateLastCollectTime();
        this.bean = adeBean;
        this.getCalendarData().loadCalendar(adeBean);
    }

    public void freeJDomCalendar() {
        this.getCalendarData().freeJDomCalendar();
    }

    public Element getCalendar() {
        return this.getCalendarData().getCalendar();
    }

    public Date getDate(int n, int n2, int n3) {
        return this.getCalendarData().getDate(n, n2, n3);
    }

    public String getMonth(int n, int n2, int n3) {
        return this.getCalendarData().getMonth(n, n2, n3);
    }

    public String getMonthIndex(int n, int n2, int n3) {
        return this.getCalendarData().getMonthIndex(n, n2, n3);
    }

    public String getYear(int n, int n2, int n3) {
        return this.getCalendarData().getYear(n, n2, n3);
    }

    public String getDay(int n, int n2, int n3) {
        return this.getCalendarData().getDay(n, n2, n3);
    }

    public int getWeek(Date date) {
        return this.getCalendarData().getWeek(date);
    }

    public String getMonth(int n) {
        return this.getCalendarData().getMonth(n);
    }

    public String getDayName(int n) {
        return this.getCalendarData().getDayName(n);
    }

    public String getSlotName(int n) {
        return this.getCalendarData().getSlotName(n);
    }

    public String getWeekName(int n) {
        return this.getCalendarData().getWeekName(n);
    }
}

