/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans;

import com.adesoft.beans.SessionBean;
import com.adesoft.errors.AdeException;
import com.adesoft.errors.ProjectNotFoundException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jdom.Element;

public class CalendarBean
extends SessionBean {
    private final SimpleDateFormat formatSlot = new SimpleDateFormat("HH:mm:ss");
    private final SimpleDateFormat formatWeek = new SimpleDateFormat("dd/MM/yyyy");
    private Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private final SimpleDateFormat format = new SimpleDateFormat();
    private int lastprojectId;
    private int granularity;
    private Date[] slotTimes;
    private String[] slotNames;
    private int[] dayOffsets;
    private String[] dayNames;
    private Date[] weekDates;
    private String[] weekNames;
    private int firstWeek;
    private int firstDay;
    private int firstSlot;
    private int lastWeek;
    private int lastDay;
    private int lastSlot;
    private int nbWeeks;
    private int nbDays;
    private int nbSlots;

    public CalendarBean() {
        this.formatSlot.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.formatWeek.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.format.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.lastprojectId = -1;
    }

    private static final Date format(SimpleDateFormat simpleDateFormat, String string) {
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return new Date();
        }
    }

    private synchronized void load() throws RemoteException, ProjectNotFoundException {
        int n = this.getProjectId();
        if (n != this.lastprojectId) {
            this.lastprojectId = n;
            Element element = this.getRemote().getCalendar(this.getIdentifier(), this.getProjectId(), this.getClientTimeZone()).getRoot();
            Element element2 = element.getChild("slots");
            Element element3 = element.getChild("days");
            Element element4 = element.getChild("weeks");
            this.granularity = element2.getInt("granularity");
            this.firstWeek = element4.getInt("first");
            this.firstDay = element3.getInt("first");
            this.firstSlot = element2.getInt("first");
            this.lastWeek = element4.getInt("last");
            this.lastDay = element3.getInt("last");
            this.lastSlot = element2.getInt("last");
            this.nbWeeks = element4.getInt("number");
            this.nbDays = element3.getInt("number");
            this.nbSlots = element2.getInt("number");
            Element[] elementArray = element2.getChildrenArray();
            int n2 = elementArray.length;
            this.slotTimes = new Date[n2];
            this.slotNames = new String[n2];
            for (int i = 0; i < n2; ++i) {
                Element element5 = elementArray[i];
                this.slotTimes[i] = CalendarBean.format(this.formatSlot, element5.getString("date"));
                this.slotNames[i] = element5.getString("name");
            }
            Element[] elementArray2 = element3.getChildrenArray();
            int n3 = elementArray2.length;
            this.dayOffsets = new int[n3];
            this.dayNames = new String[n3];
            for (int i = 0; i < n3; ++i) {
                Element element6 = elementArray2[i];
                this.dayOffsets[i] = element6.getInt("offset");
                this.dayNames[i] = element6.getString("name");
            }
            Element[] elementArray3 = element4.getChildrenArray();
            int n4 = elementArray3.length;
            this.weekDates = new Date[n4];
            this.weekNames = new String[n4];
            for (int i = 0; i < n4; ++i) {
                Element element7 = elementArray3[i];
                this.weekDates[i] = CalendarBean.format(this.formatWeek, element7.getString("date"));
                this.weekNames[i] = element7.getString("name");
            }
        }
    }

    public Date getDate(int n, int n2, int n3) throws RemoteException, ProjectNotFoundException {
        this.load();
        Date date = this.weekDates[n + this.firstWeek - 1];
        int n4 = this.dayOffsets[n2 + this.firstDay - 1];
        Date date2 = this.slotTimes[n3 + this.firstSlot - 1];
        this.calendar.setTime(date);
        int n5 = this.calendar.get(1);
        int n6 = this.calendar.get(2);
        int n7 = this.calendar.get(5) + (n4 - 1);
        this.calendar.setTime(date2);
        this.calendar.set(5, n7);
        this.calendar.set(2, n6);
        this.calendar.set(1, n5);
        return this.calendar.getTime();
    }

    public Element getDate(Date date) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().getDate(this.getIdentifier(), this.getProjectId(), date).getRoot();
    }

    public int getCurrentSlot(Date date) throws RemoteException, ProjectNotFoundException, AdeException {
        return this.getRemote().getCurrentSlot(this.getIdentifier(), this.getProjectId(), date);
    }

    public String getMonth(int n, int n2, int n3) throws RemoteException, ProjectNotFoundException {
        this.load();
        this.format.applyPattern("MMMM");
        return this.format.format(this.getDate(n, n2, n3));
    }

    public String getMonthIndex(int n, int n2, int n3) throws RemoteException, ProjectNotFoundException {
        this.load();
        this.format.applyPattern("MM");
        return this.format.format(this.getDate(n, n2, n3));
    }

    public String getYear(int n, int n2, int n3) throws RemoteException, ProjectNotFoundException {
        this.load();
        this.format.applyPattern("yyyy");
        return this.format.format(this.getDate(n, n2, n3));
    }

    public String getDay(int n, int n2, int n3) throws RemoteException, ProjectNotFoundException {
        this.load();
        this.format.applyPattern("dd");
        return this.format.format(this.getDate(n, n2, n3));
    }

    public int getWeek(Date date) throws RemoteException, ProjectNotFoundException {
        this.load();
        for (int i = 0; i <= this.weekDates.length; ++i) {
            if (date.getTime() >= this.weekDates[i].getTime()) continue;
            int n = i - this.firstWeek;
            return n > 0 ? n : 0;
        }
        return 0;
    }

    public String getMonth(int n) throws RemoteException, ProjectNotFoundException {
        this.load();
        this.format.applyPattern("MMMM");
        return this.format.format(new Date(2000, n, 12));
    }

    public String getDayName(int n) throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.dayNames[n + this.firstDay - 1];
    }

    public String getSlotName(int n) throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.slotNames[n + this.firstSlot - 1];
    }

    public String getWeekName(int n) throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.weekNames[n + this.firstWeek - 1];
    }

    public int getGranularity() throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.granularity;
    }

    public int getFirstSlot() throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.firstSlot;
    }

    public int getFirstDay() throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.firstDay;
    }

    public int getFirstWeek() throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.firstWeek;
    }

    public int getLastSlot() throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.lastSlot;
    }

    public int getLastDay() throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.lastDay;
    }

    public int getLastWeek() throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.lastWeek;
    }

    public int getNbSlots() throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.nbSlots;
    }

    public int getNbDays() throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.nbDays;
    }

    public int getNbWeeks() throws RemoteException, ProjectNotFoundException {
        this.load();
        return this.nbWeeks;
    }

    public String format(Date date, String string) {
        this.format.applyPattern(string);
        return this.format.format(date);
    }

    public String format(int n, int n2, int n3, String string) throws RemoteException, ProjectNotFoundException {
        this.format.applyPattern(string);
        return this.format.format(this.getDate(n, n2, n3));
    }

    public Date[] getICalLimitDates() throws ProjectNotFoundException, RemoteException {
        return this.getRemote().getICalLimitDates(this.getIdentifier(), this.getProjectId());
    }
}

