/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans;

import com.adesoft.log.Category;
import com.adesoft.login.WebSessions;
import com.adesoft.misc.Util;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class CookiesSqlBean
implements Closeable {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.beans.CookiesSqlBean");
    private String jdbcDriver = "";
    private String jdbcLogin = "";
    private String jdbcPassword = "";
    private String jdbcSource = "";
    private Connection _con = null;
    private Statement _stmt = null;

    public String loadCookie(String string, HttpServletRequest httpServletRequest) {
        try {
            Cookie[] cookieArray = httpServletRequest.getCookies();
            string = this.getCookieName(string, httpServletRequest);
            if (null == cookieArray) break block4;
            for (int i = 0; i < cookieArray.length; ++i) {
                Cookie cookie = cookieArray[i];
                if (!cookie.getName().equals(string)) continue;
                return cookie.getValue();
            }
        }
        finally {
            return null;
        }
        {
            block4: {
            }
        }
    }

    private String getCookieName(String string, HttpServletRequest httpServletRequest) {
        if (null != httpServletRequest) {
            try {
                string = WebSessions.getInstance().getLogin(httpServletRequest.getSession().getId()) + "-" + string;
                string = Util.getCleanedString((String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public void saveCookie(String string, String string2, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        if (httpServletResponse != null) {
            string = this.getCookieName(string, httpServletRequest);
            Cookie cookie = new Cookie(string, string2);
            cookie.setMaxAge(432000000);
            httpServletResponse.addCookie(cookie);
        }
    }

    private Connection getSQLConnection() throws SQLException {
        if (null == this._con) {
            try {
                Class.forName(this.jdbcDriver);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("JDBC Driver not found : " + this.jdbcDriver);
            }
            this._con = DriverManager.getConnection(this.jdbcSource, this.jdbcLogin, this.jdbcPassword);
        }
        return this._con;
    }

    private Statement getSQLStatement() throws SQLException {
        if (null == this._stmt) {
            this._stmt = this.getSQLConnection().createStatement();
        }
        return this._stmt;
    }

    public ResultSet executeSQLQuery(String string) throws SQLException {
        if (null == this.jdbcDriver || 0 == this.jdbcDriver.length()) {
            throw new IllegalArgumentException("You must set the JDBC Driver.");
        }
        if (null == this.jdbcSource || 0 == this.jdbcSource.length()) {
            throw new IllegalArgumentException("You must set the JDBC Source.");
        }
        return this.getSQLStatement().executeQuery(string);
    }

    public void executeSQLUpdate(String string) throws SQLException {
        if (null == this.jdbcDriver || 0 == this.jdbcDriver.length()) {
            throw new IllegalArgumentException("You must set the JDBC Driver.");
        }
        if (null == this.jdbcSource || 0 == this.jdbcSource.length()) {
            throw new IllegalArgumentException("You must set the JDBC Source.");
        }
        this.getSQLStatement().executeUpdate(string);
    }

    public void closeSqlConnection() throws SQLException {
        SQLException sQLException;
        block7: {
            sQLException = null;
            try {
                if (null != this._stmt) {
                    this._stmt.close();
                }
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            try {
                if (null != this._con) {
                    this._con.close();
                }
            }
            catch (SQLException sQLException3) {
                if (null != sQLException) break block7;
                sQLException = sQLException3;
            }
        }
        this._stmt = null;
        this._con = null;
        if (null != sQLException) {
            throw sQLException;
        }
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcLogin() {
        return this.jdbcLogin;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public String getJdbcSource() {
        return this.jdbcSource;
    }

    public void setJdbcDriver(String string) {
        this.jdbcDriver = string;
    }

    public void setJdbcLogin(String string) {
        this.jdbcLogin = string;
    }

    public void setJdbcPassword(String string) {
        this.jdbcPassword = string;
    }

    public void setJdbcSource(String string) {
        this.jdbcSource = string;
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeSqlConnection();
        }
        catch (SQLException sQLException) {
            LOG.error((Object)sQLException);
        }
    }
}

