/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans;

import com.adesoft.beans.SessionBean;
import com.adesoft.beans.XmlMessage;
import com.adesoft.beans.settings.EngineSettings;
import com.adesoft.errors.AdeException;
import com.adesoft.errors.ProjectNotFoundException;
import java.rmi.RemoteException;
import org.jdom.Element;

public final class EngineBean
extends SessionBean {
    public int launchEngine(EngineSettings engineSettings) throws ProjectNotFoundException, AdeException, RemoteException {
        return this.getRemote().launchEngine(this.getIdentifier(), this.getProjectId(), engineSettings);
    }

    public void unloadEngine(int n) throws RemoteException {
        this.getRemote().unloadEngine(n);
    }

    public void stopEngine(int n) throws RemoteException {
        this.getRemote().stopEngine(n);
    }

    public void waitEngine(int n, int n2) throws RemoteException {
        this.getRemote().waitEngine(n, n2);
    }

    public void waitEngine(int n) throws RemoteException {
        this.getRemote().waitEngine(n, Integer.MAX_VALUE);
    }

    public void pauseEngine(int n) throws RemoteException {
        this.getRemote().pauseEngine(n);
    }

    public void resumeEngine(int n) throws RemoteException {
        this.getRemote().resumeEngine(n);
    }

    public Element getEngineInfo(int n) throws RemoteException {
        XmlMessage xmlMessage = this.getRemote().getEngineInfo(n);
        return null == xmlMessage ? null : xmlMessage.getRoot();
    }

    public Element getAllEngineInfo(int n) throws RemoteException, AdeException {
        return this.getRemote().getEngineAllInfo(n).getRoot();
    }

    public Element getLastEngineInfos(int n) throws RemoteException, AdeException {
        XmlMessage xmlMessage = this.getRemote().getEngineLastInfos(n);
        return null == xmlMessage ? null : xmlMessage.getRoot();
    }

    public Element getEngineConfigurationsNames() throws ProjectNotFoundException, RemoteException {
        return this.getRemote().getEngineSavedConfigurations(this.getIdentifier(), this.getProjectId()).getRoot();
    }

    public Element getEngineCostWeights() throws ProjectNotFoundException, RemoteException {
        return this.getRemote().getEngineCosts(this.getIdentifier(), this.getProjectId()).getRoot();
    }

    public Element getEngineConfigurationById(int n) throws ProjectNotFoundException, RemoteException {
        return this.getRoot(this.getRemote().getEngineConfigurationById(this.getIdentifier(), this.getProjectId(), n));
    }

    public Element getEngineConfigurationByName(String string) throws ProjectNotFoundException, RemoteException {
        return this.getRoot(this.getRemote().getEngineConfigurationByName(this.getIdentifier(), this.getProjectId(), string));
    }

    public Element getEngineConfigurations() throws ProjectNotFoundException, RemoteException {
        return this.getRoot(this.getRemote().getEngineConfiguration(this.getIdentifier(), this.getProjectId()));
    }

    private Element getRoot(XmlMessage xmlMessage) {
        return xmlMessage.getRoot();
    }

    public int createEngineConfiguration(EngineSettings engineSettings) throws ProjectNotFoundException, RemoteException {
        return this.getRemote().createEngineConfiguration(this.getIdentifier(), this.getProjectId(), engineSettings);
    }

    public void removeEngineConfiguration(int n) throws ProjectNotFoundException, RemoteException {
        this.getRemote().removeEngineConfiguration(this.getIdentifier(), this.getProjectId(), n);
    }

    public void retrieveEngineSolutionAndStop(int n, int n2) throws RemoteException {
        this.getRemote().retrieveEngineSolutionAndStop(n, n2);
    }

    public Element getStats(int n) throws RemoteException, ProjectNotFoundException {
        return this.getRemote().getStats(this.getIdentifier(), this.getProjectId(), n).getRoot();
    }

    public void deleteEngine(int n) throws RemoteException {
        this.getRemote().deleteEngine(n);
    }

    public void updateEngineConfiguration(int n, EngineSettings engineSettings) throws ProjectNotFoundException, RemoteException {
        this.getRemote().updateEngineConfiguration(this.getIdentifier(), this.getProjectId(), n, engineSettings);
    }
}

