/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans;

import com.adesoft.beans.ApiXml6;
import com.adesoft.beans.EventsRectangles;
import com.adesoft.beans.TimetableUrl;
import com.adesoft.errors.ProjectNotFoundException;
import com.adesoft.img.ImageUtil;
import com.adesoft.log.Category;
import com.adesoft.login.WebSessions;
import com.adesoft.timetable.Axis;
import com.adesoft.timetable.CaseEt;
import com.adesoft.timetable.Column;
import com.adesoft.timetable.EtData;
import com.adesoft.timetable.EtGrid;
import com.adesoft.timetable.MyCosts;
import com.adesoft.timetable.MyLegend;
import com.adesoft.timetable.PainterTimetable;
import com.adesoft.timetable.Preferences;
import com.adesoft.timetable.TimetableLabels;
import com.adesoft.timetable.XmlReaderTimetable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import javax.swing.JPanel;
import net.jmge.gif.Gif89Encoder;
import org.jdom.Element;

public final class PlanningManager {
    private ArrayList<Rectangle>[][] freeBoundsTab = null;
    private static final Category LOG = Category.getInstance((String)"com.adesoft.web.modules.plannings.PlanningManager");

    private ApiXml6 getRemote() {
        return WebSessions.getInstance().getRemote();
    }

    public Preferences getPreferences(String string, int n, TimetableUrl timetableUrl) {
        Preferences preferences = new Preferences();
        try {
            if (-1 != timetableUrl.displayConfId) {
                Element element = this.getRemote().getDisplayConfigurationById(string, n, timetableUrl.displayConfId).getRoot();
                preferences.parseXml(element);
            }
        }
        catch (Throwable throwable) {
            LOG.error((Object)throwable);
        }
        return preferences;
    }

    private String[] getSlotNames(String string, int n, TimeZone timeZone) throws ProjectNotFoundException, RemoteException {
        Element element = this.getRemote().getCalendar(string, n, timeZone).getRoot();
        Element element2 = element.getChild("slots");
        int n2 = element2.getInt("first");
        int n3 = element2.getInt("number");
        String[] stringArray = new String[n3 + 1];
        Element[] elementArray = element2.getChildrenArray();
        for (int i = 0; i <= n3; ++i) {
            Element element3 = elementArray[i + n2 - 1];
            stringArray[i] = element3.getString("name");
        }
        return stringArray;
    }

    public EventsRectangles getBounds(String string, int n, TimetableUrl timetableUrl) throws RemoteException, ProjectNotFoundException {
        Preferences preferences = this.getPreferences(string, n, timetableUrl);
        if (preferences.showLoad()) {
            return new EventsRectangles(new Rectangle[0], new int[0], new int[0], new int[0]);
        }
        byte[] byArray = this.getRemote().getTimetable(string, n, timetableUrl, null);
        BufferedImage bufferedImage = new BufferedImage(timetableUrl.width, timetableUrl.height, 13);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        TimetableLabels timetableLabels = new TimetableLabels(timetableUrl.movingCost, timetableUrl.cumulativeCost, timetableUrl.separator, timetableUrl.lunchName, this.getSlotNames(string, n, null));
        PainterAndLegend painterAndLegend = this.paint(graphics2D, timetableLabels, preferences, byArray, timetableUrl.width, timetableUrl.height, false);
        return painterAndLegend.getPainter().getPainterEx().getAllBounds(painterAndLegend.getLegendWidth(), painterAndLegend.getLegendHeight());
    }

    public ArrayList<Rectangle>[][] getFreeBounds(String string, int n, TimetableUrl timetableUrl) throws RemoteException, ProjectNotFoundException {
        Preferences preferences = this.getPreferences(string, n, timetableUrl);
        if (preferences.showLoad()) {
            return this.freeBoundsTab;
        }
        byte[] byArray = this.getRemote().getTimetable(string, n, timetableUrl, null);
        BufferedImage bufferedImage = new BufferedImage(timetableUrl.width, timetableUrl.height, 13);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        TimetableLabels timetableLabels = new TimetableLabels(timetableUrl.movingCost, timetableUrl.cumulativeCost, timetableUrl.separator, timetableUrl.lunchName, this.getSlotNames(string, n, null));
        PainterAndLegend painterAndLegend = this.paint(graphics2D, timetableLabels, preferences, byArray, timetableUrl.width, timetableUrl.height, false);
        EtGrid etGrid = painterAndLegend.getPainter().getGrid();
        int n2 = etGrid.getTimetable(0).getColumn(0).getNbSlots();
        int n3 = 0;
        int n4 = n2;
        if (!preferences.isDisplay(128) && preferences.getFirstSlot() != -1) {
            n3 = preferences.getFirstSlot();
            n4 = preferences.getLastSlot();
            n2 = n4 - n3;
        }
        int n5 = painterAndLegend.getPainter().getNColumns();
        int n6 = painterAndLegend.getPainter().getNRows();
        this.freeBoundsTab = new ArrayList[n6][n5];
        for (int i = 0; i < n6; ++i) {
            EtData etData = etGrid.getTimetable(i);
            double d = painterAndLegend.getPainter().getPainterEx().getWidth() / (double)n5;
            double d2 = painterAndLegend.getPainter().getPainterEx().getHeight() / (double)n6;
            for (int j = 0; j < n5; ++j) {
                Column column = etData.getColumn(j);
                boolean[] blArray = column.getTimeframe();
                CaseEt[] caseEtArray = column.getTable();
                if (preferences.isPortrait()) {
                    this.createVerticalFreeBound(blArray, i, j, caseEtArray, d2, n5, n6, painterAndLegend.getLegendWidth(), painterAndLegend.getLegendHeight(), n3, n2, (int)(d * (double)j + (double)painterAndLegend.getLegendWidth()), (int)d);
                    continue;
                }
                this.createHorizontalFreeBound(blArray, i, j, caseEtArray, d, n5, n6, painterAndLegend.getLegendWidth(), painterAndLegend.getLegendHeight(), n3, n2, (int)(d2 * (double)i + (double)painterAndLegend.getLegendHeight()), (int)d2);
            }
        }
        return this.freeBoundsTab;
    }

    private int getFirstAvailableSlot(CaseEt[] caseEtArray, int n, boolean[] blArray) {
        if (null != caseEtArray) {
            while (caseEtArray[n] != null || !blArray[n]) {
                if (n < caseEtArray.length - 1) {
                    ++n;
                    continue;
                }
                return -1;
            }
            return n;
        }
        while (!blArray[n]) {
            if (n < blArray.length - 1) {
                ++n;
                continue;
            }
            return -1;
        }
        return n;
    }

    private int getLastAvailableSlot(CaseEt[] caseEtArray, int n, boolean[] blArray) {
        if (null != caseEtArray) {
            while (caseEtArray[n] == null && blArray[n]) {
                if (n < caseEtArray.length - 1) {
                    ++n;
                    continue;
                }
                return n;
            }
        } else {
            while (blArray[n]) {
                if (n < blArray.length - 1) {
                    ++n;
                    continue;
                }
                return n;
            }
        }
        return n - 1;
    }

    private void createVerticalFreeBound(boolean[] blArray, int n, int n2, CaseEt[] caseEtArray, double d, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        ArrayList<Object> arrayList = null;
        arrayList = null == this.freeBoundsTab[n][n2] ? new ArrayList() : this.freeBoundsTab[n][n2];
        int n11 = 0;
        int n12 = -1;
        int n13 = -1;
        if (null != caseEtArray) {
            while (n11 < caseEtArray.length && -1 != (n12 = this.getFirstAvailableSlot(caseEtArray, n11, blArray))) {
                n11 = n12;
                n13 = this.getLastAvailableSlot(caseEtArray, n11, blArray);
                n11 = n13 + 1;
                int n14 = n13 - n12 + 1;
                double d2 = d * (double)n * (double)n4 / (double)n4;
                double d3 = n8 * n4;
                double d4 = d2 + d * (double)n12 * (double)n4 / d3 - d * (double)n7 / d3 + (double)n6;
                double d5 = d * (double)n14 / d3 * (double)n4;
                if (n12 > n13) continue;
                arrayList.add(new Rectangle(n9, (int)d4, n10, (int)d5));
            }
        } else {
            int n15 = n7;
            while (n15 < n8 - 1 && -1 != (n12 = this.getFirstAvailableSlot(caseEtArray, n15, blArray))) {
                n15 = n12;
                n13 = n12 != n8 - 1 ? this.getLastAvailableSlot(caseEtArray, n15, blArray) : n12 + 1;
                n15 = n13 + 1;
                int n16 = n13 - n12 + 1;
                double d6 = d * (double)n * (double)n4 / (double)n4;
                double d7 = n8 * n4;
                double d8 = d6 + d * (double)n12 * (double)n4 / d7 - d * (double)n7 / d7 + (double)n6;
                double d9 = d * (double)n16 / d7 * (double)n4;
                if (n16 <= 0) continue;
                arrayList.add(new Rectangle(n9, (int)d8, n10, (int)d9));
            }
        }
        this.freeBoundsTab[n][n2] = arrayList;
    }

    private void createHorizontalFreeBound(boolean[] blArray, int n, int n2, CaseEt[] caseEtArray, double d, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        ArrayList<Object> arrayList = null;
        arrayList = null == this.freeBoundsTab[n][n2] ? new ArrayList() : this.freeBoundsTab[n][n2];
        int n11 = 0;
        int n12 = -1;
        int n13 = -1;
        if (null != caseEtArray) {
            while (n11 < caseEtArray.length - 1 && -1 != (n12 = this.getFirstAvailableSlot(caseEtArray, n11, blArray))) {
                n11 = n12;
                n13 = this.getLastAvailableSlot(caseEtArray, n11, blArray);
                n11 = n13 + 1;
                int n14 = n13 - n12 + 1;
                double d2 = d * (double)n2 * (double)n3 / (double)n3;
                double d3 = n8 * n3;
                double d4 = d2 + d * (double)n12 * (double)n3 / d3 - d * (double)n7 / d3 + (double)n5;
                double d5 = d * (double)n14 * (double)n3 / d3;
                if (n12 > n13) continue;
                arrayList.add(new Rectangle((int)d4, n9, (int)d5, n10));
            }
        } else {
            int n15 = n7;
            while (n15 < n8 - 1 && -1 != (n12 = this.getFirstAvailableSlot(caseEtArray, n15, blArray))) {
                n15 = n12;
                n13 = this.getLastAvailableSlot(caseEtArray, n15, blArray);
                n15 = n13 + 1;
                int n16 = n13 - n12 + 1;
                double d6 = d * (double)n2 * (double)n3 / (double)n3;
                double d7 = n8 * n3;
                double d8 = d6 + d * (double)n12 * (double)n3 / d7 - d * (double)n7 / d7 + (double)n5;
                double d9 = d * (double)n16 * (double)n3 / d7;
                if (n16 <= 0) continue;
                arrayList.add(new Rectangle((int)d8, n9, (int)d9, n10));
            }
        }
        this.freeBoundsTab[n][n2] = arrayList;
    }

    public byte[] getImage(String string, int n, TimetableUrl timetableUrl) throws IOException, ProjectNotFoundException, RemoteException {
        return this.getImage(string, n, timetableUrl, null);
    }

    public byte[] getImage(String string, int n, TimetableUrl timetableUrl, TimeZone timeZone) throws IOException, ProjectNotFoundException, RemoteException {
        byte[] byArray = this.getRemote().getTimetable(string, n, timetableUrl, timeZone);
        String[] stringArray = this.getSlotNames(string, n, timeZone);
        Preferences preferences = this.getPreferences(string, n, timetableUrl);
        TimetableLabels timetableLabels = new TimetableLabels(timetableUrl.movingCost, timetableUrl.cumulativeCost, timetableUrl.separator, timetableUrl.lunchName, stringArray);
        BufferedImage bufferedImage = new BufferedImage(timetableUrl.width, timetableUrl.height, 13);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(255, 255, 255));
        graphics2D.fillRect(0, 0, timetableUrl.width, timetableUrl.height);
        this.paint(graphics2D, timetableLabels, preferences, byArray, timetableUrl.width, timetableUrl.height, true);
        return this.convertImage(bufferedImage);
    }

    public byte[] getImage(String string, int n, TimetableUrl timetableUrl, int n2) throws IOException, ProjectNotFoundException, RemoteException {
        return this.getImage(string, n, timetableUrl, null);
    }

    public byte[] getImage(String string, int n, TimetableUrl timetableUrl, List<Integer> list, TimeZone timeZone) throws IOException, ProjectNotFoundException, RemoteException {
        byte[] byArray = this.getRemote().getTimetable(string, n, timetableUrl, list, timeZone);
        String[] stringArray = this.getSlotNames(string, n, timeZone);
        Preferences preferences = this.getPreferences(string, n, timetableUrl);
        TimetableLabels timetableLabels = new TimetableLabels(timetableUrl.movingCost, timetableUrl.cumulativeCost, timetableUrl.separator, timetableUrl.lunchName, stringArray);
        BufferedImage bufferedImage = new BufferedImage(timetableUrl.width, timetableUrl.height, 13);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(255, 255, 255));
        graphics2D.fillRect(0, 0, timetableUrl.width, timetableUrl.height);
        this.paint(graphics2D, timetableLabels, preferences, byArray, timetableUrl.width, timetableUrl.height, true);
        return this.convertImage(bufferedImage);
    }

    private byte[] convertImage(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
        Gif89Encoder gif89Encoder = new Gif89Encoder((Image)bufferedImage);
        gif89Encoder.setComments("");
        gif89Encoder.encode((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private PainterAndLegend paint(Graphics2D graphics2D, TimetableLabels timetableLabels, Preferences preferences, byte[] byArray, int n, int n2, boolean bl) {
        Object object;
        XmlReaderTimetable xmlReaderTimetable = new XmlReaderTimetable();
        try {
            xmlReaderTimetable.read(new GZIPInputStream(new ByteArrayInputStream(byArray)));
        }
        catch (Throwable throwable) {
            LOG.error((Object)throwable);
        }
        EtGrid etGrid = xmlReaderTimetable.getGrid();
        etGrid.validate(preferences.getCostsIds(), preferences.isMovingCost());
        int n3 = etGrid.getGranularity();
        n3 = n3 > 15 ? 1 : 30 / n3;
        MyLegend myLegend = new MyLegend(Axis.Y, timetableLabels);
        MyLegend myLegend2 = new MyLegend(Axis.X, timetableLabels);
        myLegend2.setStep(n3);
        myLegend.setStep(n3);
        myLegend.setData(graphics2D, etGrid, preferences);
        myLegend2.setData(graphics2D, etGrid, preferences);
        if (!preferences.showLoad()) {
            myLegend.setLoadMaximum(-1);
            myLegend2.setLoadMaximum(-1);
            myLegend.setDrawSlotInMiddle(false);
            myLegend2.setDrawSlotInMiddle(false);
        } else {
            if (!preferences.isPortrait()) {
                myLegend2.setLoadMaximum(-1);
                myLegend.setLoadMaximum(etGrid.getHistoData().getMaximum());
            } else {
                myLegend.setLoadMaximum(-1);
                myLegend2.setLoadMaximum(etGrid.getHistoData().getMaximum());
            }
            myLegend.setDrawSlotInMiddle(true);
            myLegend2.setDrawSlotInMiddle(true);
        }
        MyCosts myCosts = new MyCosts(Axis.Y, timetableLabels);
        MyCosts myCosts2 = new MyCosts(Axis.X, timetableLabels);
        MyCosts myCosts3 = new MyCosts(Axis.Y, timetableLabels);
        myCosts3.setLegend(true);
        MyCosts myCosts4 = new MyCosts(Axis.X, timetableLabels);
        myCosts4.setLegend(true);
        MyCosts myCosts5 = new MyCosts(Axis.INTERSECT, timetableLabels);
        myCosts.setData(graphics2D, etGrid, preferences);
        myCosts2.setData(graphics2D, etGrid, preferences);
        myCosts3.setData(graphics2D, etGrid, preferences);
        myCosts4.setData(graphics2D, etGrid, preferences);
        myCosts5.setData(graphics2D, etGrid, preferences);
        int n4 = myLegend.getDim(graphics2D, n2);
        int n5 = myLegend2.getDim(graphics2D, n);
        int n6 = myCosts3.getDim();
        int n7 = myCosts4.getDim();
        n -= n4 + n6;
        n2 -= n5 + n7;
        if (bl) {
            graphics2D.translate(n4, 0);
            myLegend2.render(graphics2D, n, n5);
            graphics2D.translate(n, 0);
            if (preferences.getCostsColsRowsView() != 0) {
                myCosts3.render(graphics2D, n6, n5);
            }
            graphics2D.translate(-n4 - n, n5);
            myLegend.render(graphics2D, n4, n2);
            graphics2D.translate(0, n2);
            if (preferences.getCostsColsRowsView() != 0) {
                myCosts4.render(graphics2D, n4, n7);
            }
            graphics2D.translate(n4, 0);
            if (preferences.getCostsColsRowsView() != 0) {
                myCosts2.render(graphics2D, n, n7);
            }
            graphics2D.translate(n, 0);
            if (preferences.getCostsColsRowsView() != 0) {
                myCosts5.render(graphics2D, n6, n7);
            }
            graphics2D.translate(0, -n2);
            if (preferences.getCostsColsRowsView() != 0) {
                myCosts.render(graphics2D, n6, n2);
            }
            graphics2D.translate(-n, 0);
        }
        Dimension dimension = new Dimension(n, n2);
        Image[] imageArray = new Image[11];
        imageArray[0] = ImageUtil.getImage((String)"res/padlock.gif");
        imageArray[1] = ImageUtil.getImage((String)"res/padlock2.gif");
        imageArray[3] = ImageUtil.getImage((String)"res/workflow.gif");
        imageArray[4] = ImageUtil.getImage((String)"res/notes.gif");
        imageArray[5] = ImageUtil.getImage((String)"res/upEvent.gif");
        imageArray[6] = ImageUtil.getImage((String)"res/downEvent.gif");
        imageArray[7] = ImageUtil.getImage((String)"res/leftEvent.gif");
        imageArray[8] = ImageUtil.getImage((String)"res/rightEvent.gif");
        imageArray[9] = ImageUtil.getImage((String)"res/exclamation.gif");
        imageArray[10] = ImageUtil.getImage((String)"res/minilinks.gif");
        try {
            object = new JPanel();
            MediaTracker mediaTracker = new MediaTracker((Component)object);
            for (int i = 0; i < imageArray.length; ++i) {
                if (null == imageArray[i]) continue;
                mediaTracker.addImage(imageArray[i], i);
            }
            mediaTracker.waitForAll();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = new PainterTimetable(null, preferences, etGrid, imageArray, timetableLabels);
        ((PainterTimetable)object).paint(dimension, graphics2D, false, n5, myLegend2.getBoldCoords(), n4, myLegend.getBoldCoords(), n6, n7);
        return new PainterAndLegend((PainterTimetable)object, n4, n5);
    }

    private static final class PainterAndLegend {
        private final PainterTimetable painter;
        private final int legendWidth;
        private final int legendHeight;

        public PainterAndLegend(PainterTimetable painterTimetable, int n, int n2) {
            this.painter = painterTimetable;
            this.legendWidth = n;
            this.legendHeight = n2;
        }

        public PainterTimetable getPainter() {
            return this.painter;
        }

        public int getLegendWidth() {
            return this.legendWidth;
        }

        public int getLegendHeight() {
            return this.legendHeight;
        }
    }
}

