/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans;

import com.adesoft.beans.AdeApi;
import com.adesoft.beans.AdeList;
import com.adesoft.beans.data.Collectable;
import com.adesoft.beans.data.TreeDataActivity;
import com.adesoft.beans.filters.FiltersActivities;
import com.adesoft.errors.NotFoundException;
import com.adesoft.errors.ProjectNotFoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Element;

public class TreeActivity
extends Collectable {
    private AdeApi ade;
    private volatile TreeDataActivity data;
    protected int detailed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeDataActivity getData() {
        if (null == this.data) {
            TreeActivity treeActivity = this;
            synchronized (treeActivity) {
                if (null == this.data) {
                    this.data = new TreeDataActivity();
                    if (null != this.ade) {
                        try {
                            this.data.loadTree(this.ade, true, this.getFilters(), this.detailed);
                        }
                        catch (Throwable throwable) {
                            throw new RuntimeException("Impossible to reset the tree");
                        }
                    }
                }
            }
        }
        this.updateLastCollectTime();
        return this.data;
    }

    @Override
    protected synchronized void clear() {
        this.data = null;
    }

    public void loadTree(AdeApi adeApi, HttpServletRequest httpServletRequest, FiltersActivities filtersActivities, int n, String string) throws Exception {
        this.loadTree(adeApi, httpServletRequest, filtersActivities, n, string, false);
    }

    public void loadTree(AdeApi adeApi, HttpServletRequest httpServletRequest, FiltersActivities filtersActivities, int n) throws Exception {
        this.loadTree(adeApi, httpServletRequest, filtersActivities, n, "all", false);
    }

    public void loadTree(AdeApi adeApi, HttpServletRequest httpServletRequest, FiltersActivities filtersActivities, int n, boolean bl) throws Exception {
        this.loadTree(adeApi, httpServletRequest, filtersActivities, n, "all", bl);
    }

    public void loadTree(AdeApi adeApi, HttpServletRequest httpServletRequest, FiltersActivities filtersActivities, int n, String string, boolean bl) throws Exception {
        this.ade = adeApi;
        this.detailed = n;
        boolean bl2 = true;
        if (null != httpServletRequest.getParameter("reload")) {
            bl2 = Boolean.valueOf(httpServletRequest.getParameter("reload"));
        }
        this.getData().loadTree(adeApi, bl2, filtersActivities, n, string);
    }

    public void openOrCloseId(int n) {
        this.getData().openOrCloseId(n);
    }

    public void expandAll() {
        this.getData().expandAll();
    }

    public void resetExpandAll() {
        this.getData().resetExpandAll();
    }

    public void select(int n, boolean bl) {
        this.getData().select(n, bl, true);
    }

    public void select(int n, boolean bl, boolean bl2) {
        this.getData().select(n, bl, bl2);
    }

    public void selectBranch(int n, boolean bl) {
        this.getData().selectBranch(n, bl, true);
    }

    public void selectBranch(int n, boolean bl, boolean bl2) {
        this.getData().selectBranch(n, bl, bl2);
    }

    public void selectCategory(String string, boolean bl) {
        this.getData().selectCategory(string, bl);
    }

    public void unSelectAll() {
        this.getData().unSelectAll();
    }

    public AdeList getSelected() {
        return this.getData().getSelected();
    }

    public String getStringSelected() {
        return this.getData().getStringSelected();
    }

    public String getStringBranchSelected() {
        return this.getData().getStringBranchSelected();
    }

    public AdeList getSelectedBranches() {
        return this.getData().getSelectedBranches();
    }

    public AdeList getAllLeavesSelected() throws Exception {
        return this.getData().getAllLeavesSelected();
    }

    public String getAllLeavesStringSelected() throws Exception {
        return this.getData().getAllLeavesStringSelected();
    }

    public void closeAll() {
        this.getData().closeAll();
    }

    public void addColumn(String string) {
        this.getData().addColumn(string);
    }

    public void removeColumn(String string) {
        this.getData().removeColumn(string);
    }

    public void resetColumns() {
        this.getData().resetColumns();
    }

    public HashSet getColumns() {
        return this.getData().getColumns();
    }

    public void updateTree(HttpServletRequest httpServletRequest) throws Exception {
        int n;
        if (null != httpServletRequest.getParameter("branchId")) {
            n = Integer.parseInt(httpServletRequest.getParameter("branchId"));
            this.openOrCloseId(n);
        }
        if (null != httpServletRequest.getParameter("selectId")) {
            this.select(Integer.parseInt(httpServletRequest.getParameter("selectId")), false, false);
        }
        if (null != httpServletRequest.getParameter("selectBranchId")) {
            n = Integer.parseInt(httpServletRequest.getParameter("selectBranchId"));
            this.selectBranch(n, false, false);
            boolean bl = false;
            if (this.getSelectedBranches().contains(new Integer(n))) {
                bl = true;
            }
            FiltersActivities filtersActivities = new FiltersActivities();
            AdeList adeList = new AdeList();
            adeList.add(n);
            filtersActivities.addFilterFolders(adeList);
            Element element = this.ade.getTreeActivities(filtersActivities, 4);
            this.parseActivities(element.getChildren().iterator(), n, false, bl);
        }
    }

    private void parseActivities(Iterator iterator, int n, boolean bl, boolean bl2) throws NotFoundException, RemoteException, ProjectNotFoundException {
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            if (element.getName().equals("leaf") && bl) {
                int n2 = element.getAttribute("id").getIntValue();
                if ((!bl2 || this.getSelected().contains(new Integer(n2))) && (bl2 || !this.getSelected().contains(new Integer(n2)))) continue;
                this.select(n2, false, false);
                continue;
            }
            if (element.getName().equals("branch")) {
                int n3 = element.getAttribute("id").getIntValue();
                if (n == n3) {
                    bl = true;
                }
                if (bl && (bl2 && !this.getSelectedBranches().contains(new Integer(n3)) || !bl2 && this.getSelectedBranches().contains(new Integer(n3)))) {
                    this.selectBranch(n3, false, false);
                }
                Iterator iterator2 = element.getChildren().iterator();
                this.parseActivities(iterator2, n, bl, bl2);
                continue;
            }
            if (!element.getName().equals("category")) continue;
            Iterator iterator3 = element.getChildren().iterator();
            this.parseActivities(iterator3, n, bl, bl2);
        }
    }

    public ArrayList parseTree() throws Exception {
        return this.getData().parseTree();
    }

    public FiltersActivities getFilters() {
        return this.getData().getFilters();
    }
}

