/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans;

import com.adesoft.beans.AdeApi;
import com.adesoft.config.ConfigManager;
import com.adesoft.errors.ProjectNotFoundException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.jdom.Element;

public final class WebDisplayManager {
    private static final String XMLFILE = "WebDisplay";
    private static final String ROOT = "options";
    private static final String ELT_TAB = "tab";
    private static final String ELT_ACTIVITY = "activity";
    private static final String ELT_CHECKBOX = "checkbox";
    private static final String ELT_CATEGORY = "category";
    private static final String ELT_GRAPHIC = "graphic";
    private static final String ELT_PIANO = "piano";
    private static final String ATTR_COOKIE = "cookie";
    private static final String ATTR_DISPLAY = "display";
    private static final String ATTR_CONFIGURATION = "configuration";
    private static final String ATTR_WEEKS = "weeks";
    private static final String ATTR_DAYS = "days";
    private static final String ATTR_ID = "id";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TYPE = "type";
    private static final String NAME = "NAME";
    private static final String WEEK = "WEEK";
    private static final String DAY = "DAY";
    private static final String DATE = "DATE";
    private static final String TIME = "TIME";
    private static final String STAGE = "STAGE";
    private static final String CODE_ACTIVITY = "CODE_ACTIVITY";
    private static final String TYPE_ACTIVITY = "TYPE_ACTIVITY";
    private static final String WEB_ACTIVITY = "WEB_ACTIVITY";
    private static final String DURATION = "DURATION";
    private static final String SIZE = "SIZE";
    private static final String MAXSEATS = "MAXSEATS";
    private static final String SEATSLEFT = "SEATSLEFT";
    private static final String CODEX_ACTIVITY = "CODEX_ACTIVITY";
    private static final String CODEY_ACTIVITY = "CODEY_ACTIVITY";
    private static final String CODEZ_ACTIVITY = "CODEZ_ACTIVITY";
    private static final String TIMEZONE_ACTIVITY = "TIMEZONE_ACTIVITY";
    private static final String INFO_ACTIVITY = "INFO_ACTIVITY";
    private static final String INFO_EVENT = "INFO_EVENT";
    private boolean showTab;
    private boolean showGraphic;
    private String configuration;
    private int displayConfId;
    private boolean showWeeks;
    private boolean showDays;
    private static WebDisplayManager instance = new WebDisplayManager();
    private boolean cookie;
    private HashMap<Integer, HashMap<String, Boolean>> options = new HashMap();

    private WebDisplayManager() {
        try {
            this.parseElements(ConfigManager.getInstance().readXmlFile(XMLFILE));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refresh() {
        try {
            this.parseElements(ConfigManager.getInstance().readXmlFile(XMLFILE));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static WebDisplayManager getInstance() {
        return instance;
    }

    public boolean checkCookie() {
        return this.cookie;
    }

    public boolean showTab() {
        return this.showTab;
    }

    public boolean showGraphic() {
        return this.showGraphic;
    }

    public boolean showPianoWeeks() {
        return this.showWeeks;
    }

    public boolean showPianoDays() {
        return this.showDays;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public int getDisplayConfigurationId(String string, AdeApi adeApi) throws ProjectNotFoundException, RemoteException {
        this.displayConfId = -1;
        Element[] elementArray = adeApi.getDisplayConfigurations(null).getChildrenArray();
        Comparator<Element> comparator = new Comparator<Element>(){

            @Override
            public int compare(Element element, Element element2) {
                return element.getString("name").compareTo(element2.getString("name"));
            }
        };
        Arrays.sort(elementArray, comparator);
        for (Element element : elementArray) {
            int n = element.getInt(ATTR_ID);
            String string2 = element.getString("name");
            if (!this.getConfiguration().equals(string2)) continue;
            this.displayConfId = n;
        }
        return this.displayConfId;
    }

    public boolean isFieldCategoryCheckedByName(int n, String string) {
        HashMap<String, Boolean> hashMap = this.options.get(n);
        if (!hashMap.containsKey(string)) {
            return false;
        }
        return hashMap.get(string);
    }

    public boolean showName() {
        return this.isFieldCategoryCheckedByName(0, NAME);
    }

    public boolean showWeek() {
        return this.isFieldCategoryCheckedByName(0, WEEK);
    }

    public boolean showDay() {
        return this.isFieldCategoryCheckedByName(0, DAY);
    }

    public boolean showStage() {
        return this.isFieldCategoryCheckedByName(0, STAGE);
    }

    public boolean showDate() {
        return this.isFieldCategoryCheckedByName(0, DATE);
    }

    public boolean showTime() {
        return this.isFieldCategoryCheckedByName(0, TIME);
    }

    public boolean showCodeActivity() {
        return this.isFieldCategoryCheckedByName(0, CODE_ACTIVITY);
    }

    public boolean showTypeActivity() {
        return this.isFieldCategoryCheckedByName(0, TYPE_ACTIVITY);
    }

    public boolean showUrlActivity() {
        return this.isFieldCategoryCheckedByName(0, WEB_ACTIVITY);
    }

    public boolean showDuration() {
        return this.isFieldCategoryCheckedByName(0, DURATION);
    }

    public boolean showSizeActivity() {
        return this.isFieldCategoryCheckedByName(0, SIZE);
    }

    public boolean showMaxSeatsActivity() {
        return this.isFieldCategoryCheckedByName(0, MAXSEATS);
    }

    public boolean showSeatsLeftActivity() {
        return this.isFieldCategoryCheckedByName(0, SEATSLEFT);
    }

    public boolean showCodeXActivity() {
        return this.isFieldCategoryCheckedByName(0, CODEX_ACTIVITY);
    }

    public boolean showCodeYActivity() {
        return this.isFieldCategoryCheckedByName(0, CODEY_ACTIVITY);
    }

    public boolean showCodeZActivity() {
        return this.isFieldCategoryCheckedByName(0, CODEZ_ACTIVITY);
    }

    public boolean showTimezoneActivity() {
        return this.isFieldCategoryCheckedByName(0, TIMEZONE_ACTIVITY);
    }

    public boolean showInfoActivity() {
        return this.isFieldCategoryCheckedByName(0, INFO_ACTIVITY);
    }

    public boolean showInfoEvent() {
        return this.isFieldCategoryCheckedByName(0, INFO_EVENT);
    }

    private void reset() {
        this.options.clear();
        this.initOptions();
    }

    private void initOptions() {
        for (int i = 0; i <= 8; ++i) {
            HashMap hashMap = new HashMap();
            this.options.put(i, hashMap);
        }
    }

    private void parseElements(Element element) {
        if (null != element && element.getName().equalsIgnoreCase(ROOT)) {
            this.reset();
            this.cookie = element.getBoolean(ATTR_COOKIE);
            for (Object object : element.getChildren(ELT_TAB)) {
                Element element2;
                Object object22;
                this.showTab = object.getBoolean(ATTR_DISPLAY);
                for (Object object22 : object.getChildren(ELT_ACTIVITY)) {
                    element2 = this.options.get(0);
                    for (Object object3 : object22.getChildren(ELT_CHECKBOX)) {
                        String string = object3.getString(ATTR_ID);
                        boolean bl = object3.getBoolean(ATTR_VALUE);
                        element2.put(string, bl);
                        this.options.put(0, (HashMap<String, Boolean>)element2);
                    }
                }
                object22 = object.getChildren(ELT_CATEGORY).iterator();
                while (object22.hasNext()) {
                    Object object3;
                    element2 = (Element)object22.next();
                    int n = element2.getInt(ATTR_TYPE);
                    object3 = this.options.get(n);
                    for (Element element3 : element2.getChildren(ELT_CHECKBOX)) {
                        String string = element3.getString(ATTR_ID);
                        boolean bl = element3.getBoolean(ATTR_VALUE);
                        ((HashMap)object3).put(string, bl);
                    }
                    this.options.put(n, (HashMap<String, Boolean>)object3);
                }
            }
            for (Object object : element.getChildren(ELT_GRAPHIC)) {
                this.showGraphic = object.getBoolean(ATTR_DISPLAY);
                this.configuration = object.getString(ATTR_CONFIGURATION);
            }
            for (Object object22 : element.getChildren(ELT_PIANO)) {
                this.showWeeks = object22.getBoolean(ATTR_WEEKS);
                this.showDays = object22.getBoolean(ATTR_DAYS);
            }
        }
    }
}

