/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans;

import com.adesoft.beans.AdeApi;
import com.adesoft.beans.AdeList;
import com.adesoft.beans.MapResourceBooking;
import com.adesoft.beans.TreeActivity;
import com.adesoft.beans.filters.FiltersActivities;
import com.adesoft.beans.filters.FiltersResources;
import com.adesoft.beans.settings.ActivitySettings;
import com.adesoft.config.ConfigManager;
import com.adesoft.errors.AdeException;
import com.adesoft.errors.LockedException;
import com.adesoft.errors.NoAccesException;
import com.adesoft.errors.NotFoundException;
import com.adesoft.errors.ProjectNotFoundException;
import com.adesoft.properties.ServerProperty;
import java.awt.Color;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Element;

public final class WizardBooking {
    private AdeApi api;
    int activityId = -1;
    int templateId = -1;
    int maxTry = 15;
    boolean firstAccess;
    private ActivitySettings as;
    private int firstSlot;
    private int lastSlot;
    private int firstSlotScheduled;
    private int lastSlotScheduled;
    private int week;
    private int day;
    private String firstDate;
    private String lastDate;
    private Map<String, Element> mapModel;
    private String name;
    private String type;
    private String code;
    private String color;
    private String path;
    private Double duration;
    private int folderId;
    private TreeActivity tree;
    private AdeList imposedResources;
    private ArrayList<MapResourceBooking> chosenResources;
    private int typeResa;
    private String searchFolderValue;
    private AdeList filterList;
    private boolean hasSelection;
    public boolean[] tmpCheck;
    private String subjectRequest;

    private AdeApi getApi() {
        return this.api;
    }

    public void setActivityData(AdeApi adeApi, String string, int n, String string2, String string3, String string4, String string5, int n2) {
        try {
            this.as = new ActivitySettings();
            this.as.setName(string2);
            this.as.setDuration(string);
            this.as.setRepetition(n);
            this.as.setType(string3);
            this.as.setCode(string4);
            if (!string5.startsWith("#")) {
                string5 = "#" + string5;
            }
            this.as.setColor(Color.decode(string5));
            this.as.setFolderId(n2);
        }
        catch (Throwable throwable) {
            System.out.println("ERREUR : " + throwable);
        }
    }

    public void initData(HttpServletRequest httpServletRequest, AdeApi adeApi, TreeActivity treeActivity) throws NotFoundException, ProjectNotFoundException, IOException, AdeException, Exception {
        this.init(httpServletRequest, adeApi, treeActivity);
    }

    private void init(HttpServletRequest httpServletRequest, AdeApi adeApi, TreeActivity treeActivity) throws Exception {
        this.api = adeApi;
        this.tree = treeActivity;
        this.tree.clear();
        this.tree.loadTree(this.api, httpServletRequest, null, 4, "all");
        this.resetData();
    }

    public static void sleep() {
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addActivityImposedResource(int n, int n2) throws RemoteException, ProjectNotFoundException, AdeException {
        boolean bl = true;
        LockedException lockedException = null;
        NoAccesException noAccesException = null;
        for (int i = 0; i < this.maxTry && bl; ++i) {
            try {
                lockedException = null;
                noAccesException = null;
                this.getApi().addActivityImposedResource(n, n2);
                bl = false;
                continue;
            }
            catch (LockedException lockedException2) {
                lockedException = lockedException2;
                WizardBooking.sleep();
                bl = true;
                continue;
            }
            catch (NoAccesException noAccesException2) {
                noAccesException = noAccesException2;
                WizardBooking.sleep();
                bl = true;
            }
        }
        if (null != lockedException) {
            throw lockedException;
        }
        if (null != noAccesException) {
            throw noAccesException;
        }
    }

    public void addResources(int n, AdeList adeList, boolean bl, boolean bl2) throws RemoteException, ProjectNotFoundException, AdeException {
        Iterator iterator = adeList.iterator();
        int n2 = -1;
        int n3 = 0;
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            if (n3 < 1) {
                if (bl2) {
                    boolean bl3 = ConfigManager.getInstance().getBooleanProperty(ServerProperty.WORKFLOW_COPY_BY_MAIL);
                    n2 = this.getApi().addActivityRequestResource(n, n4, this.getSubjectRequest(), "", bl3, false, null);
                } else {
                    n2 = this.getApi().addActivityChoosenResource(n, n4);
                }
            } else {
                this.getApi().addActivityResource(n, n4, n2);
            }
            if (bl) {
                this.getApi().setActivityOrContinuous(n, n2, true);
            }
            ++n3;
        }
    }

    public void setActivityResources() throws RemoteException, ProjectNotFoundException, AdeException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Iterator<Object> iterator;
        if (this.imposedResources != null) {
            iterator = this.imposedResources.iterator();
            while (iterator.hasNext()) {
                int bl = (Integer)iterator.next();
                if (this.getApi().checkActionResource(bl, "ENTITY_ASSOCIATECOURSE")) {
                    this.addActivityImposedResource(this.getActivityId(), bl);
                    continue;
                }
                boolean mapResourceBooking = ConfigManager.getInstance().getBooleanProperty(ServerProperty.WORKFLOW_COPY_BY_MAIL);
                this.getApi().addActivityRequestResource(this.activityId, bl, this.getSubjectRequest(), "", mapResourceBooking, false, null);
            }
        }
        if (this.chosenResources != null) {
            iterator = this.chosenResources.iterator();
            while (iterator.hasNext()) {
                boolean bl = false;
                MapResourceBooking mapResourceBooking = (MapResourceBooking)iterator.next();
                AdeList adeList = mapResourceBooking.getList();
                boolean bl2 = mapResourceBooking.isContinuous();
                Iterator iterator2 = adeList.iterator();
                while (iterator2.hasNext()) {
                    int n = (Integer)iterator2.next();
                    if (this.getApi().checkActionResource(n, "ENTITY_ASSOCIATECOURSE")) continue;
                    bl = true;
                }
                this.addResources(this.getActivityId(), adeList, bl2, bl);
            }
        }
    }

    private int createActivity(ActivitySettings activitySettings) throws RemoteException, ProjectNotFoundException, AdeException {
        boolean bl = true;
        LockedException lockedException = null;
        NoAccesException noAccesException = null;
        int n = -1;
        for (int i = 0; i < this.maxTry && bl; ++i) {
            try {
                lockedException = null;
                noAccesException = null;
                n = this.getApi().createActivity(activitySettings);
                bl = false;
                continue;
            }
            catch (LockedException lockedException2) {
                lockedException = lockedException2;
                WizardBooking.sleep();
                bl = true;
                continue;
            }
            catch (NoAccesException noAccesException2) {
                noAccesException = noAccesException2;
                WizardBooking.sleep();
                bl = true;
            }
        }
        if (null != lockedException) {
            throw lockedException;
        }
        if (null != noAccesException) {
            throw noAccesException;
        }
        return n;
    }

    public int createResa() throws RemoteException, AdeException, SQLException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        if (null != this.as && !this.as.getName().equals("")) {
            this.activityId = this.createActivity(this.as);
            this.setActivityResources();
        }
        return this.activityId;
    }

    public TreeActivity getTree() {
        return this.tree;
    }

    public Element[] getActivityModel(int n, String string) throws Exception {
        Element[] elementArray = null;
        FiltersActivities filtersActivities = new FiltersActivities();
        AdeList adeList = new AdeList();
        if (null != string && !string.equals("".trim())) {
            filtersActivities.addFilterName(string);
            elementArray = this.getApi().getActivities(filtersActivities, 9).getChildrenArray();
        } else if (n != -1) {
            Object object;
            int n2;
            adeList.add(n);
            filtersActivities.addFilterFolders(adeList);
            Element element = this.getApi().getActivities(filtersActivities, 9);
            Element[] elementArray2 = element.getChildrenArray();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (n2 = 0; n2 < elementArray2.length; ++n2) {
                object = elementArray2[n2];
                if (object.getInt("folderId") != n) continue;
                arrayList.add(object);
            }
            n2 = 0;
            object = arrayList.iterator();
            elementArray = new Element[arrayList.size()];
            while (object.hasNext()) {
                elementArray[n2] = (Element)object.next();
                ++n2;
            }
        } else {
            Object object;
            int n3;
            Element element = this.getApi().getActivities(null, 9);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Element[] elementArray3 = element.getChildrenArray();
            for (n3 = 0; n3 < elementArray3.length; ++n3) {
                object = elementArray3[n3];
                if (object.getInt("folderId") != -1) continue;
                arrayList.add(object);
            }
            n3 = 0;
            object = arrayList.iterator();
            elementArray = new Element[arrayList.size()];
            while (object.hasNext()) {
                elementArray[n3] = (Element)object.next();
                ++n3;
            }
        }
        return elementArray;
    }

    public void setFirstAccess(boolean bl) {
        this.firstAccess = bl;
    }

    public boolean isFirstAccess() {
        return this.firstAccess;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getCode() {
        return this.code;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String string) {
        this.color = string;
    }

    public void setCode(String string) {
        this.code = string;
    }

    public int getFolderId() {
        return this.folderId;
    }

    public void setFolderId(int n) {
        this.folderId = n;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public Double getDuration() {
        if (this.duration == null) {
            this.duration = 1.0;
        }
        return this.duration;
    }

    public int getDurationSlot() throws RemoteException, ProjectNotFoundException {
        double d = 0.0;
        Element element = this.getApi().getCalendar();
        int n = element.getChild("slots").getAttribute("granularity").getIntValue();
        d = n == 30 || n == 60 ? this.duration * 60.0 / (double)n : this.duration / (double)n;
        return (int)d;
    }

    public void setDuration(Double d) {
        this.duration = d;
    }

    public void setFirstSlot(int n) {
        this.firstSlot = n;
    }

    public int getFirstSlot() {
        return this.firstSlot;
    }

    public void setLastSlot(int n) {
        this.lastSlot = n;
    }

    public int getLastSlot() {
        return this.lastSlot;
    }

    public void setFirstSlotScheduled(int n) {
        this.firstSlotScheduled = n;
    }

    public int getFirstSlotScheduled() {
        return this.firstSlotScheduled;
    }

    public void setLastSlotScheduled(int n) {
        this.lastSlotScheduled = n;
    }

    public int getLastSlotScheduled() {
        return this.lastSlotScheduled;
    }

    public void selectWeek(int n) {
        this.week = n;
    }

    public void selectDay(int n) {
        this.day = n;
    }

    public int getWeek() {
        return this.week;
    }

    public int getDay() {
        return this.day;
    }

    private int getActivityId() {
        return this.activityId;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(int n) {
        this.templateId = n;
    }

    public Map<String, Element> getMapModel() {
        if (null == this.mapModel) {
            this.mapModel = new HashMap<String, Element>();
        }
        return this.mapModel;
    }

    public void clearMap() {
        if (null == this.mapModel) {
            this.mapModel = new HashMap<String, Element>();
        }
        this.mapModel.clear();
    }

    public void cleanImposedList() {
        if (null != this.imposedResources) {
            this.imposedResources.clear();
        }
    }

    public void addKeyModel(String string, Element element) {
        this.mapModel.put(string, element);
    }

    public void setSelection() {
        this.hasSelection = true;
    }

    public void removeSelection() {
        this.hasSelection = false;
    }

    public boolean hasSelection() {
        return this.hasSelection;
    }

    public void setSearchFolderValue(String string) {
        this.searchFolderValue = string;
    }

    public String getSearchFolderValue() {
        return this.searchFolderValue;
    }

    public void addImposedResource(int n) {
        if (null == this.imposedResources) {
            this.imposedResources = new AdeList();
        }
        if (!this.imposedResources.contains(n)) {
            this.imposedResources.add(n);
        }
    }

    public void removeImposedResource(int n) throws InterruptedException {
        if (this.imposedResources.contains(n)) {
            this.imposedResources.remove(new Integer(n));
            Thread.sleep(10L);
        }
    }

    public AdeList getImposedListIds() {
        if (null == this.imposedResources) {
            return new AdeList();
        }
        return this.imposedResources;
    }

    public ArrayList<MapResourceBooking> getChosenResources() {
        if (null == this.chosenResources) {
            this.chosenResources = new ArrayList();
        }
        return this.chosenResources;
    }

    public void addchosenResource(int n, int n2) throws NotFoundException, RemoteException, ProjectNotFoundException {
        if (null == this.chosenResources) {
            this.chosenResources = new ArrayList();
        }
        MapResourceBooking mapResourceBooking = this.getchosenListIds(n);
        AdeList adeList = mapResourceBooking.getList();
        AdeList adeList2 = mapResourceBooking.getRealList();
        if (!adeList2.contains(n2)) {
            adeList2.add(n2);
        }
        FiltersResources filtersResources = new FiltersResources();
        AdeList adeList3 = new AdeList();
        adeList3.add(n2);
        filtersResources.addFilterTree(true, false);
        filtersResources.addFilterGroups(adeList3);
        Element[] elementArray = this.getApi().getResources(filtersResources, 1).getChildrenArray();
        if (elementArray.length > 1) {
            for (int i = 0; i < elementArray.length; ++i) {
                Element element = elementArray[i];
                int n3 = element.getInt("id");
                adeList3.add(n3);
            }
        }
        filtersResources = new FiltersResources();
        filtersResources.addFilterGroups(adeList3);
        filtersResources.addFilterTree(false, true);
        Element[] elementArray2 = this.getApi().getResources(filtersResources, 1).getChildrenArray();
        if (elementArray2.length > 0) {
            for (int i = 0; i < elementArray2.length; ++i) {
                Element element = elementArray2[i];
                int n4 = element.getInt("id");
                if (adeList.contains(n4)) continue;
                adeList.add(n4);
            }
        }
        mapResourceBooking.setList(adeList);
        mapResourceBooking.setRealList(adeList2);
        this.chosenResources.set(n, mapResourceBooking);
    }

    public void removeChosenResource(int n) {
        if (null != this.chosenResources.get(n)) {
            this.chosenResources.remove(n);
        }
    }

    public int getNbChosen() {
        if (null == this.chosenResources) {
            this.chosenResources = new ArrayList();
            return 0;
        }
        return this.chosenResources.size();
    }

    public MapResourceBooking getchosenListIds(int n) {
        MapResourceBooking mapResourceBooking = null;
        if (null == this.chosenResources) {
            this.chosenResources = new ArrayList();
        }
        if (this.chosenResources.isEmpty()) {
            this.chosenResources.add(new MapResourceBooking());
        }
        if (n >= this.chosenResources.size()) {
            this.chosenResources.add(new MapResourceBooking());
        }
        mapResourceBooking = this.chosenResources.get(n);
        return mapResourceBooking;
    }

    public void setContinuousChosen(int n, boolean bl) {
        this.chosenResources.get(n).setContinuous(bl);
    }

    public void setFirstDate(String string) {
        this.firstDate = string;
    }

    public String getFirstDate() {
        return this.firstDate;
    }

    public void setLastDate(String string) {
        this.lastDate = string;
    }

    public String getLastDate() {
        return this.lastDate;
    }

    public void setTypeResa(int n) {
        this.typeResa = n;
    }

    public int getTypeResa() {
        return this.typeResa;
    }

    private String getSubjectRequest() {
        return this.subjectRequest;
    }

    public void setSubjectRequest(String string) {
        this.subjectRequest = string;
    }

    public void resetSlots() {
        this.firstSlot = -1;
        this.lastSlot = -1;
    }

    public void resetData() throws NotFoundException, RemoteException {
        this.folderId = -1;
        this.templateId = -1;
        this.firstAccess = true;
        this.hasSelection = false;
        this.name = "";
        this.type = "";
        this.code = "";
        this.color = "#FFFFFF";
        this.as = null;
        this.firstSlot = -1;
        this.lastSlot = -1;
        this.firstDate = null;
        this.lastDate = null;
        this.firstSlotScheduled = -1;
        this.firstSlotScheduled = -1;
        this.week = 0;
        this.day = 0;
        this.getImposedListIds().clear();
        this.getChosenResources().clear();
        this.typeResa = -1;
    }
}

