/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans;

import com.adesoft.beans.XmlMessage;
import com.adesoft.fastxml.BytesOutputStream;
import com.adesoft.fastxml.XmlWriter;
import com.adesoft.xml2.ElementFast;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public final class XmlMessageElementFast
implements XmlMessage,
Serializable {
    private static final long serialVersionUID = 520L;
    private transient ElementFast fastRoot;
    private transient Element root;

    public XmlMessageElementFast(ElementFast elementFast) {
        this.fastRoot = elementFast;
    }

    @Override
    public Element getRoot() {
        return this.root;
    }

    public ElementFast getFastRoot() {
        return this.fastRoot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        BytesOutputStream bytesOutputStream = new BytesOutputStream();
        try {
            XmlWriter xmlWriter = new XmlWriter((OutputStream)new GZIPOutputStream((OutputStream)bytesOutputStream), true);
            this.fastRoot.outputXML(xmlWriter);
            xmlWriter.close();
        }
        catch (IOException iOException) {
            throw new IOException("Impossible to output the XML document content : " + iOException);
        }
        objectOutputStream.writeInt(bytesOutputStream.length());
        bytesOutputStream.writeTo((OutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        try {
            Document document = new SAXBuilder().build((InputStream)new GZIPInputStream(new ByteArrayInputStream(byArray)));
            this.root = document.getRootElement();
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid gzipped format : " + throwable);
        }
    }
}

