/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans.data;

import com.adesoft.beans.AdeBean;
import com.adesoft.errors.ProjectNotFoundException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.jdom.Element;

public final class CalendarData {
    private Date[] slotTimes;
    private String[] slotNames;
    private int[] dayOffsets;
    private String[] dayNames;
    private Date[] weekDates;
    private String[] weekNames;
    private int firstWeek;
    private int firstDay;
    private int firstSlot;
    private Element eltCalendar;
    private Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private SimpleDateFormat format = new SimpleDateFormat();

    public CalendarData() {
        this.format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void freeJDomCalendar() {
        this.calendar = null;
    }

    public void setLocale(Locale locale) {
        this.format = new SimpleDateFormat("yy", locale);
        this.format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void loadCalendar(AdeBean adeBean) throws RemoteException, ProjectNotFoundException, ParseException {
        Object object;
        int n;
        if (null == adeBean) {
            throw new IllegalArgumentException("AdeBean is null");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd/MM/yyyy");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.eltCalendar = adeBean.getCalendar();
        List list = this.eltCalendar.getChild("slots").getChildren();
        int n2 = list.size();
        this.slotTimes = new Date[n2];
        this.slotNames = new String[n2];
        Iterator iterator = list.iterator();
        for (int i = 0; i < n2; ++i) {
            Element element = (Element)iterator.next();
            this.slotTimes[i] = simpleDateFormat.parse(element.getAttributeValue("date"));
            this.slotNames[i] = element.getAttributeValue("name");
        }
        List list2 = this.eltCalendar.getChild("days").getChildren();
        int n3 = list2.size();
        this.dayOffsets = new int[n3];
        this.dayNames = new String[n3];
        Iterator iterator2 = list2.iterator();
        for (n = 0; n < n3; ++n) {
            object = (Element)iterator2.next();
            this.dayOffsets[n] = object.getAttribute("offset").getIntValue();
            this.dayNames[n] = object.getAttributeValue("name");
        }
        this.firstWeek = this.eltCalendar.getChild("weeks").getAttribute("first").getIntValue();
        this.firstDay = this.eltCalendar.getChild("days").getAttribute("first").getIntValue();
        this.firstSlot = this.eltCalendar.getChild("slots").getAttribute("first").getIntValue();
        n = this.eltCalendar.getChild("weeks").getChildren().size();
        this.weekDates = new Date[n];
        this.weekNames = new String[n];
        object = this.eltCalendar.getChild("weeks").getChildren();
        Iterator iterator3 = object.iterator();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)iterator3.next();
            this.weekDates[i] = simpleDateFormat2.parse(element.getAttributeValue("date"));
            this.weekNames[i] = element.getAttributeValue("name");
        }
    }

    public Element getCalendar() {
        return this.eltCalendar;
    }

    private void checkCalendarIsLoaded() {
        if (null == this.slotTimes || null == this.dayOffsets || null == this.weekDates) {
            throw new IllegalArgumentException("You must call loadCalendar() first.");
        }
    }

    public Date getDate(int n, int n2, int n3) {
        this.checkCalendarIsLoaded();
        Date date = this.weekDates[n + this.firstWeek - 1];
        int n4 = this.dayOffsets[n2 + this.firstDay - 1];
        Date date2 = this.slotTimes[n3 + this.firstSlot - 1];
        this.calendar.setTime(date);
        int n5 = this.calendar.get(1);
        int n6 = this.calendar.get(2);
        int n7 = this.calendar.get(5) + (n4 - 1);
        this.calendar.setTime(date2);
        this.calendar.set(5, n7);
        this.calendar.set(2, n6);
        this.calendar.set(1, n5);
        return this.calendar.getTime();
    }

    public String getMonth(int n, int n2, int n3) {
        this.checkCalendarIsLoaded();
        this.format.applyPattern("MMMM");
        return this.format.format(this.getDate(n, n2, n3));
    }

    public String getMonthIndex(int n, int n2, int n3) {
        this.checkCalendarIsLoaded();
        this.format.applyPattern("MM");
        return this.format.format(this.getDate(n, n2, n3));
    }

    public String getYear(int n, int n2, int n3) {
        this.checkCalendarIsLoaded();
        this.format.applyPattern("yyyy");
        return this.format.format(this.getDate(n, n2, n3));
    }

    public String getDay(int n, int n2, int n3) {
        this.checkCalendarIsLoaded();
        this.format.applyPattern("dd");
        return this.format.format(this.getDate(n, n2, n3));
    }

    public int getWeek(Date date) {
        this.checkCalendarIsLoaded();
        for (int i = 0; i <= this.weekDates.length; ++i) {
            if (date.getTime() >= this.weekDates[i].getTime()) continue;
            int n = i - this.firstWeek;
            if (n > 0) {
                return n;
            }
            return 0;
        }
        return 0;
    }

    public int getSlot(Date date) {
        this.checkCalendarIsLoaded();
        this.calendar.setTime(date);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        int n = this.eltCalendar.getChild("slots").getAttribute("first").getIntValue();
        for (int i = 0; i <= this.slotTimes.length; ++i) {
            Date date2 = this.slotTimes[i];
            calendar.setTime(date2);
            if (this.calendar.get(10) >= calendar.get(10) && (this.calendar.get(10) != calendar.get(10) || this.calendar.get(12) > calendar.get(12))) continue;
            int n2 = i - n;
            if (n2 > 0) {
                return n2;
            }
            return 0;
        }
        return 0;
    }

    public String getMonth(int n) {
        this.format.applyPattern("MMMM");
        return this.format.format(new Date(2000, n, 12));
    }

    public String getDayName(int n) {
        int n2 = this.eltCalendar.getChild("days").getAttribute("first").getIntValue();
        return this.dayNames[n + n2 - 1];
    }

    public String getSlotName(int n) {
        int n2 = this.eltCalendar.getChild("slots").getAttribute("first").getIntValue();
        return this.slotNames[n + n2 - 1];
    }

    public String getWeekName(int n) {
        int n2 = this.eltCalendar.getChild("weeks").getAttribute("first").getIntValue();
        return this.weekNames[n + n2 - 1];
    }

    public int getDay(Date date) {
        return 0;
    }
}

