/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans.data;

import com.adesoft.beans.data.ThreadCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public abstract class Collectable
implements HttpSessionListener {
    private static final HashMap collectables = new HashMap();
    private static final ThreadCollector threadCollector = new ThreadCollector();
    private long lastCollectTime;

    protected Collectable() {
        this.updateLastCollectTime();
    }

    public void setSessionId(String string) {
        this.register(string);
    }

    public static synchronized Collectable[] getAllObjects() {
        int n = 0;
        Iterator iterator = collectables.values().iterator();
        ArrayList<Collectable> arrayList = new ArrayList<Collectable>();
        while (iterator.hasNext()) {
            for (Collectable collectable : (ArrayList)iterator.next()) {
                arrayList.add(collectable);
                ++n;
            }
        }
        Collectable[] collectableArray = new Collectable[n];
        arrayList.toArray(collectableArray);
        return collectableArray;
    }

    public final long getLastCollectTime() {
        return this.lastCollectTime;
    }

    public final void updateLastCollectTime() {
        this.lastCollectTime = System.currentTimeMillis();
    }

    protected synchronized void register(String string) {
        ArrayList<Collectable> arrayList = (ArrayList<Collectable>)collectables.get(string);
        if (null == arrayList) {
            arrayList = new ArrayList<Collectable>();
        }
        arrayList.add(this);
        collectables.put(string, arrayList);
        if (1 == collectables.size() && !threadCollector.isStarted()) {
            threadCollector.start();
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        collectables.remove(httpSessionEvent.getSession().getId());
    }

    protected abstract void clear();
}

