/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans.data;

import com.adesoft.beans.AdeApi6;
import com.adesoft.beans.AdeBean;
import com.adesoft.beans.AdeList;
import com.adesoft.beans.SaveOptions;
import com.adesoft.beans.SimpleTreeElement;
import com.adesoft.beans.filters.FiltersParticipants;
import com.adesoft.beans.filters.FiltersResources;
import com.adesoft.config.ConfigManager;
import com.adesoft.properties.ServerProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jdom.DataConversionException;
import org.jdom.Element;

public final class TreeData {
    private AdeBean ade;
    private String type = "all";
    private Element treeTrainees;
    private Element treeInstructors;
    private Element treeRooms;
    private Element treeResources;
    private Element tree5;
    private Element tree6;
    private Element tree7;
    private Element tree8;
    private FiltersParticipants filters;
    private int detail;
    private AdeList selectIds = new AdeList();
    private AdeList selectBranchIds = new AdeList();
    private AdeList allLeavesSelected = new AdeList();
    private boolean selectTrainees = false;
    private boolean selectInstructors = false;
    private boolean selectRooms = false;
    private boolean selectResources = false;
    private boolean selectCategory5 = false;
    private boolean selectCategory6 = false;
    private boolean selectCategory7 = false;
    private boolean selectCategory8 = false;
    private boolean selectionHasCompute = false;
    private AdeList openIds = new AdeList();
    private boolean openTrainees = false;
    private boolean openInstructors = false;
    private boolean openRooms = false;
    private boolean openResources = false;
    private boolean openCategory5 = false;
    private boolean openCategory6 = false;
    private boolean openCategory7 = false;
    private boolean openCategory8 = false;
    private HashSet columns = new HashSet();
    private boolean expandAll;
    private boolean selectAllLeaves = false;
    private HashMap<Integer, Boolean> visibleCategories = new HashMap();
    private int defaultMaxSelectionSize = ConfigManager.getInstance().getIntProperty(ServerProperty.WEB_MAX_SELECTION_SIZE);
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            try {
                String string = ((Element)object).getString("name");
                String string2 = ((Element)object2).getString("name");
                return string.compareTo(string2);
            }
            catch (Throwable throwable) {
                return 0;
            }
        }
    };

    public Element getTreeTrainees() {
        return this.treeTrainees;
    }

    public Element getTreeInstructors() {
        return this.treeInstructors;
    }

    public Element getTreeRooms() {
        return this.treeRooms;
    }

    public Element getTreeResources() {
        return this.treeResources;
    }

    public Element getTreeCategory5() {
        return this.tree5;
    }

    public Element getTreeCategory6() {
        return this.tree6;
    }

    public Element getTreeCategory7() {
        return this.tree7;
    }

    public Element getTreeCategory8() {
        return this.tree8;
    }

    public void openOrCloseId(int n) {
        if (this.openIds.contains(n)) {
            this.openIds.removeInt(n);
        } else {
            this.openIds.add(n);
        }
    }

    public void expandAll() {
        this.expandAll = true;
        this.openTrainees = true;
        this.openInstructors = true;
        this.openRooms = true;
        this.openResources = true;
        this.openCategory5 = true;
        this.openCategory6 = true;
        this.openCategory7 = true;
        this.openCategory8 = true;
    }

    public void openCategory(String string) throws Exception {
        if (string.equals("trainee")) {
            this.openTrainees = true;
            if (null == this.treeTrainees) {
                this.treeTrainees = this.ade.getTreeTrainees(this.filters, this.detail);
            }
        } else if (string.equals("instructor")) {
            this.openInstructors = true;
            if (null == this.treeInstructors) {
                this.treeInstructors = this.ade.getTreeInstructors(this.filters, this.detail);
            }
        } else if (string.equals("classroom") || string.equals("room")) {
            this.openRooms = true;
            if (null == this.treeRooms) {
                this.treeRooms = this.ade.getTreeRooms(this.filters, this.detail);
            }
        } else if (string.equals("resource") || string.equals("equipment")) {
            this.openResources = true;
            if (null == this.treeResources) {
                this.treeResources = this.ade.getTreeResources(this.filters, this.detail);
            }
        } else if (string.equals("category5")) {
            this.openCategory5 = true;
            if (null == this.tree5) {
                this.tree5 = this.ade.getTreeCategory(this.filters, "category5", this.detail);
            }
        } else if (string.equals("category6")) {
            this.openCategory6 = true;
            if (null == this.tree6) {
                this.tree6 = this.ade.getTreeCategory(this.filters, "category6", this.detail);
            }
        } else if (string.equals("category7")) {
            this.openCategory7 = true;
            if (null == this.tree7) {
                this.tree7 = this.ade.getTreeCategory(this.filters, "category7", this.detail);
            }
        } else if (string.equals("category8")) {
            this.openCategory8 = true;
            if (null == this.tree8) {
                this.tree8 = this.ade.getTreeCategory(this.filters, "category8", this.detail);
            }
        }
    }

    public String getMainBranchesOfSelectedCategory() {
        Element[] elementArray = null;
        if (this.isSelectTrainee()) {
            elementArray = this.getTreeTrainees().getChild("category").getChildrenArray();
        } else if (this.isSelectInstructor()) {
            elementArray = this.getTreeInstructors().getChild("category").getChildrenArray();
        } else if (this.isSelectRoom()) {
            elementArray = this.getTreeRooms().getChild("category").getChildrenArray();
        } else if (this.isSelectResource()) {
            elementArray = this.getTreeResources().getChild("category").getChildrenArray();
        } else if (this.isSelectCategory5()) {
            elementArray = this.getTreeCategory5().getChild("category").getChildrenArray();
        } else if (this.isSelectCategory6()) {
            elementArray = this.getTreeCategory6().getChild("category").getChildrenArray();
        } else if (this.isSelectCategory7()) {
            elementArray = this.getTreeCategory7().getChild("category").getChildrenArray();
        } else if (this.isSelectCategory8()) {
            elementArray = this.getTreeCategory8().getChild("category").getChildrenArray();
        }
        String string = "";
        if (null != elementArray) {
            for (int i = 0; i < elementArray.length; ++i) {
                if (i != 0) {
                    string = string + ",";
                }
                string = string + elementArray[i].getInt("id");
            }
        }
        return string;
    }

    public void openOrCloseCategory(String string) throws Exception {
        if (string.equals("trainee")) {
            boolean bl = this.openTrainees = !this.openTrainees;
            if (this.openTrainees && null == this.treeTrainees) {
                this.treeTrainees = this.ade.getTreeTrainees(this.filters, this.detail);
            }
        } else if (string.equals("instructor")) {
            boolean bl = this.openInstructors = !this.openInstructors;
            if (this.openInstructors && null == this.treeInstructors) {
                this.treeInstructors = this.ade.getTreeInstructors(this.filters, this.detail);
            }
        } else if (string.equals("room")) {
            boolean bl = this.openRooms = !this.openRooms;
            if (this.openRooms && null == this.treeRooms) {
                this.treeRooms = this.ade.getTreeRooms(this.filters, this.detail);
            }
        } else if (string.equals("resource")) {
            boolean bl = this.openResources = !this.openResources;
            if (this.openResources && null == this.treeResources) {
                this.treeResources = this.ade.getTreeResources(this.filters, this.detail);
            }
        } else if (string.equals("category5")) {
            boolean bl = this.openCategory5 = !this.openCategory5;
            if (this.openCategory5 && null == this.tree5) {
                this.tree5 = this.ade.getTreeCategory(this.filters, "category5", this.detail);
            }
        } else if (string.equals("category6")) {
            boolean bl = this.openCategory6 = !this.openCategory6;
            if (this.openCategory6 && null == this.tree6) {
                this.tree6 = this.ade.getTreeCategory(this.filters, "category6", this.detail);
            }
        } else if (string.equals("category7")) {
            boolean bl = this.openCategory7 = !this.openCategory7;
            if (this.openCategory7 && null == this.tree7) {
                this.tree7 = this.ade.getTreeCategory(this.filters, "category7", this.detail);
            }
        } else if (string.equals("category8")) {
            boolean bl = this.openCategory8 = !this.openCategory8;
            if (this.openCategory8 && null == this.tree8) {
                this.tree8 = this.ade.getTreeCategory(this.filters, "category8", this.detail);
            }
        }
    }

    public boolean select(int n, boolean bl, boolean bl2, int n2) throws Exception {
        if (-1 == n2) {
            n2 = this.defaultMaxSelectionSize;
        }
        AdeList adeList = new AdeList((Collection)this.selectIds);
        AdeList adeList2 = new AdeList((Collection)this.selectBranchIds);
        boolean bl3 = this.selectTrainees;
        boolean bl4 = this.selectInstructors;
        boolean bl5 = this.selectRooms;
        boolean bl6 = this.selectCategory5;
        boolean bl7 = this.selectCategory6;
        boolean bl8 = this.selectCategory7;
        boolean bl9 = this.selectCategory8;
        this.selectionHasCompute = false;
        if (bl) {
            this.unSelectAll();
        }
        if (!this.selectIds.contains(n)) {
            this.selectIds.add(n);
            if (this.getAllLeavesSelected().size() > n2) {
                this.selectIds = adeList;
                this.selectBranchIds = adeList2;
                this.selectTrainees = bl3;
                this.selectInstructors = bl4;
                this.selectRooms = bl5;
                this.selectCategory5 = bl6;
                this.selectCategory6 = bl7;
                this.selectCategory7 = bl8;
                this.selectCategory8 = bl9;
                this.selectionHasCompute = false;
                return false;
            }
        } else if (this.selectIds.size() > 1 || !bl2) {
            this.selectIds.removeInt(n);
        }
        return true;
    }

    public boolean selectBranch(int n, boolean bl, boolean bl2, int n2) throws Exception {
        if (-1 == n2) {
            n2 = this.defaultMaxSelectionSize;
        }
        AdeList adeList = new AdeList((Collection)this.selectIds);
        AdeList adeList2 = new AdeList((Collection)this.selectBranchIds);
        boolean bl3 = this.selectTrainees;
        boolean bl4 = this.selectInstructors;
        boolean bl5 = this.selectRooms;
        boolean bl6 = this.selectCategory5;
        boolean bl7 = this.selectCategory6;
        boolean bl8 = this.selectCategory7;
        boolean bl9 = this.selectCategory8;
        this.selectionHasCompute = false;
        if (bl) {
            this.unSelectAll();
        }
        if (!this.selectBranchIds.contains(n)) {
            this.selectBranchIds.add(n);
            if (this.getAllLeavesSelected().size() > n2) {
                this.selectIds = adeList;
                this.selectBranchIds = adeList2;
                this.selectTrainees = bl3;
                this.selectInstructors = bl4;
                this.selectRooms = bl5;
                this.selectCategory5 = bl6;
                this.selectCategory6 = bl7;
                this.selectCategory7 = bl8;
                this.selectCategory8 = bl9;
                this.selectionHasCompute = false;
                return false;
            }
        } else if (this.selectBranchIds.size() >= 1 || !bl2) {
            this.selectBranchIds.removeInt(n);
        }
        return true;
    }

    public boolean selectCategory(String string, boolean bl, int n) throws Exception {
        if (-1 == n) {
            n = this.defaultMaxSelectionSize;
        }
        AdeList adeList = new AdeList((Collection)this.selectIds);
        AdeList adeList2 = new AdeList((Collection)this.selectBranchIds);
        boolean bl2 = this.selectTrainees;
        boolean bl3 = this.selectInstructors;
        boolean bl4 = this.selectRooms;
        boolean bl5 = this.selectResources;
        boolean bl6 = this.selectCategory5;
        boolean bl7 = this.selectCategory6;
        boolean bl8 = this.selectCategory7;
        boolean bl9 = this.selectCategory8;
        this.selectionHasCompute = false;
        if (bl) {
            this.unSelectAll();
        }
        if (string.equals("trainee")) {
            boolean bl10 = this.selectTrainees = !this.selectTrainees;
            if (null == this.treeTrainees) {
                this.treeTrainees = this.ade.getTreeTrainees(this.filters, this.detail);
            }
        } else if (string.equals("instructor")) {
            boolean bl11 = this.selectInstructors = !this.selectInstructors;
            if (null == this.treeInstructors) {
                this.treeInstructors = this.ade.getTreeInstructors(this.filters, this.detail);
            }
        } else if (string.equals("room")) {
            boolean bl12 = this.selectRooms = !this.selectRooms;
            if (null == this.treeRooms) {
                this.treeRooms = this.ade.getTreeRooms(this.filters, this.detail);
            }
        } else if (string.equals("resource")) {
            boolean bl13 = this.selectResources = !this.selectResources;
            if (null == this.treeResources) {
                this.treeResources = this.ade.getTreeResources(this.filters, this.detail);
            }
        } else if (string.equals("category5")) {
            boolean bl14 = this.selectCategory5 = !this.selectCategory5;
            if (null == this.tree5) {
                this.tree5 = this.ade.getTreeCategory(this.filters, "category5", this.detail);
            }
        } else if (string.equals("category6")) {
            boolean bl15 = this.selectCategory6 = !this.selectCategory6;
            if (null == this.tree6) {
                this.tree6 = this.ade.getTreeCategory(this.filters, "category6", this.detail);
            }
        } else if (string.equals("category7")) {
            boolean bl16 = this.selectCategory7 = !this.selectCategory7;
            if (null == this.tree7) {
                this.tree7 = this.ade.getTreeCategory(this.filters, "category7", this.detail);
            }
        } else if (string.equals("category8")) {
            boolean bl17 = this.selectCategory8 = !this.selectCategory8;
            if (null == this.tree8) {
                this.tree8 = this.ade.getTreeCategory(this.filters, "category8", this.detail);
            }
        }
        if (this.getAllLeavesSelected().size() > n) {
            this.selectIds = adeList;
            this.selectBranchIds = adeList2;
            this.selectTrainees = bl2;
            this.selectInstructors = bl3;
            this.selectRooms = bl4;
            this.selectResources = bl5;
            this.selectCategory5 = bl6;
            this.selectCategory6 = bl7;
            this.selectCategory7 = bl8;
            this.selectCategory8 = bl9;
            this.selectionHasCompute = false;
            return false;
        }
        return true;
    }

    public AdeList getSelected() {
        return this.selectIds;
    }

    public String getStringSelected() {
        String string = "";
        Iterator iterator = this.selectIds.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n != 0) {
                string = string + ",";
            }
            string = string + n2;
            ++n;
        }
        return string;
    }

    public void addColumn(String string) {
        this.columns.add(string);
    }

    public void removeColumn(String string) {
        this.columns.remove(string);
    }

    public void resetColumns() {
        this.columns = new HashSet();
    }

    public HashSet getColumns() {
        return this.columns;
    }

    public ArrayList parseTree(SaveOptions saveOptions, boolean[] blArray) throws Exception {
        if (this.selectAllLeaves) {
            this.unSelectAll();
        }
        ArrayList<SimpleTreeElement> arrayList = new ArrayList<SimpleTreeElement>();
        if ((this.type.equals("all") || this.type.equals("trainee")) && blArray[0] && this.visibleCategories.get(1).booleanValue() && saveOptions.showTreeCategory1) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("trainee"), 0, 2, false, this.openTrainees));
            if (this.openTrainees) {
                this.openCategory("trainee");
            }
            if (null != this.treeTrainees && this.openTrainees) {
                this.parseCategory(this.treeTrainees, arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("instructor")) && blArray[1] && this.visibleCategories.get(2).booleanValue() && saveOptions.showTreeCategory2) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("instructor"), 0, 2, false, this.openInstructors));
            if (this.openInstructors) {
                this.openCategory("instructor");
            }
            if (null != this.treeInstructors && this.openInstructors) {
                this.parseCategory(this.treeInstructors, arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("room")) && blArray[2] && this.visibleCategories.get(3).booleanValue() && saveOptions.showTreeCategory3) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("room"), 0, 2, false, this.openRooms));
            if (this.openRooms) {
                this.openCategory("room");
            }
            if (null != this.treeRooms && this.openRooms) {
                this.parseCategory(this.treeRooms, arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("resource")) && blArray[3] && this.visibleCategories.get(4).booleanValue() && saveOptions.showTreeCategory4) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("resource"), 0, 2, false, this.openResources));
            if (this.openResources) {
                this.openCategory("resource");
            }
            if (null != this.treeResources && this.openResources) {
                this.parseCategory(this.treeResources, arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("category5")) && blArray[4] && this.visibleCategories.get(5).booleanValue() && saveOptions.showTreeCategory5) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("category5"), 0, 2, false, this.openCategory5));
            if (this.openCategory5) {
                this.openCategory("category5");
            }
            if (null != this.tree5 && this.openCategory5) {
                this.parseCategory(this.tree5, arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("category6")) && blArray[5] && this.visibleCategories.get(6).booleanValue() && saveOptions.showTreeCategory6) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("category6"), 0, 2, false, this.openCategory6));
            if (this.openCategory6) {
                this.openCategory("category6");
            }
            if (null != this.tree6 && this.openCategory6) {
                this.parseCategory(this.tree6, arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("category7")) && blArray[6] && this.visibleCategories.get(7).booleanValue() && saveOptions.showTreeCategory7) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("category7"), 0, 2, false, this.openCategory7));
            if (this.openCategory7) {
                this.openCategory("category7");
            }
            if (null != this.tree7 && this.openCategory7) {
                this.parseCategory(this.tree7, arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("category8")) && blArray[7] && this.visibleCategories.get(8).booleanValue() && saveOptions.showTreeCategory8) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("category8"), 0, 2, false, this.openCategory8));
            if (this.openCategory8) {
                this.openCategory("category8");
            }
            if (null != this.tree8 && this.openCategory8) {
                this.parseCategory(this.tree8, arrayList);
            }
        }
        this.expandAll = false;
        this.selectAllLeaves = false;
        return arrayList;
    }

    private Element createElementCategory(String string) {
        Element element = new Element("category");
        element.addAttribute("participantType", string);
        return element;
    }

    private void parseCategory(Element element, ArrayList arrayList) throws Exception {
        Element[] elementArray = element.getChild("category").getChildrenArray();
        Arrays.sort(elementArray, COMPARATOR);
        this.parseParticipants(arrayList, elementArray, 1);
    }

    private void parseParticipants(ArrayList arrayList, Element[] elementArray, int n) throws DataConversionException {
        AdeList adeList = new AdeList();
        for (int i = 0; i < elementArray.length; ++i) {
            int n2;
            Element element = elementArray[i];
            String string = element.getName();
            if (string.equals("leaf")) {
                n2 = element.getAttribute("id").getIntValue();
                adeList.add(n2);
                if (this.selectAllLeaves && !this.selectIds.contains(n2)) {
                    this.selectIds.add(n2);
                }
                arrayList.add(new SimpleTreeElement(element, n, 0, this.selectIds.contains(n2), false));
                continue;
            }
            if (!string.equals("branch")) continue;
            n2 = element.getAttribute("id").getIntValue();
            if (this.expandAll && !this.openIds.contains(n2)) {
                this.openIds.add(n2);
            }
            arrayList.add(new SimpleTreeElement(element, n, 1, this.selectIds.contains(n2), this.openIds.contains(n2)));
            if (!this.openIds.contains(n2)) continue;
            Element[] elementArray2 = element.getChildrenArray();
            Arrays.sort(elementArray2, COMPARATOR);
            this.parseParticipants(arrayList, elementArray2, n + 1);
        }
    }

    public void loadTree(AdeBean adeBean, boolean bl, FiltersParticipants filtersParticipants, int n) throws Exception {
        this.loadTree(adeBean, bl, filtersParticipants, n, "all");
    }

    public void loadTree(AdeBean adeBean, boolean bl, FiltersParticipants filtersParticipants, int n, String string) throws Exception {
        if (bl) {
            this.ade = adeBean;
            this.filters = filtersParticipants;
            this.detail = n;
            this.type = string;
            AdeApi6 adeApi6 = new AdeApi6();
            adeApi6.setSessionId(adeBean.getSessionId());
            Element element = adeApi6.getCategoriesRights();
            for (Element element2 : element.getChildrenArray()) {
                this.visibleCategories.put(element2.getInt("id"), element2.getBoolean("canRead"));
            }
            if (element.getChildren().size() < 8) {
                for (int i = element.getChildren().size() + 1; i <= 8; ++i) {
                    this.visibleCategories.put(i, false);
                }
            }
            if ((string.equals("all") || string.equals("trainee")) && null != this.treeTrainees) {
                this.treeTrainees = adeBean.getTreeTrainees(filtersParticipants, this.detail);
            }
            if ((string.equals("all") || string.equals("instructor")) && null != this.treeInstructors) {
                this.treeInstructors = adeBean.getTreeInstructors(filtersParticipants, this.detail);
            }
            if ((string.equals("all") || string.equals("room")) && null != this.treeRooms) {
                this.treeRooms = adeBean.getTreeRooms(filtersParticipants, this.detail);
            }
            if ((string.equals("all") || string.equals("resource")) && null != this.treeResources) {
                this.treeResources = adeBean.getTreeResources(filtersParticipants, this.detail);
            }
            if ((string.equals("all") || string.equals("category5")) && null != this.tree5) {
                this.tree5 = adeBean.getTreeCategory(filtersParticipants, "category5", this.detail);
            }
            if ((string.equals("all") || string.equals("category6")) && null != this.tree6) {
                this.tree6 = adeBean.getTreeCategory(filtersParticipants, "category6", this.detail);
            }
            if ((string.equals("all") || string.equals("category7")) && null != this.tree7) {
                this.tree7 = adeBean.getTreeCategory(filtersParticipants, "category7", this.detail);
            }
            if ((string.equals("all") || string.equals("category8")) && null != this.tree8) {
                this.tree8 = adeBean.getTreeCategory(filtersParticipants, "category8", this.detail);
            }
        }
    }

    public AdeList getSelectedBranches() {
        return this.selectBranchIds;
    }

    public String getStringBranchSelected() {
        return this.getStringSelected(this.selectBranchIds);
    }

    private void parseTree(Iterator iterator, AdeList adeList, boolean bl, Comparator comparator) throws Exception {
        while (iterator.hasNext()) {
            Iterator iterator2;
            ArrayList arrayList;
            Element element = (Element)iterator.next();
            String string = element.getName();
            if (string.equals("category")) {
                String string2 = element.getAttributeValue("participantType");
                arrayList = new ArrayList(element.getChildren());
                Collections.sort(arrayList, comparator);
                iterator2 = arrayList.iterator();
                if (string2.equals("trainee") && this.selectTrainees || string2.equals("instructor") && this.selectInstructors || string2.equals("room") && this.selectRooms || string2.equals("resource") && this.selectResources || string2.equals("category5") && this.selectCategory5 || string2.equals("category6") && this.selectCategory6 || string2.equals("category7") && this.selectCategory7 || string2.equals("category8") && this.selectCategory8) {
                    this.parseTree(iterator2, adeList, true, comparator);
                    continue;
                }
                this.parseTree(iterator2, adeList, false, comparator);
                continue;
            }
            if (string.equals("branch")) {
                int n = element.getAttribute("id").getIntValue();
                arrayList = new ArrayList(element.getChildren());
                Collections.sort(arrayList, comparator);
                iterator2 = arrayList.iterator();
                if (bl || this.selectBranchIds.contains(n)) {
                    this.parseTree(iterator2, adeList, true, comparator);
                    continue;
                }
                this.parseTree(iterator2, adeList, false, comparator);
                continue;
            }
            if (!string.equals("leaf")) continue;
            int n = element.getAttribute("id").getIntValue();
            if (!bl && !this.selectIds.contains(n)) continue;
            adeList.add(n);
        }
    }

    private Element getTreeElementById(int n, Iterator iterator, boolean bl, Comparator comparator) throws Exception {
        while (iterator.hasNext()) {
            int n2;
            Iterator iterator2;
            ArrayList arrayList;
            Element element = (Element)iterator.next();
            String string = element.getName();
            if (string.equals("category")) {
                String string2 = element.getAttributeValue("participantType");
                arrayList = new ArrayList(element.getChildren());
                Collections.sort(arrayList, comparator);
                iterator2 = arrayList.iterator();
                if (string2.equals("trainee") && this.selectTrainees || string2.equals("instructor") && this.selectInstructors || string2.equals("room") && this.selectRooms || string2.equals("resource") && this.selectResources || string2.equals("category5") && this.selectCategory5 || string2.equals("category6") && this.selectCategory6 || string2.equals("category7") && this.selectCategory7 || string2.equals("category8") && this.selectCategory8) {
                    return this.getTreeElementById(n, iterator2, true, comparator);
                }
                return this.getTreeElementById(n, iterator2, false, comparator);
            }
            if (string.equals("branch")) {
                n2 = element.getAttribute("id").getIntValue();
                arrayList = new ArrayList(element.getChildren());
                Collections.sort(arrayList, comparator);
                iterator2 = arrayList.iterator();
                if (bl || n == n2) {
                    return element;
                }
                Element element2 = this.getTreeElementById(n, iterator2, false, comparator);
                if (null == element2) continue;
                return element2;
            }
            if (!string.equals("leaf") || n != (n2 = element.getAttribute("id").getIntValue())) continue;
            return element;
        }
        return null;
    }

    private void parseTree(Element element) throws Exception {
        if (null != element) {
            Iterator iterator = element.getChildren().iterator();
            this.parseTree(iterator, this.allLeavesSelected, false, COMPARATOR);
        }
    }

    private Element getTreeElementById(Element element, int n) throws Exception {
        Element element2 = null;
        if (null != element) {
            Iterator iterator = element.getChildren().iterator();
            return this.getTreeElementById(n, iterator, false, COMPARATOR);
        }
        return element2;
    }

    public AdeList getAllLeavesSelected() throws Exception {
        if (!this.selectionHasCompute) {
            this.allLeavesSelected = new AdeList();
            this.parseTree(this.treeTrainees);
            this.parseTree(this.treeInstructors);
            this.parseTree(this.treeRooms);
            this.parseTree(this.treeResources);
            this.parseTree(this.tree5);
            this.parseTree(this.tree6);
            this.parseTree(this.tree7);
            this.parseTree(this.tree8);
            this.selectionHasCompute = true;
        }
        return this.allLeavesSelected;
    }

    public String getStringSelected(AdeList adeList) {
        String string = "";
        Iterator iterator = adeList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n != 0) {
                string = string + ",";
            }
            string = string + n2;
            ++n;
        }
        return string;
    }

    public String getAllLeavesStringSelected() throws Exception {
        return this.getStringSelected(this.getAllLeavesSelected());
    }

    public void closeAll() {
        this.openIds = new AdeList();
        this.openTrainees = false;
        this.openInstructors = false;
        this.openRooms = false;
        this.openResources = false;
        this.openCategory5 = false;
        this.openCategory6 = false;
        this.openCategory7 = false;
        this.openCategory8 = false;
    }

    public void unSelectAll() {
        this.selectIds = new AdeList();
        this.selectBranchIds = new AdeList();
        this.allLeavesSelected = new AdeList();
        this.selectTrainees = false;
        this.selectInstructors = false;
        this.selectRooms = false;
        this.selectResources = false;
        this.selectCategory5 = false;
        this.selectCategory6 = false;
        this.selectCategory7 = false;
        this.selectCategory8 = false;
        this.selectionHasCompute = false;
    }

    public void selectAllLeaves() {
        this.selectAllLeaves = true;
    }

    public boolean isSelectTrainee() {
        return this.selectTrainees;
    }

    public boolean isSelectInstructor() {
        return this.selectInstructors;
    }

    public boolean isSelectRoom() {
        return this.selectRooms;
    }

    public boolean isSelectResource() {
        return this.selectResources;
    }

    public boolean isSelectCategory5() {
        return this.selectCategory5;
    }

    public boolean isSelectCategory6() {
        return this.selectCategory6;
    }

    public boolean isSelectCategory7() {
        return this.selectCategory7;
    }

    public boolean isSelectCategory8() {
        return this.selectCategory8;
    }

    private boolean isGroup(int n) throws Exception {
        boolean bl = false;
        Element element = this.getTreeElementById(this.treeTrainees, n);
        if (null == element) {
            element = this.getTreeElementById(this.treeInstructors, n);
        }
        if (null == element) {
            element = this.getTreeElementById(this.treeRooms, n);
        }
        if (null == element) {
            element = this.getTreeElementById(this.treeResources, n);
        }
        if (null == element) {
            element = this.getTreeElementById(this.tree5, n);
        }
        if (null == element) {
            element = this.getTreeElementById(this.tree6, n);
        }
        if (null == element) {
            element = this.getTreeElementById(this.tree7, n);
        }
        if (null == element) {
            element = this.getTreeElementById(this.tree8, n);
        }
        if (null != element && element.getName().equals("branch")) {
            bl = true;
        }
        return bl;
    }

    public void selectAndOpenTree(AdeList adeList, int n) throws Exception {
        Element element3;
        if (-1 == n) {
            n = this.defaultMaxSelectionSize;
        }
        FiltersResources filtersResources = new FiltersResources();
        filtersResources.addFilterIds(adeList);
        Element element2 = this.ade.getTree(filtersResources, 1);
        for (Element element3 : element2.getChildren()) {
            if (!element3.hasChildren()) continue;
            this.openCategory(element3.getAttributeValue("participantType"));
            this.parseBranches(element3);
        }
        element3 = adeList.iterator();
        while (element3.hasNext()) {
            int n2 = (Integer)element3.next();
            if (this.isGroup(n2)) {
                this.selectBranch(n2, false, false, n);
                continue;
            }
            this.select(n2, false, false, n);
        }
    }

    private void parseBranches(Element element) {
        for (Element element2 : element.getChildren()) {
            if (!element2.getName().equals("branch") || !element2.hasChildren()) continue;
            this.openOrCloseId(element2.getAttribute("id").getIntValue());
            this.parseBranches(element2);
        }
    }
}

