/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans.data;

import com.adesoft.beans.AdeApi;
import com.adesoft.beans.AdeApi6;
import com.adesoft.beans.AdeList;
import com.adesoft.beans.SaveOptions;
import com.adesoft.beans.SimpleTreeElement;
import com.adesoft.beans.filters.FiltersResources;
import com.adesoft.errors.ProjectNotFoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jdom.DataConversionException;
import org.jdom.Element;

public final class TreeData2 {
    private AdeApi ade;
    private String type = "all";
    private Element treeTrainees;
    private Element treeInstructors;
    private Element treeRooms;
    private Element treeResources;
    private Element tree5;
    private Element tree6;
    private Element tree7;
    private Element tree8;
    private FiltersResources filters;
    private int detail;
    private AdeList selectIds = new AdeList();
    private AdeList selectBranchIds = new AdeList();
    private AdeList allLeavesSelected = new AdeList();
    private boolean selectTrainees = false;
    private boolean selectInstructors = false;
    private boolean selectRooms = false;
    private boolean selectResources = false;
    private boolean selectCategory5 = false;
    private boolean selectCategory6 = false;
    private boolean selectCategory7 = false;
    private boolean selectCategory8 = false;
    private boolean selectionHasCompute = false;
    private AdeList openIds = new AdeList();
    private boolean openTrainees = false;
    private boolean openInstructors = false;
    private boolean openRooms = false;
    private boolean openResources = false;
    private boolean openCategory5 = false;
    private boolean openCategory6 = false;
    private boolean openCategory7 = false;
    private boolean openCategory8 = false;
    private HashSet columns = new HashSet();
    private boolean expandAll;
    private HashMap<Integer, Boolean> visibleCategories = new HashMap();
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            try {
                String string = ((Element)object).getString("name");
                String string2 = ((Element)object2).getString("name");
                return string.compareTo(string2);
            }
            catch (Throwable throwable) {
                return 0;
            }
        }
    };

    public Element getTreeTrainees() throws RemoteException, ProjectNotFoundException {
        if (null == this.treeTrainees) {
            this.treeTrainees = this.ade.getTreeCategory(this.filters, "trainee", this.detail);
        }
        return this.treeTrainees;
    }

    public Element getTreeInstructors() throws RemoteException, ProjectNotFoundException {
        if (null == this.treeInstructors) {
            this.treeInstructors = this.ade.getTreeCategory(this.filters, "instructor", this.detail);
        }
        return this.treeInstructors;
    }

    public Element getTreeRooms() throws RemoteException, ProjectNotFoundException {
        if (null == this.treeRooms) {
            this.treeRooms = this.ade.getTreeCategory(this.filters, "room", this.detail);
        }
        return this.treeRooms;
    }

    public Element getTreeResources() throws RemoteException, ProjectNotFoundException {
        if (null == this.treeResources) {
            this.treeResources = this.ade.getTreeCategory(this.filters, "resource", this.detail);
        }
        return this.treeResources;
    }

    public Element getTreeCategory5() throws RemoteException, ProjectNotFoundException {
        if (null == this.tree5) {
            this.tree5 = this.ade.getTreeCategory(this.filters, "category5", this.detail);
        }
        return this.tree5;
    }

    public Element getTreeCategory6() throws RemoteException, ProjectNotFoundException {
        if (null == this.tree6) {
            this.tree6 = this.ade.getTreeCategory(this.filters, "category6", this.detail);
        }
        return this.tree6;
    }

    public Element getTreeCategory7() throws RemoteException, ProjectNotFoundException {
        if (null == this.tree7) {
            this.tree7 = this.ade.getTreeCategory(this.filters, "category7", this.detail);
        }
        return this.tree7;
    }

    public Element getTreeCategory8() throws RemoteException, ProjectNotFoundException {
        if (null == this.tree8) {
            this.tree8 = this.ade.getTreeCategory(this.filters, "category8", this.detail);
        }
        return this.tree8;
    }

    public void openOrCloseId(int n) {
        if (this.openIds.contains(n)) {
            this.openIds.removeInt(n);
        } else {
            this.openIds.add(n);
        }
    }

    public void openId(int n) {
        if (!this.openIds.contains(n)) {
            this.openIds.add(n);
        }
    }

    public void expandAll() {
        this.expandAll = true;
        this.openTrainees = true;
        this.openInstructors = true;
        this.openRooms = true;
        this.openResources = true;
        this.openCategory5 = true;
        this.openCategory6 = true;
        this.openCategory7 = true;
        this.openCategory8 = true;
    }

    public void openCategory(String string) throws Exception {
        if (string.equals("trainee")) {
            this.openTrainees = true;
        } else if (string.equals("instructor")) {
            this.openInstructors = true;
        } else if (string.equals("room") || string.equals("classroom")) {
            this.openRooms = true;
        } else if (string.equals("resource")) {
            this.openResources = true;
        } else if (string.equals("category5")) {
            this.openCategory5 = true;
        } else if (string.equals("category6")) {
            this.openCategory6 = true;
        } else if (string.equals("category7")) {
            this.openCategory7 = true;
        } else if (string.equals("category8")) {
            this.openCategory8 = true;
        }
    }

    public void openOrCloseCategory(String string) throws Exception {
        if (string.equals("trainee")) {
            this.openTrainees = !this.openTrainees;
        } else if (string.equals("instructor")) {
            this.openInstructors = !this.openInstructors;
        } else if (string.equals("room")) {
            this.openRooms = !this.openRooms;
        } else if (string.equals("resource")) {
            this.openResources = !this.openResources;
        } else if (string.equals("category5")) {
            this.openCategory5 = !this.openCategory5;
        } else if (string.equals("category6")) {
            this.openCategory6 = !this.openCategory6;
        } else if (string.equals("category7")) {
            this.openCategory7 = !this.openCategory7;
        } else if (string.equals("category8")) {
            this.openCategory8 = !this.openCategory8;
        }
    }

    public void select(int n, boolean bl, boolean bl2) {
        this.selectionHasCompute = false;
        if (bl) {
            this.unSelectAll();
        }
        if (!this.selectIds.contains(n)) {
            this.selectIds.add(n);
        } else if (this.selectIds.size() > 1 || !bl2) {
            this.selectIds.removeInt(n);
        }
    }

    public void selectBranch(int n, boolean bl, boolean bl2) {
        this.selectionHasCompute = false;
        if (bl) {
            this.unSelectAll();
        }
        if (!this.selectBranchIds.contains(n)) {
            this.selectBranchIds.add(n);
        } else if (this.selectBranchIds.size() > 1 || !bl2) {
            this.selectBranchIds.removeInt(n);
        }
    }

    public void selectCategory(String string, boolean bl) {
        this.selectionHasCompute = false;
        if (bl) {
            this.unSelectAll();
        }
        if (string.equals("trainee")) {
            this.selectTrainees = !this.selectTrainees;
        } else if (string.equals("instructor")) {
            this.selectInstructors = !this.selectInstructors;
        } else if (string.equals("room")) {
            this.selectRooms = !this.selectRooms;
        } else if (string.equals("resource")) {
            this.selectResources = !this.selectResources;
        } else if (string.equals("category5")) {
            this.selectCategory5 = !this.selectCategory5;
        } else if (string.equals("category6")) {
            this.selectCategory6 = !this.selectCategory6;
        } else if (string.equals("category7")) {
            this.selectCategory7 = !this.selectCategory7;
        } else if (string.equals("category8")) {
            this.selectCategory8 = !this.selectCategory8;
        }
    }

    public AdeList getSelected() {
        return this.selectIds;
    }

    public String getStringSelected() {
        String string = "";
        Iterator iterator = this.selectIds.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n != 0) {
                string = string + ",";
            }
            string = string + n2;
            ++n;
        }
        return string;
    }

    public void addColumn(String string) {
        this.columns.add(string);
    }

    public void removeColumn(String string) {
        this.columns.remove(string);
    }

    public void resetColumns() {
        this.columns = new HashSet();
    }

    public HashSet getColumns() {
        return this.columns;
    }

    public ArrayList parseTree(SaveOptions saveOptions) throws Exception {
        ArrayList<SimpleTreeElement> arrayList = new ArrayList<SimpleTreeElement>();
        if ((this.type.equals("all") || this.type.equals("trainee")) && this.visibleCategories.get(1).booleanValue() && saveOptions.showTreeCategory1) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("trainee"), 0, 2, false, this.openTrainees));
            if (null != this.getTreeTrainees() && this.openTrainees) {
                this.parseCategory(this.getTreeTrainees(), arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("instructor")) && this.visibleCategories.get(2).booleanValue() && saveOptions.showTreeCategory2) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("instructor"), 0, 2, false, this.openInstructors));
            if (null != this.getTreeInstructors() && this.openInstructors) {
                this.parseCategory(this.getTreeInstructors(), arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("room")) && this.visibleCategories.get(3).booleanValue() && saveOptions.showTreeCategory3) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("room"), 0, 2, false, this.openRooms));
            if (null != this.getTreeRooms() && this.openRooms) {
                this.parseCategory(this.getTreeRooms(), arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("resource")) && this.visibleCategories.get(4).booleanValue() && saveOptions.showTreeCategory4) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("resource"), 0, 2, false, this.openResources));
            if (null != this.getTreeResources() && this.openResources) {
                this.parseCategory(this.getTreeResources(), arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("category5")) && this.visibleCategories.get(5).booleanValue() && saveOptions.showTreeCategory5) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("category5"), 0, 2, false, this.openCategory5));
            if (null != this.getTreeCategory5() && this.openCategory5) {
                this.parseCategory(this.getTreeCategory5(), arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("category6")) && this.visibleCategories.get(6).booleanValue() && saveOptions.showTreeCategory6) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("category6"), 0, 2, false, this.openCategory6));
            if (null != this.getTreeCategory6() && this.openCategory6) {
                this.parseCategory(this.getTreeCategory6(), arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("category7")) && this.visibleCategories.get(7).booleanValue() && saveOptions.showTreeCategory7) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("category7"), 0, 2, false, this.openCategory7));
            if (null != this.getTreeCategory7() && this.openCategory7) {
                this.parseCategory(this.getTreeCategory7(), arrayList);
            }
        }
        if ((this.type.equals("all") || this.type.equals("category8")) && this.visibleCategories.get(8).booleanValue() && saveOptions.showTreeCategory8) {
            arrayList.add(new SimpleTreeElement(this.createElementCategory("category8"), 0, 2, false, this.openCategory8));
            if (null != this.getTreeCategory8() && this.openCategory8) {
                this.parseCategory(this.getTreeCategory8(), arrayList);
            }
        }
        return arrayList;
    }

    private Element createElementCategory(String string) {
        Element element = new Element("category");
        element.addAttribute("participantType", string);
        return element;
    }

    private void parseCategory(Element element, ArrayList arrayList) throws Exception {
        Element[] elementArray = element.getChild("category").getChildrenArray();
        Arrays.sort(elementArray, COMPARATOR);
        this.parseParticipants(arrayList, elementArray, 1);
    }

    private void parseParticipants(ArrayList arrayList, Element[] elementArray, int n) throws DataConversionException {
        AdeList adeList = new AdeList();
        for (int i = 0; i < elementArray.length; ++i) {
            int n2;
            Element element = elementArray[i];
            String string = element.getName();
            if (string.equals("leaf")) {
                n2 = element.getAttribute("id").getIntValue();
                adeList.add(n2);
                arrayList.add(new SimpleTreeElement(element, n, 0, this.selectIds.contains(n2), false));
                continue;
            }
            if (!string.equals("branch")) continue;
            n2 = element.getAttribute("id").getIntValue();
            boolean bl = this.expandAll || this.openIds.contains(n2);
            arrayList.add(new SimpleTreeElement(element, n, 1, this.selectIds.contains(n2), bl));
            if (!bl) continue;
            Element[] elementArray2 = element.getChildrenArray();
            Arrays.sort(elementArray2, COMPARATOR);
            this.parseParticipants(arrayList, elementArray2, n + 1);
        }
    }

    public void loadTree(AdeApi adeApi, boolean bl, FiltersResources filtersResources, int n) throws Exception {
        this.loadTree(adeApi, bl, filtersResources, n, "all");
    }

    public void loadTree(AdeApi adeApi, boolean bl, FiltersResources filtersResources, int n, String string) throws Exception {
        if (bl) {
            this.ade = adeApi;
            this.filters = filtersResources;
            this.detail = n;
            this.type = string;
            AdeApi6 adeApi6 = new AdeApi6();
            adeApi6.setSessionId(adeApi.getSessionId());
            Element element = adeApi6.getCategoriesRights();
            for (Element element2 : element.getChildrenArray()) {
                this.visibleCategories.put(element2.getInt("id"), element2.getBoolean("canRead"));
            }
            if (element.getChildren().size() < 8) {
                for (int i = element.getChildren().size() + 1; i <= 8; ++i) {
                    this.visibleCategories.put(i, false);
                }
            }
            if ((string.equals("all") || string.equals("trainee")) && null != this.treeTrainees) {
                this.treeTrainees = adeApi.getTreeCategory(filtersResources, "trainee", this.detail);
            }
            if ((string.equals("all") || string.equals("instructor")) && null != this.treeInstructors) {
                this.treeInstructors = adeApi.getTreeCategory(filtersResources, "instructor", this.detail);
            }
            if ((string.equals("all") || string.equals("room")) && null != this.treeRooms) {
                this.treeRooms = adeApi.getTreeCategory(filtersResources, "room", this.detail);
            }
            if ((string.equals("all") || string.equals("resource")) && null != this.treeResources) {
                this.treeResources = adeApi.getTreeCategory(filtersResources, "resource", this.detail);
            }
            if ((string.equals("all") || string.equals("category5")) && null != this.tree5) {
                this.tree5 = adeApi.getTreeCategory(filtersResources, "category5", this.detail);
            }
            if ((string.equals("all") || string.equals("category6")) && null != this.tree6) {
                this.tree6 = adeApi.getTreeCategory(filtersResources, "category6", this.detail);
            }
            if ((string.equals("all") || string.equals("category7")) && null != this.tree7) {
                this.tree7 = adeApi.getTreeCategory(filtersResources, "category7", this.detail);
            }
            if ((string.equals("all") || string.equals("category8")) && null != this.tree8) {
                this.tree8 = adeApi.getTreeCategory(filtersResources, "category8", this.detail);
            }
        }
    }

    public AdeList getSelectedBranches() {
        return this.selectBranchIds;
    }

    public String getStringBranchSelected() {
        return this.getStringSelected(this.selectBranchIds);
    }

    private void parseTree(Iterator iterator, AdeList adeList, boolean bl, Comparator comparator) throws Exception {
        while (iterator.hasNext()) {
            Iterator iterator2;
            ArrayList arrayList;
            Element element = (Element)iterator.next();
            String string = element.getName();
            if (string.equals("category")) {
                String string2 = element.getAttributeValue("category");
                arrayList = new ArrayList(element.getChildren());
                Collections.sort(arrayList, comparator);
                iterator2 = arrayList.iterator();
                if (string2.equals("trainee") && this.selectTrainees || string2.equals("instructor") && this.selectInstructors || string2.equals("room") && this.selectRooms || string2.equals("resource") && this.selectResources || string2.equals("category5") && this.selectCategory5 || string2.equals("category6") && this.selectCategory6 || string2.equals("category7") && this.selectCategory7 || string2.equals("category8") && this.selectCategory8) {
                    this.parseTree(iterator2, adeList, true, comparator);
                    continue;
                }
                this.parseTree(iterator2, adeList, false, comparator);
                continue;
            }
            if (string.equals("branch")) {
                int n = element.getAttribute("id").getIntValue();
                arrayList = new ArrayList(element.getChildren());
                Collections.sort(arrayList, comparator);
                iterator2 = arrayList.iterator();
                if (bl || this.selectBranchIds.contains(n)) {
                    this.parseTree(iterator2, adeList, true, comparator);
                    continue;
                }
                this.parseTree(iterator2, adeList, false, comparator);
                continue;
            }
            if (!string.equals("leaf")) continue;
            int n = element.getAttribute("id").getIntValue();
            if (!bl && !this.selectIds.contains(n)) continue;
            adeList.add(n);
        }
    }

    private void parseTree(Element element) throws Exception {
        if (null != element) {
            Iterator iterator = element.getChildren().iterator();
            this.parseTree(iterator, this.allLeavesSelected, false, COMPARATOR);
        }
    }

    public AdeList getAllLeavesSelected() throws Exception {
        if (!this.selectionHasCompute) {
            this.allLeavesSelected = new AdeList();
            this.parseTree(this.getTreeTrainees());
            this.parseTree(this.getTreeInstructors());
            this.parseTree(this.getTreeRooms());
            this.parseTree(this.getTreeResources());
            this.parseTree(this.getTreeCategory5());
            this.parseTree(this.getTreeCategory6());
            this.parseTree(this.getTreeCategory7());
            this.parseTree(this.getTreeCategory8());
            this.selectionHasCompute = true;
        }
        return this.allLeavesSelected;
    }

    public String getStringSelected(AdeList adeList) {
        String string = "";
        Iterator iterator = adeList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n != 0) {
                string = string + ",";
            }
            string = string + n2;
            ++n;
        }
        return string;
    }

    public String getAllLeavesStringSelected() throws Exception {
        return this.getStringSelected(this.getAllLeavesSelected());
    }

    public void closeAll() {
        this.openIds = new AdeList();
        this.openTrainees = false;
        this.openInstructors = false;
        this.openRooms = false;
        this.openResources = false;
        this.openCategory5 = false;
        this.openCategory6 = false;
        this.openCategory7 = false;
        this.openCategory8 = false;
    }

    public void unSelectAll() {
        this.selectIds = new AdeList();
        this.selectBranchIds = new AdeList();
        this.allLeavesSelected = new AdeList();
        this.selectTrainees = false;
        this.selectInstructors = false;
        this.selectRooms = false;
        this.selectResources = false;
        this.selectCategory5 = false;
        this.selectCategory6 = false;
        this.selectCategory7 = false;
        this.selectCategory8 = false;
        this.selectionHasCompute = false;
    }

    public boolean isSelectTrainee() {
        return this.selectTrainees;
    }

    public boolean isSelectInstructor() {
        return this.selectInstructors;
    }

    public boolean isSelectRoom() {
        return this.selectRooms;
    }

    public boolean isSelectResource() {
        return this.selectResources;
    }

    public boolean isSelectCategory5() {
        return this.selectCategory5;
    }

    public boolean isSelectCategory6() {
        return this.selectCategory6;
    }

    public boolean isSelectCategory7() {
        return this.selectCategory7;
    }

    public boolean isSelectCategory8() {
        return this.selectCategory8;
    }

    public FiltersResources getFilters() {
        return this.filters;
    }
}

