/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans.data;

import com.adesoft.beans.AdeApi;
import com.adesoft.beans.AdeList;
import com.adesoft.beans.SimpleTreeElement;
import com.adesoft.beans.filters.FiltersActivities;
import com.adesoft.errors.ProjectNotFoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.jdom.DataConversionException;
import org.jdom.Element;

public final class TreeDataActivity {
    private AdeApi ade;
    private String type = "all";
    private Element treeActivities;
    private FiltersActivities filters;
    private int detail;
    private AdeList selectIds = new AdeList();
    private AdeList selectBranchIds = new AdeList();
    private AdeList allLeavesSelected = new AdeList();
    private boolean selectionHasCompute = false;
    private AdeList openIds = new AdeList();
    private HashSet columns = new HashSet();
    private boolean expandAll;
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            try {
                String string = ((Element)object).getString("name");
                String string2 = ((Element)object2).getString("name");
                return string.compareTo(string2);
            }
            catch (Throwable throwable) {
                return 0;
            }
        }
    };

    public Element getTreeActivities() throws RemoteException, ProjectNotFoundException {
        if (null == this.treeActivities) {
            this.treeActivities = this.ade.getTreeActivities(null, this.detail);
        }
        return this.treeActivities;
    }

    public void openOrCloseId(int n) {
        if (this.openIds.contains(n)) {
            this.openIds.removeInt(n);
        } else {
            this.openIds.add(n);
        }
    }

    public void expandAll() {
        this.expandAll = true;
    }

    public void resetExpandAll() {
        this.expandAll = false;
    }

    public void select(int n, boolean bl, boolean bl2) {
        this.selectionHasCompute = false;
        if (bl) {
            this.unSelectAll();
        }
        if (!this.selectIds.contains(n)) {
            this.selectIds.add(n);
        } else if (this.selectIds.size() > 1 || !bl2) {
            this.selectIds.removeInt(n);
        }
    }

    public void selectBranch(int n, boolean bl, boolean bl2) {
        this.selectionHasCompute = false;
        if (bl) {
            this.unSelectAll();
        }
        if (!this.selectBranchIds.contains(n)) {
            this.unSelectAll();
            this.selectBranchIds.add(n);
        } else if (this.selectBranchIds.size() > 1 || !bl2) {
            this.selectBranchIds.removeInt(n);
        }
    }

    public void selectCategory(String string, boolean bl) {
        this.selectionHasCompute = false;
        if (bl) {
            this.unSelectAll();
        }
    }

    public AdeList getSelected() {
        return this.selectIds;
    }

    public String getStringSelected() {
        String string = "";
        Iterator iterator = this.selectIds.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n != 0) {
                string = string + ",";
            }
            string = string + n2;
            ++n;
        }
        return string;
    }

    public void addColumn(String string) {
        this.columns.add(string);
    }

    public void removeColumn(String string) {
        this.columns.remove(string);
    }

    public void resetColumns() {
        this.columns = new HashSet();
    }

    public HashSet getColumns() {
        return this.columns;
    }

    private void parseActivities(ArrayList arrayList, Element[] elementArray, int n) throws DataConversionException {
        AdeList adeList = new AdeList();
        for (int i = 0; i < elementArray.length; ++i) {
            Element[] elementArray2;
            boolean bl;
            int n2;
            Element element = elementArray[i];
            String string = element.getName();
            boolean bl2 = false;
            if (bl2) {
                if (string.equals("activity")) {
                    n2 = element.getAttribute("id").getIntValue();
                    adeList.add(n2);
                    arrayList.add(new SimpleTreeElement(element, n, 0, this.selectIds.contains(n2), false));
                    continue;
                }
                if (!string.equals("folder")) continue;
                n2 = element.getAttribute("id").getIntValue();
                bl = this.expandAll || this.openIds.contains(n2);
                arrayList.add(new SimpleTreeElement(element, n, 1, this.selectIds.contains(n2), bl));
                if (!bl) continue;
                elementArray2 = element.getChildrenArray();
                Arrays.sort(elementArray2, COMPARATOR);
                this.parseActivities(arrayList, elementArray2, n + 1);
                continue;
            }
            if (!string.equals("folder")) continue;
            n2 = element.getAttribute("id").getIntValue();
            bl = this.expandAll || this.openIds.contains(n2);
            arrayList.add(new SimpleTreeElement(element, n, 1, this.selectIds.contains(n2), bl));
            if (!bl) continue;
            elementArray2 = element.getChildrenArray();
            Arrays.sort(elementArray2, COMPARATOR);
            this.parseActivities(arrayList, elementArray2, n + 1);
        }
    }

    public void loadTree(AdeApi adeApi, boolean bl, FiltersActivities filtersActivities, int n) throws Exception {
        this.loadTree(adeApi, bl, filtersActivities, n, "all");
    }

    public void loadTree(AdeApi adeApi, boolean bl, FiltersActivities filtersActivities, int n, String string) throws Exception {
        if (bl) {
            this.ade = adeApi;
            this.filters = filtersActivities;
            this.detail = n;
            this.type = string;
            this.treeActivities = adeApi.getTreeActivities(filtersActivities, this.detail);
        }
    }

    public String getPath(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String string2 = element.getString("name");
            if (!element.hasChildren()) continue;
            string = "/" + string2;
            Iterator iterator2 = element.getChildren().iterator();
            Element element2 = element.getChild("folder");
            if (null != element2 && element2.hasChildren()) {
                string = string + this.getPath(iterator2, string);
                continue;
            }
            return string;
        }
        return string;
    }

    public AdeList getSelectedBranches() {
        return this.selectBranchIds;
    }

    public String getStringBranchSelected() {
        return this.getStringSelected(this.selectBranchIds);
    }

    public ArrayList parseTree() throws Exception {
        ArrayList arrayList = new ArrayList();
        if (null != this.getTreeActivities()) {
            Element[] elementArray = this.getTreeActivities().getChildrenArray();
            Arrays.sort(elementArray, COMPARATOR);
            this.parseActivities(arrayList, elementArray, 1);
        }
        return arrayList;
    }

    private void parseTreeActivity(Iterator iterator, AdeList adeList, boolean bl, Comparator comparator) throws Exception {
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String string = element.getName();
            if (!string.equals("folder")) continue;
            String string2 = element.getAttributeValue("folder");
            ArrayList arrayList = new ArrayList(element.getChildren());
            Collections.sort(arrayList, comparator);
            Iterator iterator2 = arrayList.iterator();
            this.parseTreeActivity(iterator2, adeList, true, comparator);
        }
    }

    private void parseTreeActivity(Element element) throws Exception {
        if (null != element) {
            Iterator iterator = element.getChildren().iterator();
            this.parseTreeActivity(iterator, this.allLeavesSelected, false, COMPARATOR);
        }
    }

    public AdeList getAllLeavesSelected() throws Exception {
        if (!this.selectionHasCompute) {
            this.allLeavesSelected = new AdeList();
            this.parseTreeActivity(this.getTreeActivities());
            this.selectionHasCompute = true;
        }
        return this.allLeavesSelected;
    }

    public String getStringSelected(AdeList adeList) {
        String string = "";
        Iterator iterator = adeList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (n != 0) {
                string = string + ",";
            }
            string = string + n2;
            ++n;
        }
        return string;
    }

    public String getAllLeavesStringSelected() throws Exception {
        return this.getStringSelected(this.getAllLeavesSelected());
    }

    public void closeAll() {
        this.openIds = new AdeList();
    }

    public void unSelectAll() {
        this.selectIds = new AdeList();
        this.selectBranchIds = new AdeList();
        this.allLeavesSelected = new AdeList();
        this.selectionHasCompute = false;
    }

    public FiltersActivities getFilters() {
        return this.filters;
    }
}

