/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans.filters;

import com.adesoft.beans.data.XField;
import com.adesoft.beans.filters.XFieldResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;

public class XFieldResultSet {
    private HashMap<Class<?>, XFieldResult> resultMap = new HashMap();

    public void setXFields(XField ... xFieldArray) {
        for (XField xField : xFieldArray) {
            if (xField == null) continue;
            Class<?> clazz = xField.getClass();
            this.resultMap.put(clazz, new XFieldResult(xField));
        }
    }

    public <X extends XField> X getResultByClass(Class<X> clazz) {
        XFieldResult xFieldResult = this.resultMap.get(clazz);
        if (xFieldResult != null && !xFieldResult.isEmptyResult()) {
            return (X)xFieldResult.getXField();
        }
        return null;
    }

    public List<XField> getResultAsList() {
        ArrayList<XField> arrayList = new ArrayList<XField>();
        for (XFieldResult xFieldResult : this.resultMap.values()) {
            if (xFieldResult.isEmptyResult()) continue;
            arrayList.add(xFieldResult.getXField());
        }
        return arrayList;
    }

    public void parseResult(Element element) {
        if ((element = element.getChild("xfields")) == null) {
            return;
        }
        for (Element element2 : element.getChildrenArray("xfield")) {
            try {
                String string = element2.getString("fieldJName", "");
                Class<?> clazz = Class.forName(string);
                if (!XField.class.isAssignableFrom(clazz)) continue;
                XFieldResult xFieldResult = this.resultMap.get(clazz);
                if (xFieldResult == null) {
                    xFieldResult = new XFieldResult((XField)clazz.newInstance());
                    this.resultMap.put(clazz, xFieldResult);
                }
                xFieldResult.convertResult(element2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

