/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans.settings;

import com.adesoft.beans.settings.BookingCateringSettings;
import com.adesoft.beans.settings.BookingParticipantSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class BookingSettings
implements Serializable {
    private static final long serialVersionUID = 600L;
    private String title = "";
    private String sort = "";
    private String service = "";
    private String code = "";
    private String address = "";
    private String city = "";
    private String requester = "";
    private String owner = "";
    private String zipCode = "";
    private String comment = "";
    private int availabilityId = -1;
    private int periodicityGap = 1;
    private PeriodicityGapUnit periodicityGapUnit;
    private Date firstDate;
    private int nbOccurrence = -1;
    private Date limitDate = null;
    private int duration = 1;
    private HashMap<Integer, List<Integer>> rooms = new HashMap();
    private HashMap<Integer, HashMap<Integer, Integer>> equipments = new HashMap();
    private List<BookingParticipantSettings> participants = new ArrayList<BookingParticipantSettings>();
    private List<BookingCateringSettings> caterings = new ArrayList<BookingCateringSettings>();
    private boolean clearTitle = false;
    private boolean clearSort = false;
    private boolean clearService = false;
    private boolean clearCode = false;
    private boolean clearAddress = false;
    private boolean clearCity = false;
    private boolean clearRequester = false;
    private boolean clearOwner = false;
    private boolean clearZipCode = false;
    private boolean clearComment = false;
    private boolean placementChanged = false;
    private boolean resourcesChanged = false;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        if (string.equals("")) {
            this.clearTitle = true;
        }
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String string) {
        this.sort = string;
        if (string.equals("")) {
            this.clearSort = true;
        }
    }

    public String getService() {
        return this.service;
    }

    public void setService(String string) {
        this.service = string;
        if (string.equals("")) {
            this.clearService = true;
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        this.code = string;
        if (string.equals("")) {
            this.clearCode = true;
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
        if (string.equals("")) {
            this.clearAddress = true;
        }
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String string) {
        this.city = string;
        if (string.equals("")) {
            this.clearCity = true;
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
        if (string.equals("")) {
            this.clearOwner = true;
        }
    }

    public String getRequester() {
        return this.requester;
    }

    public void setRequester(String string) {
        this.requester = string;
        if (string.equals("")) {
            this.clearRequester = true;
        }
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String string) {
        this.zipCode = string;
        if (string.equals("")) {
            this.clearZipCode = true;
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
        if (string.equals("")) {
            this.clearComment = true;
        }
    }

    public void setDate(Date date) {
        this.firstDate = date;
        this.periodicityGap = -1;
        this.periodicityGapUnit = PeriodicityGapUnit.DAY;
        this.nbOccurrence = 1;
        this.limitDate = null;
        this.placementChanged = true;
    }

    public void setDatesToEndProject(Date date, int n, PeriodicityGapUnit periodicityGapUnit) {
        this.firstDate = date;
        this.periodicityGap = n;
        this.periodicityGapUnit = periodicityGapUnit;
        this.nbOccurrence = -1;
        this.limitDate = null;
        this.placementChanged = true;
    }

    public void setDatesToLimitDate(Date date, int n, PeriodicityGapUnit periodicityGapUnit, Date date2) {
        this.firstDate = date;
        this.periodicityGap = n;
        this.periodicityGapUnit = periodicityGapUnit;
        this.nbOccurrence = -1;
        this.limitDate = date2;
        this.placementChanged = true;
    }

    public void setDatesToNOccurence(Date date, int n, PeriodicityGapUnit periodicityGapUnit, int n2) {
        this.firstDate = date;
        this.periodicityGap = n;
        this.periodicityGapUnit = periodicityGapUnit;
        this.nbOccurrence = n2;
        this.limitDate = null;
        this.placementChanged = true;
    }

    public void setDuration(int n) {
        this.duration = n;
        this.placementChanged = true;
    }

    public boolean hasPlacementChanged() {
        return this.placementChanged;
    }

    public int getPeriodicityGap() {
        return this.periodicityGap;
    }

    public PeriodicityGapUnit getPeriodicityGapUnit() {
        return this.periodicityGapUnit;
    }

    public Date getFirstDate() {
        return this.firstDate;
    }

    public int getNbOccurrence() {
        return this.nbOccurrence;
    }

    public Date getLimitDate() {
        return this.limitDate;
    }

    public int getDuration() {
        return this.duration;
    }

    public void addRoom(int n, int n2) {
        List<Integer> list = this.rooms.get(n);
        if (null == list) {
            list = new ArrayList<Integer>();
            this.rooms.put(n, list);
        }
        list.add(n2);
        this.resourcesChanged = true;
    }

    public void addRoom(int n) {
        this.addRoom(-1, n);
        this.resourcesChanged = true;
    }

    public List<Integer> getRooms(int n) {
        return this.rooms.get(n);
    }

    public void addEquipment(int n, int n2, int n3) {
        HashMap<Integer, Integer> hashMap = this.equipments.get(n);
        if (null == hashMap) {
            hashMap = new HashMap();
            this.equipments.put(n, hashMap);
        }
        hashMap.put(n2, n3);
        this.resourcesChanged = true;
    }

    public void addEquipment(int n, int n2) {
        this.addEquipment(-1, n, n2);
        this.resourcesChanged = true;
    }

    public HashMap<Integer, Integer> getEquipments(int n) {
        return this.equipments.get(n);
    }

    public void addParticipant(int n, boolean bl) {
        this.participants.add(new BookingParticipantSettings(n, bl));
        this.resourcesChanged = true;
    }

    public List<BookingParticipantSettings> getParticipants() {
        return this.participants;
    }

    public void addCatering(int n, int n2, int n3, boolean bl) {
        this.caterings.add(new BookingCateringSettings(n, n2, n3, bl));
        this.resourcesChanged = true;
    }

    public boolean hasResourcesChanged() {
        return this.resourcesChanged;
    }

    public List<BookingCateringSettings> getCaterings() {
        return this.caterings;
    }

    public int getAvailabilityId() {
        return this.availabilityId;
    }

    public void setAvailabilityId(int n) {
        this.availabilityId = n;
    }

    public boolean isClearTitle() {
        return this.clearTitle;
    }

    public boolean isClearAddress() {
        return this.clearAddress;
    }

    public boolean isClearSort() {
        return this.clearSort;
    }

    public boolean isClearService() {
        return this.clearService;
    }

    public boolean isClearCode() {
        return this.clearCode;
    }

    public boolean isClearCity() {
        return this.clearCity;
    }

    public boolean isClearRequester() {
        return this.clearRequester;
    }

    public boolean isClearOwner() {
        return this.clearOwner;
    }

    public boolean isClearZipCode() {
        return this.clearZipCode;
    }

    public boolean isClearComment() {
        return this.clearComment;
    }

    public static enum PeriodicityGapUnit {
        WEEK,
        DAY;

    }
}

