/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans.settings;

import com.adesoft.struct.WizardTFData;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public final class CalendarSettings
implements Serializable {
    private static final long serialVersionUID = 520L;
    private String[] weeks;
    private String[] days;
    private String[] slots = WizardTFData.getDefaultSlotNames(this.granularity);
    private Date[] dates;
    private int[] offsets;
    private Date[] times;
    private int granularity = 30;
    private int beginHour;
    private int endHour;
    private int beginDay;
    private int endDay;
    private int beginWeek;
    private int endWeek;

    public CalendarSettings() {
        this.days = WizardTFData.getDefaultDayNames();
        this.weeks = WizardTFData.getDefaultWeekNames();
        this.offsets = WizardTFData.getDefaultDayOffsets();
        this.times = WizardTFData.getDefaultSlotTimes(this.granularity);
        this.dates = new Date[WizardTFData.getNbWeeks()];
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(new Date());
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(7, calendar.getFirstDayOfWeek());
        calendar.set(3, 1);
        for (int i = 0; i < this.dates.length; ++i) {
            this.dates[i] = calendar.getTime();
            calendar.add(3, 1);
        }
    }

    public String[] getDayNames() {
        return this.days;
    }

    public int[] getDayOffset() {
        return this.offsets;
    }

    public int getFirstDay() {
        return this.beginDay;
    }

    public int getFirstSlot() {
        return this.beginHour;
    }

    public int getFirstWeek() {
        return this.beginWeek;
    }

    public int getGranularity() {
        return this.granularity;
    }

    public int getLastDay() {
        return this.endDay;
    }

    public int getLastSlot() {
        return this.endHour;
    }

    public int getLastWeek() {
        return this.endWeek;
    }

    public String[] getSlotNames() {
        return this.slots;
    }

    public Date[] getSlotTimes() {
        return this.times;
    }

    public Date[] getWeekDates() {
        return this.dates;
    }

    public String[] getWeekNames() {
        return this.weeks;
    }

    public void setDates(Date date, int n) {
        this.setDates(date, n, -1);
    }

    public void setDates(Date date, int n, int n2) {
        this.setDates(date, n, "dd MMMM yyyy", n2);
    }

    public void setDates(Date date, int n, String string) {
        this.setDates(date, n, string, -1);
    }

    public void setDates(Date date, int n, String string, int n2) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        if (-1 == n2) {
            int n3 = calendar.getFirstDayOfWeek();
            calendar.set(7, n3);
        } else {
            calendar.set(7, n2);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        Date[] dateArray = new Date[WizardTFData.getNbWeeks()];
        String[] stringArray = new String[WizardTFData.getNbWeeks()];
        for (int i = 0; i < dateArray.length; ++i) {
            dateArray[i] = calendar.getTime();
            calendar.add(3, 1);
            stringArray[i] = i < n ? simpleDateFormat.format(dateArray[i]) : "week" + (i + 1);
        }
        this.dates = dateArray;
        this.weeks = stringArray;
        this.beginWeek = 0;
        this.endWeek = n - 1;
    }

    public void setDayHours(int n, int n2) {
        this.beginHour = n * 60 / this.granularity;
        this.endHour = n2 * 60 / this.granularity;
    }

    public void setFirstAndLastSlot(int n, int n2) {
        this.beginHour = n;
        this.endHour = n2;
    }

    public void setDays(List list, int n) {
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string;
            this.days[n2] = string = (String)iterator.next();
            ++n2;
        }
        this.beginDay = 0;
        this.endDay = n - 1;
    }

    public void setDaysWeek(int n, int n2) {
        this.beginDay = n;
        this.endDay = n2;
    }

    public void setFirstDayWeek(int n) {
    }

    public void setGranularity(int n) {
        if (n > 60 || n / 5 * 5 != n) {
            return;
        }
        this.granularity = n;
        this.slots = WizardTFData.getDefaultSlotNames(n);
        this.times = WizardTFData.getDefaultSlotTimes(n);
    }

    public void setSlotNames(List list) {
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            this.slots[n] = string = (String)iterator.next();
            ++n;
        }
    }

    public void setSlotTimes(List list) {
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Date date;
            this.times[n] = date = (Date)iterator.next();
            ++n;
        }
    }

    public void setWeekNames(List list) {
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            this.weeks[n] = string = (String)iterator.next();
            ++n;
        }
    }
}

