/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.beans.settings;

import com.adesoft.collections.MyHashTable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public final class EngineSettings
implements Serializable {
    private static final long serialVersionUID = 520L;
    private String server;
    private String port;
    private int firstWeek = 0;
    private int lastWeek = 0;
    private int delay = 600;
    private String name;
    private int profileId = -2;
    private int ownerId = -2;
    public static final int GET_BEST_SOLUTION = 0;
    public static final int GET_LAST_SOLUTION = 1;
    public static final int NOT_GET_SOLUTION = 2;
    public static final int WAIT_FOR_GET_SOLUTION = 3;
    private int stop_mode = 0;
    public static final String PARAM_INITIAL_PLACEMENT = "placement";
    public static final String CLEAR_ALL = "clear_all";
    public static final String START_FROM_EXISTING = "start_from_existing";
    public static final String LOCK_DATES = "lock_dates";
    public static final String LOCK_PARTICIPANTS = "lock_participants";
    public static final String PARAM_ENGINE_MODE = "engine_modes";
    public static final String SCHEDULE = "calcul_et";
    public static final String OPTIMIZE = "optimize_costs";
    public static final String QUALITY = "optimize_quality";
    public static final String PARAM_PRIORITY_ACTIVITY = "priority_activity";
    public static final String PARAM_PRIORITY_RESOURCE = "priority_resource";
    public static final String PARAM_NB_WEEKS = "nb_weeks";
    public static final String PARAM_USE_COSTS = "use_costs";
    public static final String PARAM_PLANIFY_LUNCHES = "planify_lunches";
    public static final String PARAM_STATS_SIZE = "statistics_size";
    public static final String PARAM_LEVEL_DETAIL = "level_detail";
    public static final String LOW = "low";
    public static final String MEDIUM = "medium";
    public static final String HIGH = "high";
    public static final String PARAM_SCHEDULE_DEFAULT = "default_planification";
    public static final String PARAM_SCHEDULE_MODE = "planification";
    public static final String PARAM_SCHEDULE_PARTICIPANT_CHOICE = "participant_choice";
    public static final String PARAM_SCHEDULE_PARTICIPANT_SEARCH_EXHAUSTIVITY = "search_exhaustivity";
    public static final int AUTOMATIC = 0;
    public static final int STRICT = 1;
    public static final int FLEXIBLE = 2;
    public static final int PRIORITY = 3;
    public static final int STRICT_PRIORITY = 4;
    public static final int HIERARCHY = 5;
    public static final int ASAP = 6;
    public static final int STANDARD = 0;
    public static final String PARAM_OPTIMIZE_DEFAULT = "default_optimization";
    public static final String PARAM_OPTIMIZE_NUMBER_OF_STAGES = "number_of_stages";
    public static final String PARAM_OPTIMIZE_NUMBER_ITERATION_BY_STAGE = "number_of_iteration_by_stages";
    public static final String PARAM_OPTIMIZE_SEARCH_SPEED = "search_speed";
    public static final String PARAM_OPTIMIZE_IMPROVEMENT_STAGE_SPEED = "Improvement_stage_speed";
    public static final String PARAM_HEURISTIC_SCHEDULE_MOVE = "MoveActivities";
    public static final String PARAM_HEURISTIC_AFFECTATION_MOVE = "ChangeResources";
    public static final String PARAM_HEURISTIC_GREEDY_MOVE = "ImprovingMovement";
    public static final String PARAM_HEURISTIC_PERMUTATION_MOVE = "ResourceSwap";
    public static final String PARAM_HEURISTIC_CALENDAR_PREF_WEIGHT = "AvailbilityPreference";
    public static final String PARAM_QUALITY_DEFAULT = "default_quality";
    public static final String PARAM_QUALITY_MINIMUM_INOCUPATION = "minimum_duration_occupation";
    public static final String PARAM_QUALITY_MAXIMUM_INOCUPATION = "maximum_duration_occupation";
    public static final String PARAM_QUALITY_WEIGHT = "quality_weight";
    public static final String PARAM_QUALITY_SEARCH_SPEED = "quality_search_speed";
    private HashMap parameters;
    private MyHashTable costsWeight;
    private double movingWeight;
    private boolean partial = false;
    private List activities;
    private List participants;
    private List links;
    private int configurationId = -1;

    public EngineSettings(String string, String string2) {
        this.server = string;
        this.port = string2;
        this.parameters = new HashMap();
        this.costsWeight = new MyHashTable();
        this.movingWeight = 0.0;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public void setServerPort(String string) {
        this.port = string;
    }

    public void setPartial(boolean bl) {
        this.partial = bl;
    }

    public void setPartial(List list, List list2, List list3, int n, int n2) {
        this.partial = true;
        this.activities = list;
        this.participants = list2;
        this.links = list3;
        this.firstWeek = n;
        this.lastWeek = n2;
    }

    public String getServer() {
        return this.server;
    }

    public String getPort() {
        return this.port;
    }

    public void setStopMode(int n) {
        this.stop_mode = n;
    }

    public int getStopMode() {
        return this.stop_mode;
    }

    public void setParameter(String string, String string2) {
        this.parameters.put(string, string2);
    }

    public void setParameter(String string, int n) {
        this.parameters.put(string, "" + n);
    }

    public void setParameter(String string, double d) {
        this.parameters.put(string, "" + d);
    }

    public void setParameter(String string, boolean bl) {
        this.parameters.put(string, bl);
    }

    public void setEngineModes(String string, String string2) {
        this.setParameter(PARAM_ENGINE_MODE, string);
        this.setParameter(PARAM_INITIAL_PLACEMENT, string2);
    }

    public void setMain(boolean bl, boolean bl2, int n, boolean bl3, boolean bl4) {
        this.setParameter(PARAM_PRIORITY_ACTIVITY, bl);
        this.setParameter(PARAM_PRIORITY_RESOURCE, bl2);
        this.setParameter(PARAM_NB_WEEKS, n);
        this.setParameter(PARAM_USE_COSTS, bl3);
        this.setParameter(PARAM_PLANIFY_LUNCHES, bl4);
    }

    public void setEngineTracking(int n, String string) {
        this.setParameter(PARAM_STATS_SIZE, n);
        this.setParameter(PARAM_LEVEL_DETAIL, string);
    }

    public void setSchedule(int n, int n2) {
        this.setParameter(PARAM_SCHEDULE_DEFAULT, false);
        this.setParameter(PARAM_SCHEDULE_MODE, n);
        this.setParameter(PARAM_SCHEDULE_PARTICIPANT_CHOICE, 0);
        this.setParameter(PARAM_SCHEDULE_PARTICIPANT_SEARCH_EXHAUSTIVITY, n2);
    }

    public void setSchedule(int n, int n2, int n3) {
        this.setParameter(PARAM_SCHEDULE_DEFAULT, false);
        this.setParameter(PARAM_SCHEDULE_MODE, n);
        this.setParameter(PARAM_SCHEDULE_PARTICIPANT_CHOICE, n2);
        this.setParameter(PARAM_SCHEDULE_PARTICIPANT_SEARCH_EXHAUSTIVITY, n3);
    }

    public void setOptimization(int n, int n2, double d, int n3) {
        this.setParameter(PARAM_OPTIMIZE_DEFAULT, false);
        this.setParameter(PARAM_OPTIMIZE_NUMBER_OF_STAGES, n);
        this.setParameter(PARAM_OPTIMIZE_NUMBER_ITERATION_BY_STAGE, n2);
        this.setParameter(PARAM_OPTIMIZE_SEARCH_SPEED, d);
        this.setParameter(PARAM_OPTIMIZE_IMPROVEMENT_STAGE_SPEED, n3);
    }

    public void setQuality(int n, int n2, int n3, int n4) {
        this.setParameter(PARAM_QUALITY_DEFAULT, false);
        this.setParameter(PARAM_QUALITY_MINIMUM_INOCUPATION, n);
        this.setParameter(PARAM_QUALITY_MAXIMUM_INOCUPATION, n2);
        this.setParameter(PARAM_QUALITY_WEIGHT, n3);
        this.setParameter(PARAM_QUALITY_SEARCH_SPEED, n4);
    }

    public void setHeuristics(int n, int n2, int n3, int n4, int n5) {
        this.setParameter(PARAM_HEURISTIC_SCHEDULE_MOVE, n);
        this.setParameter(PARAM_HEURISTIC_AFFECTATION_MOVE, n2);
        this.setParameter(PARAM_HEURISTIC_GREEDY_MOVE, n3);
        this.setParameter(PARAM_HEURISTIC_PERMUTATION_MOVE, n4);
        this.setParameter(PARAM_HEURISTIC_CALENDAR_PREF_WEIGHT, n5);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public void setConfigurationId(int n) {
        this.configurationId = n;
    }

    public String getStringParameter(String string) {
        if (null != this.parameters.get(string)) {
            return (String)this.parameters.get(string);
        }
        return null;
    }

    public int getIntParameter(String string) {
        if (null != this.parameters.get(string)) {
            return Integer.parseInt((String)this.parameters.get(string));
        }
        return -1;
    }

    public boolean getBooleanParameter(String string) {
        if (null != this.parameters.get(string)) {
            return (Boolean)this.parameters.get(string);
        }
        return true;
    }

    public double getDoubleParameter(String string) {
        if (null != this.parameters.get(string)) {
            return Double.parseDouble((String)this.parameters.get(string));
        }
        return -1.0;
    }

    public void setCostWeight(int n, int n2) {
        this.costsWeight.put(n, (Object)new Integer(n2));
    }

    public MyHashTable getCostWeight() {
        return this.costsWeight;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public List getActivities() {
        return this.activities;
    }

    public List getParticipants() {
        return this.participants;
    }

    public List getResources() {
        return this.participants;
    }

    public List getLinks() {
        return this.links;
    }

    public int getFirstWeek() {
        return this.firstWeek;
    }

    public int getLastWeek() {
        return this.lastWeek;
    }

    public int getConfigurationId() {
        return this.configurationId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public void setProfileId(int n) {
        this.profileId = n;
    }

    public void setOwnerId(int n) {
        this.ownerId = n;
    }

    public double getMovingWeight() {
        return this.movingWeight;
    }

    public void setMovingWeight(double d) {
        this.movingWeight = d;
    }
}

