/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.cache;

import com.adesoft.cache.TypeCache;
import com.adesoft.collections.IntSet;
import com.adesoft.struct.Field;
import java.util.HashMap;
import java.util.Map;

public final class FieldCache {
    private final Map cachesByType = new HashMap();
    private Field previousField;
    private TypeCache previousCache;

    public boolean clear() {
        int n = this.size();
        this.cachesByType.clear();
        this.previousField = null;
        this.previousCache = null;
        return 0 != n;
    }

    public boolean isEmpty() {
        return this.cachesByType.isEmpty();
    }

    public TypeCache getCache(Field field) {
        if (this.previousField == field) {
            return this.previousCache;
        }
        TypeCache typeCache = (TypeCache)this.cachesByType.get(field);
        if (null == typeCache) {
            typeCache = new TypeCache();
            this.cachesByType.put(field, typeCache);
        }
        this.previousField = field;
        this.previousCache = typeCache;
        return typeCache;
    }

    public int size() {
        int n = 0;
        for (TypeCache typeCache : this.cachesByType.values()) {
            n = Math.max(n, typeCache.size());
        }
        return n;
    }

    public Object get(Field field, int n) {
        return this.getCache(field).get(n);
    }

    public Field[] getFields() {
        Field[] fieldArray = new Field[this.cachesByType.size()];
        this.cachesByType.keySet().toArray(fieldArray);
        return fieldArray;
    }

    public int[] getKeys() {
        IntSet intSet = new IntSet();
        for (TypeCache typeCache : this.cachesByType.values()) {
            typeCache.addKeys(intSet);
        }
        return intSet.getKeys();
    }
}

