/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.cache;

import com.adesoft.cache.CacheValue;
import com.adesoft.cache.FieldCache;
import com.adesoft.cache.RemoteCache;
import com.adesoft.cache.TypeCache;
import com.adesoft.log.Category;
import com.adesoft.struct.Field;

public final class LocalCache {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.cache.LocalCache");
    private final FieldCache cache = new FieldCache();
    private final FieldCache overideCache = new FieldCache();
    private final RemoteCache remoteCache;
    private TypeCache[] cacheByType;

    public LocalCache(RemoteCache remoteCache) {
        this.remoteCache = remoteCache;
    }

    private FieldCache getCache() {
        return this.cache;
    }

    private FieldCache getOverideCache() {
        return this.overideCache;
    }

    private RemoteCache getRemoteCache() {
        return this.remoteCache;
    }

    public void set(Field field, Object object, int n) {
        this.getOverideCache().getCache(field).set(n, object);
    }

    public Object get(Field field, int n) {
        Object object;
        if (!this.getOverideCache().isEmpty() && null != (object = this.getOverideCache().get(field, n))) {
            return object;
        }
        return this.getCache().get(field, n);
    }

    public boolean refresh(int[] nArray, Field[] fieldArray) {
        if (null == fieldArray || 0 == fieldArray.length) {
            return false;
        }
        LOG.debug((Object)"Remote cache call");
        try {
            int n = fieldArray.length;
            this.cacheByType = new TypeCache[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray2[i] = fieldArray[i].getId();
                this.cacheByType[i] = this.getCache().getCache(fieldArray[i]);
            }
            CacheValue[] cacheValueArray = this.getRemoteCache().getValues(nArray, nArray2);
            if (null == cacheValueArray) {
                return false;
            }
            for (int i = 0; i < cacheValueArray.length; ++i) {
                CacheValue cacheValue = cacheValueArray[i];
                this.cacheByType[cacheValue.getTypeIndex()].set(cacheValue.getOid(), cacheValue.getValue());
            }
        }
        catch (Throwable throwable) {
            LOG.error((Object)throwable);
        }
        return true;
    }

    public int size() {
        return this.getCache().size();
    }

    public boolean refresh() {
        boolean bl = this.getOverideCache().clear();
        return bl |= this.refresh(null, this.getCache().getFields());
    }
}

