/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.cache;

import com.adesoft.collections.Entry;
import com.adesoft.collections.IntSet;

public final class TypeCache {
    private static final int DEFAULT_SIZE = 10;
    private static final float DEFAULT_LOAD = 0.75f;
    private Entry[] table = new Entry[10];
    private int count = 0;
    private int threshold = 7;
    private int mask = this.table.length - 1;

    public void clear() {
        if (this.count > 0) {
            this.count = 0;
            this.table = new Entry[this.table.length];
        }
    }

    public final Object get(int n) {
        Entry entry = this.table[n & this.mask];
        while (null != entry) {
            if (n == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public void addKeys(IntSet intSet) {
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (null != entry) {
                intSet.add(entry.key);
                entry = entry.next;
            }
        }
    }

    public boolean set(int n, Object object) {
        if (this.count + 1 >= this.threshold) {
            this.rehash();
        }
        Entry[] entryArray = this.table;
        int n2 = n & this.mask;
        Entry entry = entryArray[n2];
        while (null != entry) {
            if (entry.key == n) {
                entry.value = object;
                return false;
            }
            entry = entry.next;
        }
        entryArray[n2] = new Entry(object, n, entryArray[n2]);
        ++this.count;
        return true;
    }

    public boolean setAndTest(int n, Object object) {
        if (this.count + 1 >= this.threshold) {
            this.rehash();
        }
        Entry[] entryArray = this.table;
        int n2 = n & this.mask;
        Entry entry = entryArray[n2];
        while (null != entry) {
            if (entry.key == n) {
                Object object2 = entry.value;
                entry.value = object;
                return !object.equals(object2);
            }
            entry = entry.next;
        }
        entryArray[n2] = new Entry(object, n, entryArray[n2]);
        ++this.count;
        return true;
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * 0.75f);
        this.table = entryArray2;
        this.mask = this.table.length - 1;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = entry2.key & this.mask;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public int size() {
        return this.count;
    }
}

