/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.calgenerator;

import com.adesoft.beans.AdeApi6;
import com.adesoft.beans.CalendarBean;
import com.adesoft.config.ConfigManager;
import com.adesoft.errors.AdeException;
import com.adesoft.errors.NotFoundException;
import com.adesoft.errors.ProjectNotFoundException;
import com.adesoft.errors.TooManySelection;
import com.adesoft.tokenparser.ConstAction;
import com.adesoft.tokenparser.ReplaceAction;
import com.adesoft.tokenparser.TokenParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import org.jdom.Element;

public class ICalGenerator {
    private static final String ICALSKELETON = "ICalSkeleton";
    private Element iCalEvents;
    protected int projectId;

    public int start(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AdeApi6 adeApi6, CalendarBean calendarBean, List<Integer> list) throws Exception {
        CalendarOutputter calendarOutputter;
        Cloneable cloneable;
        int n = -1;
        if (httpServletRequest.getParameter("startDay") != null) {
            n = Integer.parseInt(httpServletRequest.getParameter("startDay"));
        }
        int n2 = -1;
        if (httpServletRequest.getParameter("startMonth") != null) {
            n2 = Integer.parseInt(httpServletRequest.getParameter("startMonth"));
        }
        int n3 = -1;
        if (httpServletRequest.getParameter("startYear") != null) {
            n3 = Integer.parseInt(httpServletRequest.getParameter("startYear"));
        }
        int n4 = -1;
        if (httpServletRequest.getParameter("endDay") != null) {
            n4 = Integer.parseInt(httpServletRequest.getParameter("endDay"));
        }
        int n5 = -1;
        if (httpServletRequest.getParameter("endMonth") != null) {
            n5 = Integer.parseInt(httpServletRequest.getParameter("endMonth"));
        }
        int n6 = -1;
        if (httpServletRequest.getParameter("endYear") != null) {
            n6 = Integer.parseInt(httpServletRequest.getParameter("endYear"));
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        String string = httpServletRequest.getParameter("firstDate");
        String string2 = httpServletRequest.getParameter("lastDate");
        java.util.Date date = null;
        if (null != string) {
            cloneable = new SimpleDateFormat("yyyy-MM-dd");
            cloneable.setTimeZone(TimeZone.getTimeZone("UTC"));
            date = cloneable.parse(string);
            gregorianCalendar.setTime(date);
        } else {
            date = new java.util.Date();
            gregorianCalendar.setTime(date);
            gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), 0, 0);
        }
        cloneable = null;
        if (null != string2) {
            string2 = string2 + " 23:59";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            cloneable = simpleDateFormat.parse(string2);
            gregorianCalendar2.setTime((java.util.Date)cloneable);
        } else {
            cloneable = date;
            gregorianCalendar2.setTime((java.util.Date)cloneable);
            gregorianCalendar2.set(gregorianCalendar2.get(1), gregorianCalendar2.get(2), gregorianCalendar2.get(5) + 1, 0, 0);
        }
        if (null != httpServletRequest.getParameter("nbWeeks")) {
            int n7 = Integer.parseInt(httpServletRequest.getParameter("nbWeeks"));
            gregorianCalendar2.setTime(date);
            gregorianCalendar2.add(3, n7);
        }
        if (n != -1 && n2 != -1 && n3 != -1 && n4 != -1 && n5 != -1 && n6 != -1) {
            gregorianCalendar.set(n3, n2 - 1, n, 0, 0);
            gregorianCalendar2.set(n6, n5 - 1, n4, 23, 59);
        }
        try {
            this.projectId = adeApi6.getProjectId();
            this.iCalEvents = this.getEvents(adeApi6, list, gregorianCalendar, gregorianCalendar2);
        }
        catch (TooManySelection tooManySelection) {
            return -1;
        }
        int n8 = this.iCalEvents.getInt("version");
        String string3 = this.iCalEvents.getString("timezone");
        String string4 = this.iCalEvents.getString("timezoneGap");
        String string5 = "";
        if (null != httpServletRequest.getParameter("calType")) {
            string5 = "ical".equals(httpServletRequest.getParameter("calType")) ? "outlook" : "palm";
        }
        Calendar calendar = new Calendar();
        switch (n8) {
            case 1: {
                calendar.getProperties().add((Property)Method.REQUEST);
                break;
            }
            case 2: {
                calendar.getProperties().add((Property)Method.PUBLISH);
                break;
            }
            default: {
                calendar.getProperties().add((Property)Method.REQUEST);
            }
        }
        calendar.getProperties().add((Property)new ProdId("-//ADE/version 6.0"));
        if (string5.equals("outlook")) {
            calendar.getProperties().add((Property)Version.VERSION_2_0);
        } else {
            calendar.getProperties().add((Property)new Version("1.0", "1.0"));
        }
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        ArrayList<VEvent> arrayList = new ArrayList<VEvent>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone(string4));
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        simpleDateFormat3.setTimeZone(TimeZone.getTimeZone(this.getTimezoneDaylight(string4)));
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        simpleDateFormat4.setTimeZone(TimeZone.getTimeZone("UTC"));
        DateTime dateTime = new DateTime(0L);
        DateTime dateTime2 = new DateTime();
        int n9 = this.computeSequence();
        String string6 = this.iCalEvents.getString("name");
        try {
            for (Element element : calendarOutputter = this.iCalEvents.getChild("events").getChildrenArray()) {
                VEvent vEvent;
                int n7 = element.getInt("week");
                int n10 = element.getInt("day");
                int n11 = element.getInt("slot");
                int n12 = element.getInt("duration");
                java.util.Date date2 = this.getDate(calendarBean, n7, n10, n11);
                java.util.Date date3 = this.getDate(calendarBean, n7, n10, n11 + n12);
                if (date3.before(date2)) {
                    gregorianCalendar2.setTime(date3);
                    gregorianCalendar2.add(5, 1);
                    date3 = gregorianCalendar2.getTime();
                }
                if (TimeZone.getTimeZone(string3).inDaylightTime(date2)) {
                    date2 = simpleDateFormat3.parse(simpleDateFormat.format(date2));
                    date3 = simpleDateFormat3.parse(simpleDateFormat.format(date3));
                } else {
                    date2 = simpleDateFormat2.parse(simpleDateFormat.format(date2));
                    date3 = simpleDateFormat2.parse(simpleDateFormat.format(date3));
                }
                DateTime dateTime3 = new DateTime(date2);
                dateTime3.setUtc(true);
                DateTime dateTime4 = new DateTime(date3);
                dateTime4.setUtc(true);
                switch (n8) {
                    case 1: {
                        vEvent = this.createCalEventVersion(element, dateTime3, dateTime4, 1, string6, dateTime, dateTime2, simpleDateFormat4, n9);
                        break;
                    }
                    case 2: {
                        vEvent = this.createCalEventVersion(element, dateTime3, dateTime4, 2, string6, dateTime, dateTime2, simpleDateFormat4, n9);
                        break;
                    }
                    default: {
                        vEvent = this.createCalEventVersion(element, dateTime3, dateTime4, 1, string6, dateTime, dateTime2, simpleDateFormat4, n9);
                    }
                }
                arrayList.add(vEvent);
            }
            calendar.getComponents().addAll(arrayList);
        }
        catch (NotFoundException notFoundException) {
            httpServletResponse.sendError(403, "The requested resource is not valid");
            return -1;
        }
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        httpServletResponse.setContentType("text/calendar; charset=UTF-8");
        calendarOutputter = new CalendarOutputter();
        PrintWriter printWriter = httpServletResponse.getWriter();
        try {
            if (arrayList.size() > 0) {
                calendarOutputter.setValidating(true);
            } else {
                calendarOutputter.setValidating(false);
            }
            StringBuffer fileNotFoundException = new StringBuffer();
            fileNotFoundException.append("inline");
            if (string5.equals("outlook")) {
                fileNotFoundException.append("; filename=ADECal.ics");
            } else {
                fileNotFoundException.append("; filename=ADECal.vcs");
            }
            httpServletResponse.setHeader("Content-disposition", fileNotFoundException.toString());
            calendarOutputter.output(calendar, (Writer)printWriter);
        }
        catch (FileNotFoundException iOException) {
            iOException.printStackTrace();
        }
        catch (IOException validationException) {
            validationException.printStackTrace();
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
        }
        return arrayList.size();
    }

    protected String getProjectName(AdeApi6 adeApi6) throws RemoteException, AdeException, SQLException {
        return adeApi6.getProjectById(adeApi6.getProjectId()).getString("name");
    }

    protected java.util.Date getDate(CalendarBean calendarBean, int n, int n2, int n3) throws SQLException, RemoteException {
        return calendarBean.getDate(n, n2, n3);
    }

    protected Element getEvents(AdeApi6 adeApi6, List<Integer> list, GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) throws NotFoundException, RemoteException, ProjectNotFoundException, AdeException, SQLException {
        return adeApi6.getICalEvents(gregorianCalendar, gregorianCalendar2, list);
    }

    private String getTimezoneDaylight(String string) {
        int n = Integer.parseInt(string.substring(4, string.indexOf(":")));
        if (string.charAt(3) == '+') {
            return "GMT+" + (n + 1) + ":00";
        }
        return "GMT-" + (n - 1) + ":00";
    }

    private int computeSequence() {
        java.util.Date date = new java.util.Date();
        return this.computeSequence(date);
    }

    private int computeSequence(java.util.Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyDDD");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH");
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("mm");
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("ss");
        String string = simpleDateFormat.format(date);
        String string2 = simpleDateFormat2.format(date);
        String string3 = simpleDateFormat3.format(date);
        String string4 = simpleDateFormat4.format(date);
        int n = Integer.parseInt(string2) * 3600 + Integer.parseInt(string3) * 60 + Integer.parseInt(string4);
        int n2 = Integer.parseInt(string) * 100000 + n;
        return n2;
    }

    private String getUpdated(java.util.Date date) {
        TreeMap treeMap = ConfigManager.getInstance().readKeywords("Keywords", Locale.getDefault());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        String string = (String)treeMap.get("module.ical.updateDate");
        string = string.replaceFirst("#", simpleDateFormat.format(date));
        return string;
    }

    private VEvent createCalEventVersion(Element element, DateTime dateTime, DateTime dateTime2, int n, String string, DateTime dateTime3, DateTime dateTime4, SimpleDateFormat simpleDateFormat, int n2) throws ParseException, RemoteException, ProjectNotFoundException, NotFoundException {
        String string2 = element.getString("name");
        VEvent vEvent = new VEvent((Date)dateTime, (Date)dateTime2, string2);
        String string3 = this.getLocation(element);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.parseTemplate(n, element));
        if (1 < n) {
            String string4 = element.getString("lastUpdate");
            java.util.Date date = simpleDateFormat.parse(string4);
            dateTime4 = new DateTime(date);
            n2 = this.computeSequence(date);
            String string5 = this.getUpdated(date);
            stringBuffer.append(string5);
        }
        vEvent.getProperties().add((Property)new Location(string3));
        vEvent.getProperties().add((Property)new Description(stringBuffer.toString()));
        int n3 = element.getInt("activityId");
        int n4 = element.getInt("session");
        int n5 = element.getInt("repetition");
        String string6 = "" + string + "-" + n3 + "-" + n4 + "-" + n5;
        vEvent.getProperties().add((Property)new Uid("ADE60" + this.stringToHexAscii(string6)));
        vEvent.getProperties().add((Property)new Created(dateTime3));
        vEvent.getProperties().add((Property)new LastModified(dateTime4));
        vEvent.getProperties().add((Property)new Sequence(n2));
        return vEvent;
    }

    private String getLocation(Element element) {
        Element[] elementArray;
        String string = "";
        for (Element element2 : elementArray = element.getChild("resources").getChildrenArray()) {
            String string2 = element2.getString("category");
            String string3 = element2.getString("name");
            if (!"classroom".equals(string2)) continue;
            if (!"".equals(string)) {
                string = string + ",";
            }
            string = string + string3;
        }
        return string;
    }

    private String parseTemplate(int n, Element element) throws ProjectNotFoundException, NotFoundException {
        String string = ConfigManager.getInstance().readHtmlFile(ICALSKELETON, Locale.getDefault());
        return this.parseMessageBody(n, string, element);
    }

    private String parseMessageBody(int n, String string, Element element) {
        TreeMap treeMap = ConfigManager.getInstance().readKeywords("Keywords", Locale.getDefault());
        String string2 = "";
        TokenParser tokenParser = new TokenParser();
        Element element2 = element.getChild("activity");
        String string3 = element2.getString("name");
        String string4 = element2.getString("type");
        String string5 = element2.getString("code");
        String string6 = element2.getString("codeX");
        String string7 = element2.getString("codeY");
        String string8 = element2.getString("codeZ");
        String string9 = element2.getString("timezone");
        String string10 = element2.getString("url");
        String string11 = element2.getString("info");
        String string12 = element2.getString("maxSeats");
        String string13 = element2.getString("seatsLeft");
        String string14 = element.getString("note");
        tokenParser.register("COURSENAME", (ReplaceAction)new ConstAction(string3));
        tokenParser.register("TYPE_ACTIVITY", (ReplaceAction)new ConstAction(string4));
        tokenParser.register("CODE_ACTIVITY", (ReplaceAction)new ConstAction(string5));
        tokenParser.register("CODEX_ACTIVITY", (ReplaceAction)new ConstAction(string6));
        tokenParser.register("CODEY_ACTIVITY", (ReplaceAction)new ConstAction(string7));
        tokenParser.register("CODEZ_ACTIVITY", (ReplaceAction)new ConstAction(string8));
        tokenParser.register("TIMEZONE_ACTIVITY", (ReplaceAction)new ConstAction(string9));
        tokenParser.register("WEB_ACTIVITY", (ReplaceAction)new ConstAction(string10));
        tokenParser.register("INFO_ACTIVITY", (ReplaceAction)new ConstAction(string11));
        tokenParser.register("MAXSEATS", (ReplaceAction)new ConstAction(string12));
        tokenParser.register("SEATSLEFT", (ReplaceAction)new ConstAction(string13));
        tokenParser.register("INFO_EVENT", (ReplaceAction)new ConstAction(string14));
        String string15 = (String)treeMap.get("module.ical.exportDate");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        java.util.Date date = new java.util.Date();
        if (string15.contains("#")) {
            string15 = string15.replaceFirst("#", simpleDateFormat.format(date));
        }
        String string16 = simpleDateFormat.format(date);
        if (n == 2) {
            string15 = "";
            string16 = "";
        }
        tokenParser.register("LABEL_EXPORT", (ReplaceAction)new ConstAction(string15));
        tokenParser.register("EXPORT_TIMESTAMP", (ReplaceAction)new ConstAction(string16));
        ICalGenerator.registerParticipants(element, tokenParser);
        try {
            string = string.replaceAll("(?s)<!--.*?-->", "");
            string2 = tokenParser.parse(string);
        }
        catch (Throwable throwable) {
            return "ERROR";
        }
        return string2;
    }

    private static void registerParticipants(final Element element, TokenParser tokenParser) {
        tokenParser.register("PARTICIPANTS", new ReplaceAction(){

            public String getValue() {
                Element[] elementArray;
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = true;
                for (Element element2 : elementArray = element.getChild("resources").getChildrenArray()) {
                    String string = element2.getString("category");
                    String string2 = element2.getString("name");
                    if ("classroom".equals(string)) continue;
                    if (!bl) {
                        stringBuffer.append('\n');
                    }
                    stringBuffer.append(string2);
                    bl = false;
                }
                return stringBuffer.toString();
            }
        });
    }

    private String stringToHexAscii(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != string) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ' ') continue;
                stringBuffer.append(Integer.toHexString(c));
            }
        }
        return stringBuffer.toString();
    }
}

