/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.calgenerator;

import com.adesoft.beans.AdeApi6;
import com.adesoft.beans.CalendarBean;
import com.adesoft.beans.CookiesSqlBean;
import com.adesoft.calgenerator.ICalGenerator;
import com.adesoft.config.ConfigManager;
import com.adesoft.errors.AdeException;
import com.adesoft.properties.ServerProperty;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.jdom.Element;

public class ICalGeneratorSQL
extends ICalGenerator {
    private CookiesSqlBean sqlManager;
    private String dateFormat = ConfigManager.getInstance().getProperty(ServerProperty.CAL_SQL_DATE_FORMAT);
    private int nbSlots = 1;
    private int firstSlot = 1;
    private int firstWeek = 1;

    private CookiesSqlBean getSqlManager() {
        if (null == this.sqlManager) {
            ConfigManager configManager = ConfigManager.getInstance();
            this.sqlManager = new CookiesSqlBean();
            this.sqlManager.setJdbcDriver(configManager.getProperty(ServerProperty.JDBC_DRIVER));
            this.sqlManager.setJdbcSource(configManager.getProperty(ServerProperty.JDBC_SOURCE));
            this.sqlManager.setJdbcLogin(configManager.getProperty(ServerProperty.USER));
            this.sqlManager.setJdbcPassword(configManager.getProperty(ServerProperty.PASSWORD));
        }
        return this.sqlManager;
    }

    @Override
    protected String getProjectName(AdeApi6 adeApi6) throws RemoteException, AdeException, SQLException {
        ResultSet resultSet = this.getSqlManager().executeSQLQuery("SELECT name FROM tblprojects WHERE id=" + adeApi6.getProjectId());
        String string = "";
        if (resultSet.next()) {
            string = resultSet.getString("name");
        }
        return string;
    }

    @Override
    protected Element getEvents(AdeApi6 adeApi6, List<Integer> list, GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) throws RemoteException, AdeException, SQLException {
        Element element = new Element("iCal");
        Element element2 = new Element("events");
        String string = this.getProjectName(adeApi6);
        int n = ConfigManager.getInstance().getIntProperty(ServerProperty.CAL_VERSION);
        String string2 = ConfigManager.getInstance().getProperty(ServerProperty.TIMEZONE);
        String string3 = ConfigManager.getInstance().getProperty(ServerProperty.TIMEZONE_GAP);
        element.addAttribute("timezoneGap", string3);
        element.addAttribute("timezone", string2);
        element.addAttribute("name", string);
        element.addAttribute("version", n);
        element.addChild(element2);
        try {
            HashSet<Integer> hashSet = new HashSet<Integer>(list);
            this.addAllSetMembers(adeApi6, hashSet, hashSet);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(hashSet);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(hashSet);
            this.addAllLeaves(adeApi6, arrayList, arrayList2, arrayList);
            HashSet<Integer> hashSet2 = new HashSet<Integer>(hashSet);
            this.addAllFathers(adeApi6, hashSet2, hashSet2);
            HashSet<Integer> hashSet3 = new HashSet<Integer>(arrayList2);
            hashSet3.addAll(hashSet2);
            HashMap<Integer, Integer> hashMap = this.getPeriod(adeApi6.getProjectId(), gregorianCalendar, gregorianCalendar2);
            if (!hashMap.isEmpty()) {
                this.addEventsWithResources(element2, this.getQueryScheduleEventsFromImposed(adeApi6, hashMap, hashSet3));
                this.addEventsWithResources(element2, this.getQueryScheduleEventsFromChosen(adeApi6, hashMap, arrayList));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return element;
    }

    private String getCategory(int n) {
        switch (n) {
            case 1: {
                return "trainee";
            }
            case 2: {
                return "instructor";
            }
            case 3: {
                return "classroom";
            }
            case 4: {
                return "equipment";
            }
            case 5: {
                return "category5";
            }
            case 6: {
                return "category6";
            }
            case 7: {
                return "categiry7";
            }
            case 8: {
                return "category8";
            }
        }
        return "trainee";
    }

    private HashMap<Integer, Integer> getPeriod(int n, GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) throws SQLException {
        String string = "SELECT daySize,startOfDay,startofyear,yearsize,weeksize FROM tbltimeframesettings where projectId=" + n;
        ResultSet resultSet = this.getSqlManager().executeSQLQuery(string);
        int n2 = -1;
        int n3 = -1;
        if (resultSet.next()) {
            this.nbSlots = resultSet.getInt("daySize");
            this.firstSlot = resultSet.getInt("startofday");
            this.firstWeek = resultSet.getInt("startofyear");
            n2 = resultSet.getInt("yearsize");
            n3 = resultSet.getInt("weeksize");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateFormat);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.add(5, -7);
        int n4 = gregorianCalendar.get(7);
        int n5 = gregorianCalendar2.get(7);
        String string2 = "SELECT week,calendar FROM tblweeknames where projectId=" + n + " and calendar>'" + simpleDateFormat.format(gregorianCalendar.getTime()) + "' and calendar<='" + simpleDateFormat.format(gregorianCalendar2.getTime()) + "'";
        ResultSet resultSet2 = this.getSqlManager().executeSQLQuery(string2);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = 2;
        while (resultSet2.next()) {
            int n7 = resultSet2.getInt("week");
            if (n7 >= this.firstWeek && n7 < this.firstWeek + n2) {
                arrayList.add(n7 - this.firstWeek);
            } else if (n7 < this.firstWeek) {
                bl2 = true;
            } else if (n7 >= this.firstWeek + n2) {
                bl3 = true;
            }
            if (!bl) continue;
            Timestamp timestamp = resultSet2.getTimestamp("calendar");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timestamp);
            n6 = calendar.get(7);
            bl = false;
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        if (!arrayList.isEmpty()) {
            if (!bl2) {
                int n8 = n4 - n6;
                if (n8 < 0) {
                    n8 += 7;
                }
                hashMap.put((Integer)arrayList.get(0), n8);
            } else {
                hashMap.put((Integer)arrayList.get(0), 0);
            }
            if (!bl3) {
                int n9 = n5 - n6;
                if (n9 < 0) {
                    n9 += 7;
                }
                hashMap.put((Integer)arrayList.get(arrayList.size() - 1), n9);
            } else {
                hashMap.put((Integer)arrayList.get(arrayList.size() - 1), n3 - 1);
            }
        }
        return hashMap;
    }

    @Override
    protected Date getDate(CalendarBean calendarBean, int n, int n2, int n3) throws SQLException {
        Comparable<Date> comparable;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        ResultSet resultSet = this.getSqlManager().executeSQLQuery("select calendar from tblweeknames where projectId=" + calendarBean.getProjectId() + " and week=" + (n + this.firstWeek));
        if (resultSet.next()) {
            comparable = resultSet.getDate("calendar");
            calendar.setTime((Date)comparable);
        }
        calendar.add(6, n2 + 1);
        comparable = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        ResultSet resultSet2 = this.getSqlManager().executeSQLQuery("select calendar from tblslotnames where projectId=" + calendarBean.getProjectId() + " and slot=" + (n3 + this.firstSlot));
        if (resultSet2.next()) {
            Timestamp timestamp = resultSet2.getTimestamp("calendar");
            ((Calendar)comparable).setTime(timestamp);
            int n4 = ((Calendar)comparable).get(11);
            int n5 = ((Calendar)comparable).get(12);
            int n6 = ((Calendar)comparable).get(13);
            calendar.set(11, n4);
            calendar.set(12, n5);
            calendar.set(13, n6);
        }
        return calendar.getTime();
    }

    private String getRequestActivity(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ID, PROJECTID, NAME ");
        stringBuffer.append("from TBLCOURSES where ID=");
        stringBuffer.append(n);
        stringBuffer.append(" and PROJECTID=");
        stringBuffer.append(this.projectId);
        return stringBuffer.toString();
    }

    private String getRequestOtherActivity(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ID as courseId,");
        stringBuffer.append("PROJECTID as projectId,");
        stringBuffer.append("TYPE as type,");
        stringBuffer.append("CODE as code,");
        stringBuffer.append("CODEX as codeX,");
        stringBuffer.append("CODEY as codeY,");
        stringBuffer.append("CODEZ as codeZ,");
        stringBuffer.append("TIMEZONE as timezone,");
        stringBuffer.append("URL as web,");
        stringBuffer.append("INFO as info,");
        stringBuffer.append("MAXSEATS as maxSeats,");
        stringBuffer.append("SEATSLEFT as seatsLeft");
        stringBuffer.append(" from TBLCOURSESEX where ID=");
        stringBuffer.append(n);
        stringBuffer.append(" and PROJECTID=");
        stringBuffer.append(this.projectId);
        return stringBuffer.toString();
    }

    private StringBuffer getQueryFieldsEventsNoResources() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select selected.ENTITYID as selectedId,");
        stringBuffer.append("scheduleEvents.ID as eventId,");
        stringBuffer.append("scheduleEvents.COURSEID as courseId,");
        stringBuffer.append("scheduleEvents.SESSIONORDER as sessionId,");
        stringBuffer.append("scheduleEvents.REPETITION as repetition,");
        stringBuffer.append("scheduleEvents.WEEK as weekId,");
        stringBuffer.append("scheduleEvents.WEEKHOUR as weekHour,");
        stringBuffer.append("scheduleEvents.DURATION as duration,");
        stringBuffer.append("scheduleEvents.UPDATEDDATE as updatedDate,");
        stringBuffer.append("scheduleEvents.UPDATEDTIME as updatedTime,");
        stringBuffer.append("courses.NAME as name,");
        stringBuffer.append("info.NOTE as note ");
        return stringBuffer;
    }

    private StringBuffer getQueryFieldsEventsResources() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select scheduleEvents.ID as eventId,");
        stringBuffer.append("chosen.ENTITYID as chosenId,");
        stringBuffer.append("chosenEntities.NAME as chosenName,");
        stringBuffer.append("chosenEntities.ENTITYTYPEID as chosenType,");
        stringBuffer.append("imposed.ENTITYID as imposedId,");
        stringBuffer.append("imposedEntities.NAME as imposedName,");
        stringBuffer.append("imposedEntities.ENTITYTYPEID as imposedType ");
        return stringBuffer;
    }

    private String getQueryScheduleEventsFromImposed(AdeApi6 adeApi6, HashMap<Integer, Integer> hashMap, Set<Integer> set) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getQueryFieldsEventsNoResources());
        stringBuffer.append("from TBLCOURSEMEMBERS selected ");
        stringBuffer.append("inner join TBLSCHEDULEEVENTS scheduleEvents on selected.PROJECTID=scheduleEvents.PROJECTID and selected.COURSEID=scheduleEvents.COURSEID and (");
        boolean bl = true;
        for (int n : set) {
            if (!bl) {
                stringBuffer.append(" or ");
            }
            bl = false;
            stringBuffer.append("selected.ENTITYID=");
            stringBuffer.append(n);
        }
        stringBuffer.append(") ");
        stringBuffer.append("inner join TBLCOURSES courses on selected.PROJECTID=courses.PROJECTID and selected.COURSEID=courses.ID ");
        stringBuffer.append("left outer join TBLEVENTINFO info on scheduleEvents.PROJECTID=info.PROJECTID and scheduleEvents.COURSEID=info.COURSEID and scheduleEvents.SESSIONORDER=info.SESSIONID and scheduleEvents.REPETITION=info.REPETITIONID ");
        stringBuffer.append("where selected.PROJECTID=");
        stringBuffer.append(adeApi6.getProjectId());
        stringBuffer.append(" and selected.FATHERID=-1 and ");
        bl = true;
        stringBuffer.append(this.getQueryWhereWeeks(hashMap));
        return stringBuffer.toString();
    }

    private String getQueryScheduleEventsFromChosen(AdeApi6 adeApi6, HashMap<Integer, Integer> hashMap, List<Integer> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getQueryFieldsEventsNoResources());
        stringBuffer.append("from TBLEVENTENTITIES selected ");
        stringBuffer.append("inner join TBLSCHEDULEEVENTS scheduleEvents on selected.PROJECTID=scheduleEvents.PROJECTID and selected.ID=scheduleEvents.ID and (");
        boolean bl = true;
        for (int n : list) {
            if (!bl) {
                stringBuffer.append(" or ");
            }
            bl = false;
            stringBuffer.append("selected.ENTITYID=");
            stringBuffer.append(n);
        }
        stringBuffer.append(") ");
        stringBuffer.append("inner join TBLCOURSES courses on selected.PROJECTID=courses.PROJECTID and scheduleEvents.COURSEID=courses.ID ");
        stringBuffer.append("left outer join TBLEVENTINFO info on scheduleEvents.PROJECTID=info.PROJECTID and scheduleEvents.COURSEID=info.COURSEID and scheduleEvents.SESSIONORDER=info.SESSIONID and scheduleEvents.REPETITION=info.REPETITIONID ");
        stringBuffer.append("where selected.PROJECTID=");
        stringBuffer.append(adeApi6.getProjectId());
        stringBuffer.append(" and ");
        stringBuffer.append(this.getQueryWhereWeeks(hashMap));
        return stringBuffer.toString();
    }

    private String getQueryWhereWeeks(HashMap<Integer, Integer> hashMap) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(hashMap.keySet());
        Collections.sort(arrayList);
        int n = (Integer)arrayList.get(0);
        int n2 = hashMap.get(n) * this.nbSlots;
        int n3 = (Integer)arrayList.get(arrayList.size() - 1);
        int n4 = (hashMap.get(n3) + 1) * this.nbSlots;
        stringBuffer.append("((scheduleEvents.WEEK=");
        stringBuffer.append(n);
        stringBuffer.append(" and scheduleEvents.WEEKHOUR>=");
        stringBuffer.append(n2);
        stringBuffer.append(")");
        if (n3 - n >= 2) {
            stringBuffer.append(" or (scheduleEvents.WEEK BETWEEN ");
            stringBuffer.append(n + 1);
            stringBuffer.append(" and ");
            stringBuffer.append(n3 - 1);
            stringBuffer.append(")");
        }
        stringBuffer.append(" or (scheduleEvents.WEEK=");
        stringBuffer.append(n3);
        stringBuffer.append(" and scheduleEvents.WEEKHOUR<");
        stringBuffer.append(n4);
        stringBuffer.append("))");
        return stringBuffer.toString();
    }

    private String getQueryMembers(Set<Integer> set) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getQueryFieldsEventsResources());
        stringBuffer.append(" from TBLSCHEDULEEVENTS scheduleEvents");
        stringBuffer.append(" inner join TBLCOURSEMEMBERS imposed on imposed.PROJECTID=scheduleEvents.PROJECTID and imposed.COURSEID=scheduleEvents.COURSEID and imposed.FATHERID=-1");
        stringBuffer.append(" inner join TBLENTITIES imposedEntities on imposedEntities.PROJECTID=scheduleEvents.PROJECTID AND imposedEntities.ID=imposed.ENTITYID");
        stringBuffer.append(" left outer join TBLEVENTENTITIES chosen on chosen.PROJECTID=scheduleEvents.PROJECTID and chosen.ID=scheduleEvents.ID");
        stringBuffer.append(" left outer join TBLENTITIES chosenEntities on chosenEntities.PROJECTID=scheduleEvents.PROJECTID AND chosenEntities.ID=chosen.ENTITYID");
        stringBuffer.append(" where scheduleEvents.PROJECTID=");
        stringBuffer.append(this.projectId);
        stringBuffer.append(" and (");
        boolean bl = true;
        for (int n : set) {
            if (!bl) {
                stringBuffer.append(" or ");
            }
            bl = false;
            stringBuffer.append("scheduleEvents.ID=");
            stringBuffer.append(n);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private HashMap<Integer, Element> getEvents(Element element, String string) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        HashMap<Integer, Element> hashMap = new HashMap<Integer, Element>();
        HashMap<Element, Integer> hashMap2 = new HashMap<Element, Integer>();
        ResultSet resultSet = this.getSqlManager().executeSQLQuery(string);
        while (resultSet.next()) {
            int n = resultSet.getInt("eventId");
            int n2 = resultSet.getInt("courseId");
            Element element2 = new Element("event");
            element2.addAttribute("eventId", n);
            element2.addAttribute("session", resultSet.getInt("sessionId"));
            element2.addAttribute("repetition", resultSet.getInt("repetition"));
            element2.addAttribute("activityId", n2);
            element2.addAttribute("week", resultSet.getInt("weekId"));
            int n3 = resultSet.getInt("weekHour");
            element2.addAttribute("day", n3 / this.nbSlots);
            element2.addAttribute("slot", n3 % this.nbSlots);
            element2.addAttribute("duration", resultSet.getInt("duration"));
            object3 = this.getDate(resultSet.getTimestamp("updatedDate"), resultSet.getTimestamp("updatedTime"));
            object2 = new SimpleDateFormat("MM/dd/yyyy HH:mm");
            element2.addAttribute("lastUpdate", ((DateFormat)object2).format((Date)object3));
            element2.addAttribute("name", resultSet.getString("name"));
            object = resultSet.getString("note");
            if (null != object) {
                element2.addAttribute("note", (String)object);
            } else {
                element2.addAttribute("note", "");
            }
            hashMap2.put(element2, n2);
        }
        for (Element element3 : hashMap2.keySet()) {
            int n = (Integer)hashMap2.get(element3);
            Element element4 = new Element("activity");
            object3 = this.getRequestOtherActivity(n);
            object2 = this.getSqlManager().executeSQLQuery((String)object3);
            while (object2.next()) {
                element3.addChild(element4);
                element4.addAttribute("type", object2.getString("type"));
                element4.addAttribute("code", object2.getString("code"));
                element4.addAttribute("codeX", object2.getString("codeX"));
                element4.addAttribute("codeY", object2.getString("codeY"));
                element4.addAttribute("codeZ", object2.getString("codeZ"));
                element4.addAttribute("timezone", object2.getString("timezone"));
                element4.addAttribute("url", object2.getString("web"));
                element4.addAttribute("info", object2.getString("info"));
                element4.addAttribute("maxSeats", object2.getString("maxSeats"));
                element4.addAttribute("seatsLeft", object2.getString("seatsLeft"));
            }
            object2 = this.getSqlManager().executeSQLQuery(this.getRequestActivity(n));
            while (object2.next()) {
                element4.addAttribute("name", object2.getString("name"));
            }
            object = new Element("resources");
            element3.addChild(object);
            element.addChild(element3);
            int n4 = element3.getInt("eventId");
            hashMap.put(n4, element3);
        }
        return hashMap;
    }

    private void addEventsWithResources(Element element, String string) throws SQLException {
        HashMap<Integer, Element> hashMap = this.getEvents(element, string);
        if (!hashMap.isEmpty()) {
            HashMap hashMap2 = new HashMap();
            ResultSet resultSet = this.getSqlManager().executeSQLQuery(this.getQueryMembers(hashMap.keySet()));
            while (resultSet.next()) {
                Element element2;
                int n = resultSet.getInt("eventId");
                Element element3 = hashMap.get(n);
                if (null == element3) continue;
                int n2 = resultSet.getInt("chosenId");
                String string2 = resultSet.getString("chosenName");
                int n3 = resultSet.getInt("chosenType");
                int n4 = resultSet.getInt("imposedId");
                String string3 = resultSet.getString("imposedName");
                int n5 = resultSet.getInt("imposedType");
                ArrayList<Integer> arrayList = (ArrayList<Integer>)hashMap2.get(n);
                if (null == arrayList) {
                    arrayList = new ArrayList<Integer>();
                    hashMap2.put(n, arrayList);
                }
                Element element4 = element3.getChild("resources");
                if (null != string2 && !arrayList.contains(n2)) {
                    element2 = new Element("resource");
                    element2.addAttribute("name", string2);
                    element2.addAttribute("category", this.getCategory(n3));
                    element4.addChild(element2);
                    arrayList.add(n2);
                }
                if (null == string3 || arrayList.contains(n4)) continue;
                element2 = new Element("resource");
                element2.addAttribute("name", string3);
                element2.addAttribute("category", this.getCategory(n5));
                element4.addChild(element2);
                arrayList.add(n4);
            }
        }
    }

    private void addAllSetMembers(AdeApi6 adeApi6, Set<Integer> set, Set<Integer> set2) throws SQLException {
        int n = set.size();
        Set<Integer> set3 = this.getSetMembers(adeApi6, set2);
        if (!set3.isEmpty()) {
            set.addAll(set3);
            if (set.size() > n) {
                this.addAllSetMembers(adeApi6, set, set3);
            }
        }
    }

    private Set<Integer> getSetMembers(AdeApi6 adeApi6, Set<Integer> set) throws SQLException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ResultSet resultSet = this.getSqlManager().executeSQLQuery(this.getQuerySetMembers(adeApi6, set));
        while (resultSet.next()) {
            hashSet.add(resultSet.getInt("SETID"));
        }
        return hashSet;
    }

    private String getQuerySetMembers(AdeApi6 adeApi6, Set<Integer> set) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select SETID from TBLMEMBERS where PROJECTID=");
        stringBuffer.append(adeApi6.getProjectId());
        stringBuffer.append(" and (");
        boolean bl = true;
        for (int n : set) {
            if (!bl) {
                stringBuffer.append(" or ");
            }
            bl = false;
            stringBuffer.append("MEMBERID=");
            stringBuffer.append(n);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void addAllLeaves(AdeApi6 adeApi6, List<Integer> list, List<Integer> list2, List<Integer> list3) throws SQLException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ResultSet resultSet = this.getSqlManager().executeSQLQuery(this.getQueryLeaves(adeApi6, list3));
        while (resultSet.next()) {
            int n = resultSet.getInt("ID");
            boolean bl = resultSet.getBoolean("FOLDER");
            list2.add(n);
            if (bl) {
                arrayList.add(n);
                continue;
            }
            list.add(n);
        }
        if (!arrayList.isEmpty()) {
            this.addAllLeaves(adeApi6, list2, list, arrayList);
        }
    }

    private String getQueryLeaves(AdeApi6 adeApi6, List<Integer> list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ID,FOLDER from TBLENTITIES where PROJECTID=");
        stringBuffer.append(adeApi6.getProjectId());
        stringBuffer.append(" and (");
        boolean bl = true;
        for (int n : list) {
            if (!bl) {
                stringBuffer.append(" or ");
            }
            bl = false;
            stringBuffer.append("FATHERID=");
            stringBuffer.append(n);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void addAllFathers(AdeApi6 adeApi6, Set<Integer> set, Set<Integer> set2) throws SQLException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ResultSet resultSet = this.getSqlManager().executeSQLQuery(this.getQueryFathers(adeApi6, set2));
        while (resultSet.next()) {
            int n = resultSet.getInt("ID");
            int n2 = resultSet.getInt("FATHERID");
            if (n2 != -1) {
                hashSet.add(n2);
            }
            set.add(n);
        }
        if (!hashSet.isEmpty()) {
            this.addAllFathers(adeApi6, set, hashSet);
        }
    }

    private String getQueryFathers(AdeApi6 adeApi6, Set<Integer> set) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ID,FATHERID from TBLENTITIES where PROJECTID=");
        stringBuffer.append(adeApi6.getProjectId());
        stringBuffer.append(" and (");
        boolean bl = true;
        for (int n : set) {
            if (!bl) {
                stringBuffer.append(" or ");
            }
            bl = false;
            stringBuffer.append("ID=");
            stringBuffer.append(n);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private Date getDate(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getDefault());
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        calendar.setTime(date2);
        calendar.set(5, n3);
        calendar.set(2, n2);
        calendar.set(1, n);
        return calendar.getTime();
    }
}

