/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.calgenerator;

import com.adesoft.beans.AdeApi6;
import com.adesoft.beans.CalendarBean;
import com.adesoft.calgenerator.ICalGenerator;
import com.adesoft.config.ConfigManager;
import com.adesoft.properties.ServerProperty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WaitingICalGenerator {
    public static AtomicInteger nbWaitingThreads = new AtomicInteger(0);
    public static final int maxThreads = ConfigManager.getInstance().getIntProperty(ServerProperty.CAL_MAX_CONCURRENT_THREADS);
    public static final int maxWaitingThreads = ConfigManager.getInstance().getIntProperty(ServerProperty.CAL_MAX_WAITING_THREADS);
    private Semaphore sem = new Semaphore(maxThreads, true);

    public boolean acquire(HttpServletResponse httpServletResponse) throws InterruptedException, IOException {
        if (maxThreads > 0) {
            nbWaitingThreads.incrementAndGet();
            if (nbWaitingThreads.get() > maxWaitingThreads) {
                nbWaitingThreads.decrementAndGet();
                httpServletResponse.sendError(408, "Too much requests");
                return false;
            }
            this.sem.acquire();
            nbWaitingThreads.decrementAndGet();
            return true;
        }
        return true;
    }

    public void release() {
        if (maxThreads > 0) {
            this.sem.release();
        }
    }

    public int start(ICalGenerator iCalGenerator, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AdeApi6 adeApi6, CalendarBean calendarBean, List<Integer> list) throws Exception {
        return iCalGenerator.start(httpServletRequest, httpServletResponse, adeApi6, calendarBean, list);
    }
}

