/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.confirmationMails;

import com.adesoft.beans.AdeApi;
import com.adesoft.beans.AdeApi6;
import com.adesoft.beans.AdeList;
import com.adesoft.beans.CalendarBean;
import com.adesoft.beans.ClientBean;
import com.adesoft.beans.CustomAction;
import com.adesoft.beans.filters.FiltersActivities;
import com.adesoft.beans.filters.FiltersEvents;
import com.adesoft.beans.filters.FiltersResources;
import com.adesoft.beans.settings.EventSettings;
import com.adesoft.config.ConfigManager;
import com.adesoft.errors.AdeException;
import com.adesoft.errors.EntityGroupError;
import com.adesoft.errors.NotFoundException;
import com.adesoft.errors.ProjectNotFoundException;
import com.adesoft.log.Category;
import com.adesoft.properties.ServerProperty;
import com.adesoft.struct.Field;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Element;

public class MailConfirmationSender
implements CustomAction {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.confirmationMails.MailConfirmationSender");
    private AdeApi6 api;
    private CalendarBean calendar;
    private Calendar cal;
    private ConfigManager cm;
    private SimpleDateFormat formater;
    private int delayMail1AfterReservation = -1;
    private int delayConfirmAfterMail1 = -1;
    private int delayMail2BeforeEvent = -1;
    private int delayConfirmAfterMail2 = -1;
    private int delayAutoValidation = -1;
    private int waitingConfirmationResourceId = -1;
    private int confirmationResourceId = -1;

    public MailConfirmationSender() {
        try {
            this.cal = Calendar.getInstance();
            this.cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.cm = ConfigManager.getInstance();
            this.formater = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
        }
    }

    @Override
    public void start(AdeApi adeApi, ClientBean clientBean, CalendarBean calendarBean, int n, long l, HashMap<String, String> hashMap, ArrayList<String> arrayList) {
        this.api = new AdeApi6();
        this.api.setSessionId(adeApi.getSessionId());
        this.calendar = calendarBean;
        try {
            this.initParams();
            if (-1 != this.delayMail1AfterReservation) {
                this.sendMailsAfterCreation();
                this.deleteEventsUnconfirmed(true);
            }
            if (-1 != this.delayMail2BeforeEvent) {
                this.sendMailsBeforEvent();
                this.deleteEventsUnconfirmed(false);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
        }
    }

    private void initParams() throws NotFoundException, RemoteException, ProjectNotFoundException {
        TreeMap treeMap = this.cm.readProperties("ConfirmationMails");
        this.delayMail1AfterReservation = Integer.parseInt((String)treeMap.get("DelayMail1AfterReservation"));
        this.delayConfirmAfterMail1 = Integer.parseInt((String)treeMap.get("DelayConfirmAfterMail1"));
        this.delayMail2BeforeEvent = Integer.parseInt((String)treeMap.get("DelayMail2BeforeEvent"));
        this.delayConfirmAfterMail2 = Integer.parseInt((String)treeMap.get("DelayConfirmAfterMail2"));
        this.delayAutoValidation = Integer.parseInt((String)treeMap.get("DelayAutoValidation"));
        this.initConfirmationIds(this.api, treeMap);
    }

    private void initConfirmationIds(AdeApi6 adeApi6, TreeMap<String, String> treeMap) throws NotFoundException, RemoteException, ProjectNotFoundException {
        String string = treeMap.get("ConfirmationResourceField");
        String string2 = treeMap.get("WaitingConfirmationResource");
        String string3 = treeMap.get("ConfirmationResource");
        FiltersResources filtersResources = new FiltersResources();
        filtersResources.addFilterFields(string, Arrays.asList(string2, string3));
        Element element = adeApi6.getResources(filtersResources, 1, Field.getByName(string));
        for (Element element2 : element.getChildrenArray()) {
            int n = element2.getInt("id");
            String string4 = element2.getString(string);
            if (string4.equals(string2)) {
                this.waitingConfirmationResourceId = n;
            }
            if (!string4.equals(string3)) continue;
            this.confirmationResourceId = n;
        }
    }

    private void sendMailsAfterCreation() throws Exception {
        HashMap<Integer, String> hashMap = this.getReservationsToConfirm(true);
        for (int n : hashMap.keySet()) {
            this.api.notifyByMail(new ArrayList<Integer>(Arrays.asList(n)), null, null, this.getTemplateConfirmation("MailConfirmation1Skeleton", n), null, null, new ArrayList<String>(Arrays.asList(hashMap.get(n))), null, false);
        }
    }

    private void deleteEventsUnconfirmed(boolean bl) throws Exception {
        int n = this.getBookingResource();
        if (-1 != n) {
            Object object;
            Cloneable cloneable;
            FiltersActivities filtersActivities = new FiltersActivities();
            filtersActivities.addFilterResource(n, 0);
            int n2 = -1;
            int n3 = -1;
            if (bl) {
                this.addCreationDateToFilter(filtersActivities, -1 * (this.delayMail1AfterReservation + this.delayConfirmAfterMail1));
            } else {
                cloneable = this.addPlacementDateToFilter(filtersActivities, this.delayConfirmAfterMail2);
                object = this.calendar.getDate((Date)cloneable);
                n2 = object.getChild("week").getInt("id");
                n3 = object.getChild("day").getInt("id");
            }
            cloneable = new HashMap();
            object = new HashMap();
            Element element = this.api.getActivities(filtersActivities, 15);
            for (Element elementArray : element.getChildrenArray()) {
                int n4 = elementArray.getInt("ownerId");
                Element element2 = this.api.getUser(n4, 5);
                ((HashMap)object).put(elementArray.getInt("id"), element2.getString("email"));
                ((HashMap)cloneable).put(elementArray.getInt("id"), elementArray);
            }
            ArrayList arrayList = new ArrayList();
            FiltersEvents filtersEvents = new FiltersEvents();
            filtersEvents.addFilterActivities(new ArrayList(((HashMap)object).keySet()));
            Element element3 = this.api.getEvents(filtersEvents, 8);
            block1: for (Element element4 : element3.getChildrenArray()) {
                if (n2 != -1 && (element4.getInt("week") != n2 || element4.getInt("day") != n3)) continue;
                for (Element element5 : element4.getChild("resources").getChildrenArray()) {
                    if (element5.getInt("id") != this.waitingConfirmationResourceId) continue;
                    EventSettings eventSettings = new EventSettings(element4.getInt("id"));
                    arrayList.add(eventSettings);
                    continue block1;
                }
            }
            this.api.removeEvents(arrayList, 0, true);
        }
    }

    private void sendMailsBeforEvent() throws Exception {
        HashMap<Integer, String> hashMap = this.getReservationsToConfirm(false);
        for (int n : hashMap.keySet()) {
            this.api.notifyByMail(new ArrayList<Integer>(Arrays.asList(n)), null, null, this.getTemplateConfirmation("MailConfirmation2Skeleton", n), null, null, new ArrayList<String>(Arrays.asList(hashMap.get(n))), null, false);
        }
    }

    private Date addCreationDateToFilter(FiltersActivities filtersActivities, int n) {
        this.cal.setTime(new Date());
        this.cal.add(5, n);
        Date date = this.cal.getTime();
        filtersActivities.addFilterCreatedStartDate(this.cal.getTimeInMillis());
        filtersActivities.addFilterCreatedEndDate(this.cal.getTimeInMillis());
        return date;
    }

    private Date addPlacementDateToFilter(FiltersActivities filtersActivities, int n) {
        this.cal.setTime(new Date());
        this.cal.add(5, n);
        Date date = this.cal.getTime();
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        filtersActivities.addFilterDateStart(this.cal.getTimeInMillis());
        this.cal.set(11, 23);
        this.cal.set(12, 59);
        this.cal.set(13, 59);
        filtersActivities.addFilterDateEnd(this.cal.getTimeInMillis());
        return date;
    }

    private HashMap<Integer, String> getReservationsToConfirm(boolean bl) throws Exception {
        int n = this.getBookingResource();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        if (-1 != n) {
            FiltersActivities filtersActivities = new FiltersActivities();
            filtersActivities.addFilterResource(n, 0);
            Date date = null;
            date = bl ? this.addCreationDateToFilter(filtersActivities, -1 * this.delayMail1AfterReservation) : this.addPlacementDateToFilter(filtersActivities, this.delayMail2BeforeEvent);
            HashMap<Integer, Element> hashMap2 = new HashMap<Integer, Element>();
            HashMap<Integer, String> hashMap3 = new HashMap<Integer, String>();
            HashMap<Integer, Date> hashMap4 = new HashMap<Integer, Date>();
            Element element = this.api.getActivities(filtersActivities, 15);
            for (Element element2 : element.getChildrenArray()) {
                int n2 = element2.getInt("id");
                int n3 = element2.getInt("ownerId");
                Date date2 = this.formater.parse(element2.getString("creation"));
                hashMap4.put(n2, date2);
                Element element3 = this.api.getUser(n3, 5);
                hashMap3.put(n2, element3.getString("email"));
                hashMap2.put(n2, element2);
            }
            HashMap<Integer, Integer> hashMap5 = new HashMap<Integer, Integer>();
            FiltersEvents filtersEvents = new FiltersEvents();
            filtersEvents.addFilterActivities(new ArrayList(hashMap3.keySet()));
            Element element4 = this.api.getEvents(filtersEvents, 8);
            for (Element element5 : element4.getChildrenArray()) {
                int n4 = element5.getInt("activityId");
                Date date3 = null;
                date3 = bl ? date : (Date)hashMap4.get(n4);
                if (this.isAutomaticalyValidate(element5, date3)) continue;
                Element element6 = this.calendar.getDate(date);
                int n5 = element6.getChild("week").getInt("id");
                int n6 = element6.getChild("day").getInt("id");
                int n7 = element5.getInt("id");
                if (bl) {
                    hashMap.put(n7, (String)hashMap3.get(n4));
                    this.addWaitingConfirmStatus((Element)hashMap2.get(n4), element5, hashMap5);
                    continue;
                }
                int n8 = element5.getInt("week");
                int n9 = element5.getInt("day");
                if (n8 != n5 || n9 != n6) continue;
                hashMap.put(n7, (String)hashMap3.get(n4));
                this.addWaitingConfirmStatus((Element)hashMap2.get(n4), element5, hashMap5);
            }
        }
        return hashMap;
    }

    private boolean isAutomaticalyValidate(Element element, Date date) throws RemoteException, ProjectNotFoundException {
        this.cal.setTime(date);
        this.cal.add(5, this.delayAutoValidation);
        this.cal.set(11, 23);
        this.cal.set(12, 59);
        this.cal.set(13, 59);
        Date date2 = this.cal.getTime();
        int n = element.getInt("week");
        int n2 = element.getInt("day");
        int n3 = element.getInt("slot");
        Date date3 = this.calendar.getDate(n, n2, n3);
        return date3.before(date2);
    }

    private int getBookingResource() throws Exception {
        Element element = ConfigManager.getInstance().readXmlFile("CategoryBooking").getChild("booking");
        String string = element.getString("category").toLowerCase();
        String string2 = element.getString("field");
        String string3 = element.getString("value");
        FiltersResources filtersResources = new FiltersResources();
        filtersResources.addFilterCategory(string);
        filtersResources.addFilterFields(string2, "equals", string3);
        Element element2 = this.api.getResources(filtersResources, 1);
        if (element2.hasChildren()) {
            return element2.getChildrenArray()[0].getInt("id");
        }
        return -1;
    }

    private String getTemplateConfirmation(String string, int n) {
        String string2 = this.cm.getProperty(ServerProperty.WEB_SERVER);
        string2 = string2 + "custom/modules/confirmation/confirmation.jsp?projectId=";
        string2 = string2 + this.api.getProjectId();
        string2 = string2 + "&eventId=";
        string2 = string2 + n;
        String string3 = this.cm.readHtmlFile(string, Locale.FRENCH);
        string3 = string3.replace("#URL#", string2);
        return string3;
    }

    private void addWaitingConfirmStatus(Element element, Element element2, HashMap<Integer, Integer> hashMap) throws RemoteException, AdeException, EntityGroupError, SQLException {
        Element element3;
        int n = element.getInt("id");
        Integer n2 = hashMap.get(n);
        if (null == n2) {
            for (Element element4 : element.getChild("resources").getChildrenArray("or")) {
                int n3 = 0;
                for (Element element5 : element4.getChildrenArray("and")) {
                    int n4 = element5.getInt("id");
                    if (n4 != this.waitingConfirmationResourceId && n4 != this.confirmationResourceId) continue;
                    ++n3;
                }
                if (n3 != 2) continue;
                n2 = element4.getInt("id");
                hashMap.put(n, n2);
                break;
            }
        }
        Element[] elementArray = new AdeList();
        for (Element element6 : element2.getChild("resources").getChildrenArray()) {
            int n5 = element6.getInt("id");
            if (n5 == this.confirmationResourceId || n5 == this.waitingConfirmationResourceId) continue;
            elementArray.add(n5);
        }
        if (null == n2) {
            n2 = this.api.addActivityChoosenResource(n, this.waitingConfirmationResourceId);
            hashMap.put(n, n2);
            this.api.addActivityResource(n, this.confirmationResourceId, n2);
            element3 = this.calendar.getDate(new Date());
            int n6 = element3.getChild("week").getInt("id");
            int n7 = element3.getChild("day").getInt("id");
            FiltersEvents filtersEvents = new FiltersEvents();
            filtersEvents.addFilterActivities(Arrays.asList(n));
            Element element7 = this.api.getEvents(filtersEvents, 3);
            for (Element element8 : element7.getChildrenArray()) {
                if (element8.getInt("id") != element2.getInt("id")) {
                    int n8 = element8.getInt("week");
                    int n9 = element8.getInt("day");
                    if (n8 < n6 || n8 == n6 && n9 < n7) {
                        elementArray.add(this.waitingConfirmationResourceId);
                    } else if (n8 > n6 || n8 == n6 && n9 > n7) {
                        elementArray.add(this.confirmationResourceId);
                    }
                }
                EventSettings eventSettings = new EventSettings(element8.getInt("id"));
                this.api.placeEvent(eventSettings, element8.getInt("week"), element8.getInt("day"), element8.getInt("slot"), (AdeList)elementArray);
            }
        }
        elementArray.add(this.waitingConfirmationResourceId);
        element3 = new EventSettings(element2.getInt("id"));
        this.api.placeEvent((EventSettings)element3, element2.getInt("week"), element2.getInt("day"), element2.getInt("slot"), (AdeList)elementArray);
    }

    public String confirm(HttpServletRequest httpServletRequest) {
        try {
            ConfigManager configManager = ConfigManager.getInstance();
            configManager.readKeywords("Keywords", Locale.getDefault());
            TreeMap treeMap = configManager.readProperties("Mails");
            String string = (String)treeMap.get("login");
            String string2 = (String)treeMap.get("password");
            int n = Integer.parseInt(httpServletRequest.getParameter("projectId"));
            int n2 = Integer.parseInt(httpServletRequest.getParameter("eventId"));
            AdeApi6 adeApi6 = new AdeApi6();
            adeApi6.setLogin(string);
            adeApi6.setPassword(string2);
            adeApi6.setProjectId(n);
            this.initConfirmationIds(adeApi6, treeMap);
            AdeList adeList = new AdeList();
            EventSettings eventSettings = new EventSettings(n2);
            Element element = adeApi6.getEventById(eventSettings, 8);
            for (Element element2 : element.getChild("resources").getChildrenArray()) {
                int n3 = element2.getInt("id");
                if (n3 == this.waitingConfirmationResourceId || n3 == this.confirmationResourceId) continue;
                adeList.add(n3);
            }
            adeList.add(this.confirmationResourceId);
            adeApi6.placeEvent(eventSettings, element.getInt("week"), element.getInt("day"), element.getInt("slot"), adeList);
            return adeApi6.parseTemplate(eventSettings, "Confirmation");
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
            return null;
        }
    }

    public static void main(String[] stringArray) {
        MailConfirmationSender mailConfirmationSender = new MailConfirmationSender();
        AdeApi adeApi = new AdeApi();
        adeApi.setLogin("root");
        adeApi.setPassword("");
        adeApi.setProjectId(3);
        CalendarBean calendarBean = new CalendarBean();
        mailConfirmationSender.start(adeApi, null, calendarBean, -1, -1L, null, null);
    }
}

