/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.engine;

import com.adesoft.log.Category;
import com.dautelle.xml.sax.Attributes;
import com.dautelle.xml.sax.ContentHandler;
import com.dautelle.xml.sax.DefaultHandler;
import com.dautelle.xml.sax.RealtimeParser;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractXmlReader
extends DefaultHandler {
    private static final Category LOG = Category.getInstance((String)"com.adesoft.optim.AbstractXmlReader");
    private final RealtimeParser parser = new RealtimeParser();

    protected AbstractXmlReader() {
        this.parser.setContentHandler((ContentHandler)this);
        this.parser.setErrorHandler((ErrorHandler)((Object)this));
    }

    public void endElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        try {
            this.endSax(charSequence3);
        }
        catch (Throwable throwable) {
            if (null == throwable.getMessage()) {
                throw new RuntimeException("SAX parse error on closing </" + charSequence3 + ">\n" + throwable);
            }
            throw new RuntimeException("SAX parse error on closing </" + charSequence3 + ">\n" + throwable.getMessage());
        }
    }

    public void startElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, Attributes attributes) {
        try {
            this.sax(charSequence3, attributes);
        }
        catch (Throwable throwable) {
            if (null == throwable.getMessage()) {
                throw new RuntimeException("SAX parse error on  <" + charSequence3 + ">\n" + throwable);
            }
            throw new RuntimeException("SAX parse error on  <" + charSequence3 + ">\n" + throwable.getMessage());
        }
    }

    public final void read(Reader reader) throws Exception {
        this.read(new InputSource(reader));
    }

    public final void read(InputStream inputStream) throws Exception {
        this.read(new InputSource(inputStream));
    }

    public final void read(InputSource inputSource) throws Exception {
        try {
            inputSource.setEncoding("UTF-8");
            this.parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            String string = sAXException.getMessage();
            LOG.error((Object)"SAX Error : ");
            LOG.error((Object)(" - message : " + string));
            LOG.error((Object)(" - nested : " + exception));
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(string);
        }
    }

    protected abstract void sax(CharSequence var1, Attributes var2) throws Exception;

    protected abstract void endSax(CharSequence var1) throws Exception;
}

