/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

final class BufferCompatible {
    private static final String DELIMITER_VALUES = ";";
    private static final boolean BOOLEAN_ERROR = false;
    private static final int NUMBER_ERROR = -99996;
    private final HashMap map;

    public BufferCompatible(String string) {
        this.map = this.parse(string);
    }

    private HashMap getMap() {
        return this.map;
    }

    public Iterator keys() {
        return this.getMap().keySet().iterator();
    }

    private HashMap parse(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (null != string && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER_VALUES);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf("=");
                if (-1 == n) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                hashMap.put(string3, string4);
            }
        }
        return hashMap;
    }

    public String getValue(String string) {
        return (String)this.getMap().get(string);
    }

    public String getValue(String string, String string2) {
        String string3 = this.getValue(string);
        if (null == string3) {
            return string2;
        }
        return string3;
    }

    public double getDouble(String string, double d) {
        try {
            return Double.parseDouble(this.getValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            return -99996.0;
        }
        catch (Exception exception) {
            return d;
        }
    }

    public float getFloat(String string, float f) {
        try {
            return Float.parseFloat(this.getValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            return -99996.0f;
        }
        catch (Exception exception) {
            return f;
        }
    }

    public int getInt(String string, int n) {
        try {
            return Integer.parseInt(this.getValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            return -99996;
        }
        catch (Exception exception) {
            return n;
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getValue(string);
        try {
            return string2 != null && string2.equalsIgnoreCase("true");
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        catch (Exception exception) {
            return bl;
        }
    }
}

