/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.engine;

import com.adesoft.engine.info.DaraInfo;
import com.adesoft.errors.AdeException;
import com.adesoft.errors.AdeXmlEngineException;
import com.adesoft.errors.EngineLicenceException;
import com.adesoft.errors.EngineNotFound;
import com.adesoft.info.Info;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.SQLException;

public interface Engine
extends Remote {
    public static final String DEFAULT_ENGINE_HOST = "127.0.0.1";
    public static final int DEFAULT_ENGINE_PORT = 12345;
    public static final int NSTEP = 28;
    public static final int NCONVERT = 12;
    public static final int CONVERT = 25;
    public static final int NONE = -1;
    public static final int NO_STATUS = 1;
    public static final int SET = 2;
    public static final int NOT_SET = 3;
    public static final int UN_SET = 4;
    public static final int NO_PLACE = 5;
    public static final int NO_ROOM_LEFT = 6;
    public static final int DO_NOT_MOVE = 7;
    public static final int NO_RESSOURCE_LEFT = 8;
    public static final int INVALID_DATA = 0;
    public static final int NOT_INITED = 1;
    public static final int NO_SOLUTION = 2;
    public static final int PARTIAL_SOLUTION = 3;
    public static final int COMPLETE_SOLUTION = 4;
    public static final int OPTIM_SOLUTION = 5;

    public boolean init() throws RemoteException, AdeException, IOException;

    public boolean step(int var1) throws RemoteException, AdeException, IOException;

    public void closeTransaction(boolean var1) throws RemoteException, SQLException, AdeException, IOException;

    public void delete() throws RemoteException;

    public byte[] getErrorElements() throws AdeXmlEngineException, IOException, EngineNotFound, EngineLicenceException;

    public byte[] getStats() throws AdeXmlEngineException, IOException, EngineNotFound, EngineLicenceException;

    public byte[] getInfo() throws AdeXmlEngineException, IOException, EngineNotFound, EngineLicenceException;

    public DaraInfo[] getAllDaraInfo() throws RemoteException, AdeXmlEngineException, IOException;

    public void getTimetable() throws AdeException, RemoteException, SQLException, IOException;

    public void pauseEngine() throws Exception, AdeException, IOException;

    public void restoreSavedSolution() throws RemoteException, AdeException, IOException;

    public void resumeEngine() throws Exception, AdeException, IOException;

    public void stopEngine() throws RemoteException, AdeException, IOException, EngineLicenceException;

    public void fullDara() throws Exception, AdeException, IOException;

    public void fullSa() throws Exception, AdeException, IOException;

    public void fullQuality() throws Exception, AdeException, IOException;

    public Info getInfoByRid(int var1) throws RemoteException;
}

