/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.engine;

import com.adesoft.collections.IntHashMap;
import com.adesoft.collections.MyHashTable;
import com.adesoft.engine.BufferCompatible;
import com.adesoft.log.Category;
import com.adesoft.struct.CostWeights;
import com.adesoft.struct.configurations.Configuration;
import com.adesoft.struct.configurations.ConfigurationIO;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class EngineOptions
extends ConfigurationIO
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final Category LOG = Category.getInstance((String)"com.adesoft.engine.EngineOptions");
    private static final int DEFAULT_OPTIM_VALUE = 0;
    private static final String EQUAL_HEURISTICS = ":";
    private static final String DELIMITER_HEURISTICS = "#";
    public static final String ENGINE_CLEAR_SCHEDULE = "EngineClearSchedule";
    public static final String ENGINE_HOST = "EngineHost";
    public static final String ENGINE_PORT = "EnginePort";
    public static final String ENGINE_LOCK_DATES = "EngineLockDates";
    public static final String ENGINE_LOCK_RESOURCES = "EngineLockResources";
    public static final String ENGINE_RUN_DARA = "EngineRunDara";
    public static final String ENGINE_RUN_OPTIM_COSTS = "EngineRunOptimCosts";
    public static final String ENGINE_RUN_OPTIM_SITES = "EngineRunOptimSites";
    public static final String ENGINE_RUN_OPTIM_QUALITY = "EngineRunQuality";
    public static final String ENGINE_SEED = "EngineSeed";
    public static final String ENGINE_FIELD = "EngineField";
    public static final String ENGINE_USE_CONTINUITY = "EngineUseContinuity";
    public static final String ENGINE_USE_COUNTERS = "EngineUseCounters";
    public static final String ENGINE_FIRST_WEEK = "EngineFirstWeek";
    public static final String ENGINE_LAST_WEEK = "EngineLastWeek";
    public static final String ENGINE_PARTIAL = "EnginePartial";
    public static final String ENGINE_REMOVE_VIRTUAL = "EngineRemoveVirtual";
    public static final String ENGINE_DARA_HEURISTIC = "EngineDaraHeuristic";
    public static final String ENGINE_REALLOCATION_HEURISTIC = "EngineReallocationHeuristic";
    public static final String ENGINE_RESOURCE_EXHAUSTIVE = "EngineResourceExhaustive";
    public static final String ENGINE_MIN_GAP_SIZE = "EngineMinGapSize";
    public static final String ENGINE_MAX_GAP_SIZE = "EngineMaxGapSize";
    public static final String ENGINE_QUALITY_WEIGHT = "EngineQualityWeight";
    public static final String ENGINE_QUALITY_ITERATIONS = "EngineQualityIterations";
    public static final String ENGINE_OPTIMIZATION_HEURISTICS = "EngineOptimizationHeuristics";
    public static final String ENGINE_STAGE_MAX = "EngineStageMax";
    public static final String ENGINE_ITERATION_MAX = "EngineIterationMax";
    public static final String ENGINE_TEMPERATURE = "EngineTemperature";
    public static final String ENGINE_IMPROVEMENT_ITERATION = "EngineImprovementIteration";
    public static final String ENGINE_DEFAULT_DARA = "EngineDefaultDara";
    public static final String ENGINE_DEFAULT_OPTIM = "EngineDefaultOptim";
    public static final String ENGINE_DEFAULT_QUALITY = "EngineDefaultQuality";
    public static final String ENGINE_USE_COURSE_TF = "EngineUseCourseTF";
    public static final String ENGINE_USE_ENTITY_TF = "EngineUseEntityTF";
    public static final String ENGINE_USE_COSTS = "EngineUseCosts";
    public static final String ENGINE_USE_SITES = "EngineUseSites";
    public static final String ENGINE_SEND_LUNCH = "EngineSendLunch";
    public static final String ENGINE_WEEK_LOOK_AHEAD = "EngineWeekLookAhead";
    public static final String ENGINE_MAX_STATS = "EngineMaxStats";
    public static final String ENGINE_INFO_MODE_SMALL = "EngineInfoModeSmall";
    public static final String ENGINE_INFO_MODE_MEDIUM = "EngineInfoModeMedium";
    public static final String ENGINE_INFO_MODE_LARGE = "EngineInfoModeLarge";
    private boolean clearSchedule;
    private boolean lockDates;
    private boolean lockResources;
    private boolean runDara;
    private boolean defaultDaraParam;
    private boolean runOptimCosts;
    private boolean runOptimSites;
    private boolean defaultOptimParam;
    private boolean runOptimQuality;
    private boolean defaultQualityParam;
    private boolean useCounters;
    private boolean useContinuity;
    private int seed;
    private String engineHost;
    private String enginePort;
    private double coolingCoeff;
    private int stageMax;
    private double temperature;
    private int iterationMax;
    private int[] partialOids;
    private int firstWeek;
    private int lastWeek;
    private boolean partial;
    private boolean removeVirtual;
    private String moreField;
    private int qualityMinGap;
    private int qualityMaxGap;
    private float qualityWeight;
    private int qualityIterations;
    private int scheduleDaraHeuristic;
    private int scheduleAllocationHeuristic;
    private int scheduleSearchSpeed;
    private IntHashMap optimValues;
    private int improvementIteration;
    private boolean isUseCourseTF;
    private boolean isUseEntityTF;
    private boolean isUseCosts;
    private boolean isUseSites;
    private boolean isSendLunch;
    private int weekLookAhead;
    private int maxStats;
    private boolean useInfoMedium;
    private boolean useInfoLarge;
    private boolean useInfoSmall;
    private CostWeights weights = new CostWeights();

    public EngineOptions() {
    }

    public EngineOptions(Configuration configuration) {
        this();
        this.parseConfiguration(configuration);
    }

    public boolean isRunOptim() {
        return this.isRunOptimCosts();
    }

    public void clearOptimHeuristics() {
        this.getOptimValues().clear();
    }

    public void setOptimHeuristicsBuffer(String string) {
        this.clearOptimHeuristics();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER_HEURISTICS);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(EQUAL_HEURISTICS);
            if (-1 == n) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            int n2 = Integer.parseInt(string4);
            this.getOptimValues().set((Object)string3, n2);
        }
    }

    public String getOptimHeuristicsBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.getOptimValues().allKeys();
        if (null != list && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                int n = this.getOptimValues().get((Object)string);
                if (i != 0) {
                    stringBuffer.append(DELIMITER_HEURISTICS);
                }
                stringBuffer.append(string + EQUAL_HEURISTICS + n);
            }
        }
        return stringBuffer.toString();
    }

    public IntHashMap getOptimValues() {
        if (null == this.optimValues) {
            this.optimValues = new IntHashMap();
        }
        return this.optimValues;
    }

    public int getOptimValueOf(String string) {
        int n = this.getOptimValues().get((Object)string);
        if (-1 == n) {
            n = 0;
        }
        return n;
    }

    public void setOptimValueOf(String string, int n) {
        this.getOptimValues().set((Object)string, n);
    }

    public int getScheduleDaraHeuristic() {
        return this.scheduleDaraHeuristic;
    }

    public void setImprovementIteration(int n) {
        this.improvementIteration = n;
    }

    public int getImprovementIteration() {
        return this.improvementIteration;
    }

    public void setScheduleDaraHeuristic(int n) {
        this.scheduleDaraHeuristic = n;
    }

    public int getScheduleAllocationHeuristic() {
        return this.scheduleAllocationHeuristic;
    }

    public void setScheduleAllocationHeuristic(int n) {
        this.scheduleAllocationHeuristic = n;
    }

    public int getScheduleSearchSpeed() {
        return this.scheduleSearchSpeed;
    }

    public void setScheduleSearchSpeed(int n) {
        this.scheduleSearchSpeed = n;
    }

    public int getQualityMinGap() {
        return this.qualityMinGap;
    }

    public void setQualityMinGap(int n) {
        this.qualityMinGap = n;
    }

    public int getQualityMaxGap() {
        return this.qualityMaxGap;
    }

    public void setQualityMaxGap(int n) {
        this.qualityMaxGap = n;
    }

    public float getQualityWeight() {
        return this.qualityWeight;
    }

    public void setQualityWeight(float f) {
        this.qualityWeight = f;
    }

    public int getQualityIterations() {
        return this.qualityIterations;
    }

    public void setQualityIterations(int n) {
        this.qualityIterations = n;
    }

    public double getCoolingCoeff() {
        return this.coolingCoeff;
    }

    public int[] getPartialOids() {
        return this.partialOids;
    }

    public String getEngineHost() {
        return this.engineHost;
    }

    public String getEnginePort() {
        return this.enginePort;
    }

    public int getFirstWeek() {
        return this.firstWeek;
    }

    public int getIterationMax() {
        return this.iterationMax;
    }

    public int getLastWeek() {
        return this.lastWeek;
    }

    public int getSeed() {
        return this.seed;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public int getStageMax() {
        return this.stageMax;
    }

    public boolean isClearSchedule() {
        return this.clearSchedule;
    }

    public boolean isLockDates() {
        return this.lockDates;
    }

    public boolean isLockResources() {
        return this.lockResources;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public boolean isRemoveVirtual() {
        return this.removeVirtual;
    }

    public boolean isRunDara() {
        return this.runDara;
    }

    public boolean isRunOptimCosts() {
        return this.runOptimCosts;
    }

    public boolean isRunOptimSites() {
        return this.runOptimSites;
    }

    public boolean isRunOptimQuality() {
        return this.runOptimQuality;
    }

    public void setClearSchedule(boolean bl) {
        this.clearSchedule = bl;
    }

    public void setCoolingCoeff(double d) {
        this.coolingCoeff = d;
    }

    public void setPartialOids(int[] nArray) {
        this.partialOids = nArray;
    }

    public boolean isUseInfoLarge() {
        return this.useInfoLarge;
    }

    public boolean isUseInfoMedium() {
        return this.useInfoMedium;
    }

    public boolean isUseInfoSmall() {
        return this.useInfoSmall;
    }

    public void setUseInfoLarge(boolean bl) {
        this.useInfoLarge = bl;
    }

    public void setUseInfoMedium(boolean bl) {
        this.useInfoMedium = bl;
    }

    public void setUseInfoSmall(boolean bl) {
        this.useInfoSmall = bl;
    }

    public void setMaxStats(int n) {
        this.maxStats = n;
    }

    public int getMaxStats() {
        return this.maxStats;
    }

    @Override
    public void setDefaultValues() {
        this.useCounters = true;
        this.useContinuity = true;
        this.seed = 0;
        this.weights = new CostWeights();
        this.coolingCoeff = 0.95;
        this.stageMax = 100;
        this.temperature = 15.0;
        this.iterationMax = 100;
        this.clearSchedule = true;
        this.lockDates = false;
        this.lockResources = false;
        this.runDara = true;
        this.runOptimCosts = false;
        this.runOptimSites = false;
        this.runOptimQuality = false;
        this.engineHost = "";
        this.enginePort = "";
        this.moreField = "";
        this.qualityMinGap = 1;
        this.qualityMaxGap = 2;
        this.qualityWeight = 1.0f;
        this.qualityIterations = 5;
        this.scheduleDaraHeuristic = 0;
        this.scheduleAllocationHeuristic = 0;
        this.scheduleSearchSpeed = 50;
        this.optimValues = null;
        this.improvementIteration = 100;
        this.isUseCourseTF = true;
        this.isUseEntityTF = true;
        this.isUseCosts = true;
        this.isUseSites = true;
        this.isSendLunch = true;
        this.weekLookAhead = 0;
        this.maxStats = 5;
        this.useInfoMedium = false;
        this.useInfoLarge = false;
        this.useInfoSmall = true;
    }

    public void setEngineHost(String string) {
        this.engineHost = string;
    }

    public void setEnginePort(String string) {
        this.enginePort = string;
    }

    public void setFirstWeek(int n) {
        this.firstWeek = n;
    }

    public void setIterationMax(int n) {
        this.iterationMax = n;
    }

    public void setLastWeek(int n) {
        this.lastWeek = n;
    }

    public void setLockDates(boolean bl) {
        this.lockDates = bl;
    }

    public void setLockResources(boolean bl) {
        this.lockResources = bl;
    }

    public void setPartial(boolean bl) {
        this.partial = bl;
    }

    public void setRemoveVirtual(boolean bl) {
        this.removeVirtual = bl;
    }

    public void setRunDara(boolean bl) {
        this.runDara = bl;
    }

    public void setRunOptimCosts(boolean bl) {
        this.runOptimCosts = bl;
    }

    public void setRunOptimSites(boolean bl) {
        this.runOptimSites = bl;
    }

    public void setRunOptimQuality(boolean bl) {
        this.runOptimQuality = bl;
    }

    public void setSeed(int n) {
        this.seed = n;
    }

    public void setTemperature(double d) {
        this.temperature = d;
    }

    public void setStageMax(int n) {
        this.stageMax = n;
    }

    public void setUseContinuity(boolean bl) {
        this.useContinuity = bl;
    }

    public void setUseCounters(boolean bl) {
        this.useCounters = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ClearSchedule : ");
        stringBuffer.append(this.clearSchedule);
        stringBuffer.append("\nLockDates : ");
        stringBuffer.append(this.lockDates);
        stringBuffer.append("\nLockResources : ");
        stringBuffer.append(this.lockResources);
        stringBuffer.append("\nRunDara : ");
        stringBuffer.append(this.runDara);
        stringBuffer.append("\nRunOptimCosts : ");
        stringBuffer.append(this.runOptimCosts);
        stringBuffer.append("\nRunOptimSites : ");
        stringBuffer.append(this.runOptimSites);
        stringBuffer.append("\nRunOptimQuality : ");
        stringBuffer.append(this.runOptimQuality);
        stringBuffer.append("\nUseCounters : ");
        stringBuffer.append(this.useCounters);
        stringBuffer.append("\nUseContinuity : ");
        stringBuffer.append(this.useContinuity);
        stringBuffer.append("\nSeed : ");
        stringBuffer.append(this.seed);
        stringBuffer.append("\nCoolingCoeff : ");
        stringBuffer.append(this.coolingCoeff);
        stringBuffer.append("\nStageMax : ");
        stringBuffer.append(this.stageMax);
        stringBuffer.append("\nTemperature : ");
        stringBuffer.append(this.temperature);
        stringBuffer.append("\nIterationMax : ");
        stringBuffer.append(this.iterationMax);
        stringBuffer.append("\nFirstWeek : ");
        stringBuffer.append(this.firstWeek);
        stringBuffer.append("\nLastWeek : ");
        stringBuffer.append(this.lastWeek);
        stringBuffer.append("\nPartial : ");
        stringBuffer.append(this.partial);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean useContinuity() {
        return this.useContinuity;
    }

    public boolean useCounters() {
        return this.useCounters;
    }

    public String getMoreField() {
        return this.moreField;
    }

    public void setMoreField(String string) {
        if (null == string) {
            this.moreField = "";
        } else {
            this.moreField = string;
            if (0 != this.moreField.length() && !this.moreField.endsWith(";")) {
                this.moreField = this.moreField + ";";
            }
        }
    }

    public boolean isDefaultDaraParam() {
        return this.defaultDaraParam;
    }

    public boolean isDefaultOptimParam() {
        return this.defaultOptimParam;
    }

    public boolean isDefaultQualityParam() {
        return this.defaultQualityParam;
    }

    public void setDefaultDaraParam(boolean bl) {
        this.defaultDaraParam = bl;
    }

    public void setDefaultOptimParam(boolean bl) {
        this.defaultOptimParam = bl;
    }

    public void setDefaultQualityParam(boolean bl) {
        this.defaultQualityParam = bl;
    }

    @Override
    protected Element getXml() {
        Element element = new Element("enginesettings");
        element.addAttribute(ENGINE_CLEAR_SCHEDULE, this.isClearSchedule());
        element.addAttribute(ENGINE_LOCK_DATES, this.isLockDates());
        element.addAttribute(ENGINE_LOCK_RESOURCES, this.isLockResources());
        element.addAttribute(ENGINE_RUN_DARA, this.isRunDara());
        element.addAttribute(ENGINE_RUN_OPTIM_COSTS, this.isRunOptimCosts());
        element.addAttribute(ENGINE_RUN_OPTIM_SITES, this.isRunOptimSites());
        element.addAttribute(ENGINE_RUN_OPTIM_QUALITY, this.isRunOptimQuality());
        element.addAttribute(ENGINE_HOST, this.getEngineHost());
        element.addAttribute(ENGINE_PORT, this.getEnginePort());
        element.addAttribute(ENGINE_FIELD, this.getMoreField());
        element.addAttribute(ENGINE_FIRST_WEEK, Integer.toString(this.getFirstWeek()));
        element.addAttribute(ENGINE_LAST_WEEK, Integer.toString(this.getLastWeek()));
        element.addAttribute(ENGINE_PARTIAL, this.isPartial());
        element.addAttribute(ENGINE_REMOVE_VIRTUAL, this.isRemoveVirtual());
        element.addAttribute(ENGINE_DEFAULT_DARA, this.isDefaultDaraParam());
        element.addAttribute(ENGINE_DARA_HEURISTIC, Integer.toString(this.getScheduleDaraHeuristic()));
        element.addAttribute(ENGINE_REALLOCATION_HEURISTIC, Integer.toString(this.getScheduleAllocationHeuristic()));
        element.addAttribute(ENGINE_RESOURCE_EXHAUSTIVE, Integer.toString(this.getScheduleSearchSpeed()));
        element.addAttribute(ENGINE_DEFAULT_QUALITY, this.isDefaultQualityParam());
        element.addAttribute(ENGINE_MIN_GAP_SIZE, Integer.toString(this.getQualityMinGap()));
        element.addAttribute(ENGINE_MAX_GAP_SIZE, Integer.toString(this.getQualityMaxGap()));
        element.addAttribute(ENGINE_QUALITY_WEIGHT, Float.toString(this.getQualityWeight()));
        element.addAttribute(ENGINE_QUALITY_ITERATIONS, Integer.toString(this.getQualityIterations()));
        element.addAttribute(ENGINE_OPTIMIZATION_HEURISTICS, this.getOptimHeuristicsBuffer());
        element.addAttribute(ENGINE_DEFAULT_OPTIM, this.isDefaultOptimParam());
        element.addAttribute(ENGINE_STAGE_MAX, Integer.toString(this.getStageMax()));
        element.addAttribute(ENGINE_ITERATION_MAX, Integer.toString(this.getIterationMax()));
        element.addAttribute(ENGINE_TEMPERATURE, Double.toString(this.getTemperature()));
        element.addAttribute(ENGINE_IMPROVEMENT_ITERATION, Integer.toString(this.getImprovementIteration()));
        element.addAttribute(ENGINE_USE_COURSE_TF, this.isUseCourseTF());
        element.addAttribute(ENGINE_USE_ENTITY_TF, this.isUseEntityTF());
        element.addAttribute(ENGINE_USE_COSTS, this.isUseEntityCosts());
        element.addAttribute(ENGINE_USE_SITES, this.isUseEntitySites());
        element.addAttribute(ENGINE_SEND_LUNCH, this.isSendLunch());
        element.addAttribute(ENGINE_WEEK_LOOK_AHEAD, Integer.toString(this.getWeekLookAhead()));
        element.addAttribute(ENGINE_SEED, this.getSeed());
        element.addAttribute(ENGINE_USE_CONTINUITY, this.useContinuity());
        element.addAttribute(ENGINE_USE_COUNTERS, this.useCounters());
        element.addAttribute(ENGINE_INFO_MODE_LARGE, this.isUseInfoLarge());
        element.addAttribute(ENGINE_INFO_MODE_MEDIUM, this.isUseInfoMedium());
        element.addAttribute(ENGINE_INFO_MODE_SMALL, this.isUseInfoSmall());
        element.addAttribute(ENGINE_MAX_STATS, this.getMaxStats());
        element.addChild(this.getWeights().getXml());
        return element;
    }

    public boolean isUseCourseTF() {
        return this.isUseCourseTF;
    }

    public boolean isUseEntityTF() {
        return this.isUseEntityTF;
    }

    public boolean isUseEntityCosts() {
        return this.isUseCosts;
    }

    public boolean isUseEntitySites() {
        return this.isUseSites;
    }

    public boolean isSendLunch() {
        return this.isSendLunch;
    }

    public void setUseCourseTF(boolean bl) {
        this.isUseCourseTF = bl;
    }

    public void setUseEntityTF(boolean bl) {
        this.isUseEntityTF = bl;
    }

    public void setUseEntityCosts(boolean bl) {
        this.isUseCosts = bl;
    }

    public void setUseEntitySites(boolean bl) {
        this.isUseSites = bl;
    }

    public void setSendLunch(boolean bl) {
        this.isSendLunch = bl;
    }

    public int getWeekLookAhead() {
        return this.weekLookAhead;
    }

    public void setWeekLookAhead(int n) {
        this.weekLookAhead = n;
    }

    public CostWeights getWeights() {
        return this.weights;
    }

    public void setWeights(CostWeights costWeights) {
        this.weights = costWeights;
    }

    public void setWeights(MyHashTable myHashTable, double d) {
        this.weights.setValues(myHashTable, d);
    }

    public void parseConfiguration(Configuration configuration) {
        if (null == configuration) {
            return;
        }
        String string = configuration.getBuffer();
        this.setDefaultValues();
        if (0 != string.length()) {
            try {
                Document document = new SAXBuilder().build((Reader)new StringReader(string));
                Element element = document.getRootElement();
                this.parseXml(element);
            }
            catch (JDOMException jDOMException) {
                this.parseBuffer(string);
            }
        }
    }

    private void parseXml(Element element) {
        this.setClearSchedule(element.getBoolean(ENGINE_CLEAR_SCHEDULE, this.isClearSchedule()));
        this.setLockDates(element.getBoolean(ENGINE_LOCK_DATES, this.isLockDates()));
        this.setLockResources(element.getBoolean(ENGINE_LOCK_RESOURCES, this.isLockResources()));
        this.setRunDara(element.getBoolean(ENGINE_RUN_DARA, this.isRunDara()));
        this.setRunOptimCosts(element.getBoolean(ENGINE_RUN_OPTIM_COSTS, this.isRunOptimCosts()));
        this.setRunOptimSites(element.getBoolean(ENGINE_RUN_OPTIM_SITES, this.isRunOptimSites()));
        this.setRunOptimQuality(element.getBoolean(ENGINE_RUN_OPTIM_QUALITY, this.isRunOptimQuality()));
        this.setEngineHost(element.getString(ENGINE_HOST, this.getEngineHost()));
        this.setEnginePort(element.getString(ENGINE_PORT, this.getEnginePort()));
        this.setMoreField(element.getString(ENGINE_FIELD, this.getMoreField()));
        this.setFirstWeek(element.getInt(ENGINE_FIRST_WEEK, this.getFirstWeek()));
        this.setLastWeek(element.getInt(ENGINE_LAST_WEEK, this.getLastWeek()));
        this.setPartial(element.getBoolean(ENGINE_PARTIAL, this.isPartial()));
        this.setRemoveVirtual(element.getBoolean(ENGINE_REMOVE_VIRTUAL, this.isRemoveVirtual()));
        this.setDefaultDaraParam(element.getBoolean(ENGINE_DEFAULT_DARA, this.isDefaultDaraParam()));
        this.setScheduleDaraHeuristic(element.getInt(ENGINE_DARA_HEURISTIC, this.getScheduleDaraHeuristic()));
        this.setScheduleAllocationHeuristic(element.getInt(ENGINE_REALLOCATION_HEURISTIC, this.getScheduleAllocationHeuristic()));
        this.setScheduleSearchSpeed(element.getInt(ENGINE_RESOURCE_EXHAUSTIVE, this.getScheduleSearchSpeed()));
        this.setDefaultQualityParam(element.getBoolean(ENGINE_DEFAULT_QUALITY, this.isDefaultQualityParam()));
        this.setQualityMinGap(element.getInt(ENGINE_MIN_GAP_SIZE, this.getQualityMinGap()));
        this.setQualityMaxGap(element.getInt(ENGINE_MAX_GAP_SIZE, this.getQualityMaxGap()));
        this.setQualityWeight((float)element.getDouble(ENGINE_QUALITY_WEIGHT, (double)this.getQualityWeight()));
        this.setQualityIterations(element.getInt(ENGINE_QUALITY_ITERATIONS, this.getQualityIterations()));
        this.setOptimHeuristicsBuffer(element.getAttribute(ENGINE_OPTIMIZATION_HEURISTICS).getValue());
        this.setDefaultOptimParam(element.getBoolean(ENGINE_DEFAULT_OPTIM, this.isDefaultOptimParam()));
        this.setStageMax(element.getInt(ENGINE_STAGE_MAX, this.getStageMax()));
        this.setIterationMax(element.getInt(ENGINE_ITERATION_MAX, this.getIterationMax()));
        this.setTemperature(element.getDouble(ENGINE_TEMPERATURE, this.getTemperature()));
        this.setImprovementIteration(element.getInt(ENGINE_IMPROVEMENT_ITERATION, this.getImprovementIteration()));
        this.setUseCourseTF(element.getBoolean(ENGINE_USE_COURSE_TF, this.isUseCourseTF()));
        this.setUseEntityTF(element.getBoolean(ENGINE_USE_ENTITY_TF, this.isUseEntityTF()));
        this.setUseEntityCosts(element.getBoolean(ENGINE_USE_COSTS, this.isUseEntityCosts()));
        this.setUseEntitySites(element.getBoolean(ENGINE_USE_SITES, this.isUseEntitySites()));
        this.setSendLunch(element.getBoolean(ENGINE_SEND_LUNCH, this.isSendLunch()));
        this.setWeekLookAhead(element.getInt(ENGINE_WEEK_LOOK_AHEAD, this.getWeekLookAhead()));
        this.setSeed(element.getInt(ENGINE_SEED, this.getSeed()));
        this.setUseContinuity(element.getBoolean(ENGINE_USE_CONTINUITY, this.useContinuity()));
        this.setUseCounters(element.getBoolean(ENGINE_USE_COUNTERS, this.useCounters()));
        this.setMaxStats(element.getInt(ENGINE_MAX_STATS, this.getMaxStats()));
        this.setUseInfoLarge(element.getBoolean(ENGINE_INFO_MODE_LARGE, this.isUseInfoLarge()));
        this.setUseInfoMedium(element.getBoolean(ENGINE_INFO_MODE_MEDIUM, this.isUseInfoMedium()));
        this.setUseInfoSmall(element.getBoolean(ENGINE_INFO_MODE_SMALL, this.isUseInfoSmall()));
        CostWeights costWeights = new CostWeights();
        if (null != element.getChild("weights")) {
            for (Element element2 : element.getChild("weights").getChildren()) {
                if (element2.getName().equals("weightMovingSite")) {
                    costWeights.setWeightMovingSite(element2.getDouble("value"));
                    continue;
                }
                int n = element2.getInt("id");
                double d = element2.getDouble("value");
                costWeights.setWeight(n, d);
            }
        }
        this.setWeights(costWeights);
    }

    private void parseBuffer(String string) {
        BufferCompatible bufferCompatible = new BufferCompatible(string);
        this.setClearSchedule(bufferCompatible.getBoolean(ENGINE_CLEAR_SCHEDULE, true));
        this.setEngineHost(bufferCompatible.getValue(ENGINE_HOST, ""));
        this.setEnginePort(bufferCompatible.getValue(ENGINE_PORT, ""));
        this.setIterationMax(bufferCompatible.getInt(ENGINE_ITERATION_MAX, 100));
        this.setLockDates(bufferCompatible.getBoolean(ENGINE_LOCK_DATES, false));
        this.setLockResources(bufferCompatible.getBoolean(ENGINE_LOCK_RESOURCES, false));
        this.setRunDara(bufferCompatible.getBoolean(ENGINE_RUN_DARA, true));
        this.setRunOptimCosts(bufferCompatible.getBoolean(ENGINE_RUN_OPTIM_COSTS, false));
        this.setRunOptimSites(bufferCompatible.getBoolean(ENGINE_RUN_OPTIM_SITES, false));
        this.setRunOptimQuality(bufferCompatible.getBoolean(ENGINE_RUN_OPTIM_QUALITY, false));
        this.setSeed(bufferCompatible.getInt(ENGINE_SEED, 0));
        this.setMoreField(bufferCompatible.getValue(ENGINE_FIELD, ""));
        this.setUseContinuity(bufferCompatible.getBoolean(ENGINE_USE_CONTINUITY, true));
        this.setUseCounters(bufferCompatible.getBoolean(ENGINE_USE_COUNTERS, true));
        this.setUseCourseTF(bufferCompatible.getBoolean(ENGINE_USE_COURSE_TF, true));
        this.setUseEntityTF(bufferCompatible.getBoolean(ENGINE_USE_ENTITY_TF, true));
        this.setUseEntityCosts(bufferCompatible.getBoolean(ENGINE_USE_COSTS, true));
        this.setUseEntitySites(bufferCompatible.getBoolean(ENGINE_USE_SITES, true));
        this.setSendLunch(bufferCompatible.getBoolean(ENGINE_SEND_LUNCH, true));
        this.setFirstWeek(bufferCompatible.getInt(ENGINE_FIRST_WEEK, 0));
        this.setLastWeek(bufferCompatible.getInt(ENGINE_LAST_WEEK, 0));
        this.setPartial(bufferCompatible.getBoolean(ENGINE_PARTIAL, false));
        this.setRemoveVirtual(bufferCompatible.getBoolean(ENGINE_REMOVE_VIRTUAL, false));
        this.setScheduleDaraHeuristic(bufferCompatible.getInt(ENGINE_DARA_HEURISTIC, 0));
        this.setScheduleAllocationHeuristic(bufferCompatible.getInt(ENGINE_REALLOCATION_HEURISTIC, 0));
        this.setScheduleSearchSpeed(bufferCompatible.getInt(ENGINE_RESOURCE_EXHAUSTIVE, 0));
        this.setQualityMinGap(bufferCompatible.getInt(ENGINE_MIN_GAP_SIZE, 1));
        this.setQualityMaxGap(bufferCompatible.getInt(ENGINE_MAX_GAP_SIZE, 2));
        this.setQualityWeight(bufferCompatible.getFloat(ENGINE_QUALITY_WEIGHT, 100.0f));
        this.setQualityIterations(bufferCompatible.getInt(ENGINE_QUALITY_ITERATIONS, 5));
        this.setOptimHeuristicsBuffer(bufferCompatible.getValue(ENGINE_OPTIMIZATION_HEURISTICS, ""));
        this.setStageMax(bufferCompatible.getInt(ENGINE_STAGE_MAX, 100));
        this.setIterationMax(bufferCompatible.getInt(ENGINE_ITERATION_MAX, 100));
        this.setTemperature(bufferCompatible.getDouble(ENGINE_TEMPERATURE, 15.0));
        this.setImprovementIteration(bufferCompatible.getInt(ENGINE_IMPROVEMENT_ITERATION, 100));
        this.setDefaultDaraParam(bufferCompatible.getBoolean(ENGINE_DEFAULT_DARA, true));
        this.setDefaultOptimParam(bufferCompatible.getBoolean(ENGINE_DEFAULT_OPTIM, false));
        this.setDefaultQualityParam(bufferCompatible.getBoolean(ENGINE_DEFAULT_QUALITY, false));
        this.setWeekLookAhead(bufferCompatible.getInt(ENGINE_WEEK_LOOK_AHEAD, 1));
        try {
            CostWeights costWeights = new CostWeights();
            Iterator iterator = bufferCompatible.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.startsWith("COSTWEIGHT_")) continue;
                int n = Integer.parseInt(string2.substring(11));
                double d = bufferCompatible.getDouble(string2, 1.0);
                costWeights.setWeight(n, d);
            }
            this.setWeights(costWeights);
        }
        catch (Throwable throwable) {
            LOG.error((Object)throwable);
        }
    }
}

