/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.engine.info;

import com.adesoft.collections.ObjectIterator;
import com.adesoft.engine.info.DaraEvent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;

public final class ArrayEvents
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final int DEFAULTSIZE = 2;
    private int count = 0;
    private DaraEvent[] elements = new DaraEvent[2];

    public void add(DaraEvent daraEvent) {
        int n = this.elements.length;
        if (this.count + 1 >= n) {
            DaraEvent[] daraEventArray = new DaraEvent[1 + n * 3 / 2];
            System.arraycopy(this.elements, 0, daraEventArray, 0, n);
            this.elements = daraEventArray;
        }
        this.elements[this.count++] = daraEvent;
    }

    public DaraEvent get(int n) {
        if (n < 0 || n >= this.count) {
            throw new IllegalArgumentException("CourseArray.get()");
        }
        return this.elements[n];
    }

    public Iterator iterator() {
        return new ObjectIterator((Object[])this.elements, this.size());
    }

    public int size() {
        return this.count;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.count);
        for (int i = 0; i < this.count; ++i) {
            this.elements[i].write(dataOutputStream);
        }
    }

    public void read(ByteBuffer byteBuffer) {
        this.count = byteBuffer.getInt();
        this.elements = new DaraEvent[this.count];
        for (int i = 0; i < this.count; ++i) {
            DaraEvent daraEvent = new DaraEvent();
            daraEvent.read(byteBuffer);
            this.elements[i] = daraEvent;
        }
    }
}

