/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.engine.info;

import com.adesoft.engine.HyperlinkInfo;
import com.adesoft.engine.info.ArrayEvents;
import com.adesoft.engine.info.DaraEvent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;

public final class DaraInfo
implements HyperlinkInfo,
Serializable {
    private static final long serialVersionUID = 520L;
    private int backtrackOid;
    private String backtrackName;
    private int best;
    private int current;
    private int total;
    private int nIters;
    private int step;
    private int solutionStatus;
    private double cost;
    private double bestCost;
    private ArrayEvents infoEvents = new ArrayEvents();
    public static final int STATUS_INIT = 6;
    public static final int STATUS_PARTIAL = 0;
    public static final int STATUS_COMPLETE = 1;
    public static final int STATUS_NOSOL = 2;
    public static final int STATUS_OPTIM = 3;
    public static final int STATUS_NOOPTIM = 4;
    public static final int STATUS_OPTIMIZING = 5;
    public static final int STEP_VERIFICATION = 0;
    public static final int STEP_CONVERT_FAILED = 1;
    public static final int STEP_DARA = 2;
    public static final int STEP_DARA_END = 3;
    public static final int STEP_SA = 4;
    public static final int STEP_SA_END = 5;
    public static final int STEP_QUALITY = 8;
    public static final int STEP_QUALITY_END = 9;
    public static final int STEP_INIT1 = 10;
    public static final int STEP_INIT2 = 11;
    public static final int STEP_INIT3 = 12;
    public static final int STEP_INIT4 = 13;
    public static final int STEP_INIT5 = 14;
    public static final int STEP_INIT6 = 15;
    public static final int STEP_INIT7 = 16;
    public static final int STEP_INIT8 = 17;
    public static final int STEP_INIT9 = 18;

    public DaraInfo() {
    }

    public DaraInfo(int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7, String string) {
        this.best = n;
        this.current = n2;
        this.total = n3;
        this.nIters = n4;
        this.step = n5;
        this.solutionStatus = n6;
        this.cost = d2;
        this.bestCost = d;
        this.backtrackOid = n7;
        this.backtrackName = string;
    }

    public void addInfoEvent(DaraEvent daraEvent) {
        this.infoEvents.add(daraEvent);
    }

    public int getBest() {
        return this.best;
    }

    public double getBestCost() {
        return this.bestCost;
    }

    public double getCost() {
        return this.cost;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getNIters() {
        return this.nIters;
    }

    public int getStep() {
        return this.step;
    }

    public int getSolutionStatus() {
        return this.solutionStatus;
    }

    public int getTotal() {
        return this.total;
    }

    public Iterator getInfoEvents() {
        return this.infoEvents.iterator();
    }

    @Override
    public String getName() {
        return this.backtrackName;
    }

    @Override
    public int getOid() {
        return this.backtrackOid;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.backtrackOid);
        dataOutputStream.writeInt(this.backtrackName.length());
        dataOutputStream.writeBytes(this.backtrackName);
        dataOutputStream.writeInt(this.best);
        dataOutputStream.writeInt(this.current);
        dataOutputStream.writeInt(this.total);
        dataOutputStream.writeInt(this.nIters);
        dataOutputStream.writeInt(this.step);
        dataOutputStream.writeInt(this.solutionStatus);
        dataOutputStream.writeDouble(this.cost);
        dataOutputStream.writeDouble(this.bestCost);
        this.infoEvents.write(dataOutputStream);
        dataOutputStream.flush();
    }

    public void read(ByteBuffer byteBuffer) {
        this.backtrackOid = byteBuffer.getInt();
        int n = byteBuffer.getInt();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        this.backtrackName = new String(byArray, 0, n);
        this.best = byteBuffer.getInt();
        this.current = byteBuffer.getInt();
        this.total = byteBuffer.getInt();
        this.nIters = byteBuffer.getInt();
        this.step = byteBuffer.getInt();
        this.solutionStatus = byteBuffer.getInt();
        this.cost = byteBuffer.getDouble();
        this.bestCost = byteBuffer.getDouble();
        this.infoEvents = new ArrayEvents();
        this.infoEvents.read(byteBuffer);
    }

    public String toString() {
        return "DaraInfo: " + this.nIters + ", " + this.step + ", " + this.solutionStatus;
    }
}

