/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.extractor;

import com.adesoft.config.ServerLocation;
import com.adesoft.errors.AdeException;
import com.adesoft.errors.EntityGroupError;
import com.adesoft.extractor.Extractor;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import org.jdom.Element;
import org.jdom.JDOMException;

public final class ExtractorBean {
    private static final String DEFAULT_NAME = "extractor";
    private volatile Extractor extractor;
    private String serverAde;
    private int serverAdePort;
    private String identifier;

    public ExtractorBean() {
        this.setServerAde(ServerLocation.getInstance().getServerHost());
        this.setServerAdePort(ServerLocation.getInstance().getServerPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extractor getRemote() {
        if (null == this.extractor) {
            ExtractorBean extractorBean = this;
            synchronized (extractorBean) {
                if (null == this.extractor) {
                    try {
                        this.extractor = (Extractor)Naming.lookup("rmi://" + this.serverAde + ':' + this.serverAdePort + '/' + DEFAULT_NAME);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new RuntimeException("Wrong server URL : " + malformedURLException);
                    }
                    catch (NotBoundException notBoundException) {
                        throw new RuntimeException("Server is not bound : " + notBoundException);
                    }
                    catch (RemoteException remoteException) {
                        throw new RuntimeException("Network error : " + remoteException);
                    }
                }
            }
        }
        return this.extractor;
    }

    public void setServerAde(String string) {
        this.serverAde = string;
    }

    public void setServerAdePort(int n) {
        this.serverAdePort = n;
    }

    public void setConnection(String string) {
        this.identifier = string;
    }

    public int export(int n, boolean bl) throws RemoteException, SQLException, JDOMException, AdeException, EntityGroupError, ClassNotFoundException {
        return this.getRemote().export(this.getIdentifier(), n, bl, true);
    }

    public int export(int n, int n2, boolean bl) throws RemoteException, SQLException, JDOMException, AdeException, EntityGroupError, ClassNotFoundException {
        return this.getRemote().export(this.getIdentifier(), n, n2, bl, true);
    }

    public void deleteSnapshotProject(int n) throws RemoteException, SQLException {
        this.getRemote().deleteSnapshotProject(this.getIdentifier(), n);
    }

    public void clearAllProjects() throws RemoteException, SQLException {
        this.getRemote().clearAllProjects(this.getIdentifier());
    }

    public Element getProjects() throws RemoteException, SQLException, ClassNotFoundException {
        return this.getRemote().getProjects();
    }

    public void setDebugMode(boolean bl) throws RemoteException {
        this.getRemote().setDebugMode(bl);
    }

    public String getLastQueries() throws RemoteException {
        return this.getRemote().getLastQueries();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setJdbcSource(String string) throws RemoteException {
        this.getRemote().setJdbcSource(string);
    }

    public void setJdbcDriver(String string) throws RemoteException {
        this.getRemote().setJdbcDriver(string);
    }

    public void setUser(String string) throws RemoteException {
        this.getRemote().setUser(string);
    }

    public void setPassword(String string) throws RemoteException {
        this.getRemote().setPassword(string);
    }

    public void resetDBParameters() throws RemoteException {
        this.getRemote().resetDBParameters();
    }
}

