/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.fields;

import com.adesoft.fields.Filterable;
import com.adesoft.filters.DFilter;
import com.adesoft.filters.Operators;
import java.io.Serializable;

public final class BooleanField
implements Filterable,
Serializable {
    private static final long serialVersionUID = 520L;
    public static final BooleanField FALSE = new BooleanField(false);
    public static final BooleanField TRUE = new BooleanField(true);
    private final boolean value;

    private BooleanField(boolean bl) {
        this.value = bl;
    }

    public static BooleanField get(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @Override
    public int intValue() {
        return this.value ? 1 : 0;
    }

    @Override
    public long longValue() {
        return this.value ? 1L : 0L;
    }

    @Override
    public double doubleValue() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public float floatValue() {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    public final boolean booleanValue() {
        return this.value;
    }

    @Override
    public int compare(Object object) {
        boolean bl;
        if (this == object) {
            return 0;
        }
        boolean bl2 = this.booleanValue();
        return bl2 == (bl = ((BooleanField)object).booleanValue()) ? 0 : (bl2 ? 1 : -1);
    }

    @Override
    public String toString() {
        return this.value ? "true" : "false";
    }

    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    @Override
    public boolean check(DFilter dFilter) {
        return Operators.test(dFilter.getOperator(), this.booleanValue());
    }
}

