/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.fields;

import com.adesoft.fields.Filterable;
import com.adesoft.filters.DFilter;
import com.adesoft.filters.Operators;
import java.io.Serializable;

public final class DoubleField
extends Number
implements Filterable,
Serializable {
    private static final long serialVersionUID = 520L;
    private final double value;

    public DoubleField(double d) {
        this.value = d;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean booleanValue() {
        return 1.0 == this.value;
    }

    @Override
    public int compare(Object object) {
        double d = this.value;
        double d2 = ((DoubleField)object).value;
        return d < d2 ? -1 : (d == d2 ? 0 : 1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DoubleField) {
            return this.value == ((DoubleField)object).value;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public boolean check(DFilter dFilter) {
        return Operators.test(dFilter.getOperator(), this.doubleValue(), dFilter.getDoubleValue());
    }
}

